/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.FlowableReadStream;
import io.vertx.rxjava3.impl.FlowableUnmarshaller;
import io.vertx.rxjava3.impl.ReadStreamSubscriber;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;

public class FlowableHelper {
    private static final FlowableSubscriber NULL_OBSERVER = new FlowableSubscriber(){

        public void onSubscribe(@NonNull Subscription s) {
        }

        public void onNext(Object o) {
        }

        public void onComplete() {
        }

        public void onError(@NonNull Throwable e) {
        }
    };

    public static <T> FlowableSubscriber<T> nullObserver() {
        return NULL_OBSERVER;
    }

    public static <T> ReadStream<T> toReadStream(Flowable<T> observable) {
        return ReadStreamSubscriber.asReadStream(observable, Function.identity());
    }

    public static <T, U> Flowable<U> toFlowable(ReadStream<T> stream, Function<T, U> mapping) {
        return RxJavaPlugins.onAssembly(new FlowableReadStream<T, U>(stream, 256L, mapping));
    }

    public static <T> Flowable<T> toFlowable(ReadStream<T> stream) {
        return RxJavaPlugins.onAssembly(new FlowableReadStream(stream, 256L, Function.identity()));
    }

    public static <T> Flowable<T> toFlowable(ReadStream<T> stream, long maxBufferSize) {
        return RxJavaPlugins.onAssembly(new FlowableReadStream(stream, maxBufferSize, Function.identity()));
    }

    public static <T> Flowable<T> toFlowable(Supplier<Future<ReadStream<T>>> supplier) {
        Single<Flowable> single = AsyncResultSingle.toSingle(supplier, FlowableHelper::toFlowable);
        return single.flatMapPublisher(f -> f);
    }

    public static <T> FlowableTransformer<Buffer, T> unmarshaller(Class<T> mappedType) {
        return new FlowableUnmarshaller(Function.identity(), mappedType);
    }

    public static <T> FlowableTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef) {
        return new FlowableUnmarshaller(Function.identity(), mappedTypeRef);
    }

    public static <T> FlowableTransformer<Buffer, T> unmarshaller(Class<T> mappedType, ObjectCodec mapper) {
        return new FlowableUnmarshaller(Function.identity(), mappedType, mapper);
    }

    public static <T> FlowableTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef, ObjectCodec mapper) {
        return new FlowableUnmarshaller(Function.identity(), mappedTypeRef, mapper);
    }
}

