/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.mongo;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.GridFsDownloadOptions;
import io.vertx.ext.mongo.GridFsUploadOptions;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.ReadStreamSubscriber;
import java.util.List;

@RxGen(value=io.vertx.ext.mongo.MongoGridFsClient.class)
public class MongoGridFsClient
implements RxDelegate {
    public static final TypeArg<MongoGridFsClient> __TYPE_ARG = new TypeArg(obj -> new MongoGridFsClient((io.vertx.ext.mongo.MongoGridFsClient)obj), MongoGridFsClient::getDelegate);
    private final io.vertx.ext.mongo.MongoGridFsClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoGridFsClient that = (MongoGridFsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MongoGridFsClient(io.vertx.ext.mongo.MongoGridFsClient delegate) {
        this.delegate = delegate;
    }

    public MongoGridFsClient(Object delegate) {
        this.delegate = (io.vertx.ext.mongo.MongoGridFsClient)delegate;
    }

    public io.vertx.ext.mongo.MongoGridFsClient getDelegate() {
        return this.delegate;
    }

    public Future<Void> delete(String id) {
        Future ret = this.delegate.delete(id).map(val -> val);
        return ret;
    }

    public Completable rxDelete(String id) {
        return AsyncResultCompletable.toCompletable($handler -> this.delete(id).onComplete($handler));
    }

    public ReadStream<Buffer> readByFileName(String fileName) {
        ReadStream<Buffer> ret = ReadStream.newInstance(this.delegate.readByFileName(fileName), TypeArg.unknown());
        return ret;
    }

    public ReadStream<Buffer> readByFileNameWithOptions(String fileName, GridFsDownloadOptions options) {
        ReadStream<Buffer> ret = ReadStream.newInstance(this.delegate.readByFileNameWithOptions(fileName, options), TypeArg.unknown());
        return ret;
    }

    public ReadStream<Buffer> readById(String id) {
        ReadStream<Buffer> ret = ReadStream.newInstance(this.delegate.readById(id), TypeArg.unknown());
        return ret;
    }

    public Future<Long> downloadByFileName(WriteStream<Buffer> stream, String fileName) {
        Future ret = this.delegate.downloadByFileName(stream.getDelegate(), fileName).map(val -> val);
        return ret;
    }

    public Single<Long> rxDownloadByFileName(WriteStream<Buffer> stream, String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.downloadByFileName(stream, fileName).onComplete($handler));
    }

    public Future<Long> downloadByFileNameWithOptions(WriteStream<Buffer> stream, String fileName, GridFsDownloadOptions options) {
        Future ret = this.delegate.downloadByFileNameWithOptions(stream.getDelegate(), fileName, options).map(val -> val);
        return ret;
    }

    public Single<Long> rxDownloadByFileNameWithOptions(WriteStream<Buffer> stream, String fileName, GridFsDownloadOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.downloadByFileNameWithOptions(stream, fileName, options).onComplete($handler));
    }

    public Future<Long> downloadById(WriteStream<Buffer> stream, String id) {
        Future ret = this.delegate.downloadById(stream.getDelegate(), id).map(val -> val);
        return ret;
    }

    public Single<Long> rxDownloadById(WriteStream<Buffer> stream, String id) {
        return AsyncResultSingle.toSingle($handler -> this.downloadById(stream, id).onComplete($handler));
    }

    public Future<Long> downloadFile(String fileName) {
        Future ret = this.delegate.downloadFile(fileName).map(val -> val);
        return ret;
    }

    public Single<Long> rxDownloadFile(String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.downloadFile(fileName).onComplete($handler));
    }

    public Future<Long> downloadFileAs(String fileName, String newFileName) {
        Future ret = this.delegate.downloadFileAs(fileName, newFileName).map(val -> val);
        return ret;
    }

    public Single<Long> rxDownloadFileAs(String fileName, String newFileName) {
        return AsyncResultSingle.toSingle($handler -> this.downloadFileAs(fileName, newFileName).onComplete($handler));
    }

    public Future<Long> downloadFileByID(String id, String fileName) {
        Future ret = this.delegate.downloadFileByID(id, fileName).map(val -> val);
        return ret;
    }

    public Single<Long> rxDownloadFileByID(String id, String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.downloadFileByID(id, fileName).onComplete($handler));
    }

    public Future<Void> drop() {
        Future ret = this.delegate.drop().map(val -> val);
        return ret;
    }

    public Completable rxDrop() {
        return AsyncResultCompletable.toCompletable($handler -> this.drop().onComplete($handler));
    }

    public Future<List<String>> findAllIds() {
        Future ret = this.delegate.findAllIds().map(val -> val);
        return ret;
    }

    public Single<List<String>> rxFindAllIds() {
        return AsyncResultSingle.toSingle($handler -> this.findAllIds().onComplete($handler));
    }

    public Future<List<String>> findIds(JsonObject query) {
        Future ret = this.delegate.findIds(query).map(val -> val);
        return ret;
    }

    public Single<List<String>> rxFindIds(JsonObject query) {
        return AsyncResultSingle.toSingle($handler -> this.findIds(query).onComplete($handler));
    }

    public Future<String> uploadByFileName(ReadStream<Buffer> stream, String fileName) {
        Future ret = this.delegate.uploadByFileName(stream.getDelegate(), fileName).map(val -> val);
        return ret;
    }

    public Single<String> rxUploadByFileName(ReadStream<Buffer> stream, String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.uploadByFileName(stream, fileName).onComplete($handler));
    }

    public Future<String> uploadByFileName(Flowable<Buffer> stream, String fileName) {
        Future ret = this.delegate.uploadByFileName(ReadStreamSubscriber.asReadStream(stream, obj -> obj).resume(), fileName).map(val -> val);
        return ret;
    }

    public Single<String> rxUploadByFileName(Flowable<Buffer> stream, String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.uploadByFileName(stream, fileName).onComplete($handler));
    }

    public Future<String> uploadByFileNameWithOptions(ReadStream<Buffer> stream, String fileName, GridFsUploadOptions options) {
        Future ret = this.delegate.uploadByFileNameWithOptions(stream.getDelegate(), fileName, options).map(val -> val);
        return ret;
    }

    public Single<String> rxUploadByFileNameWithOptions(ReadStream<Buffer> stream, String fileName, GridFsUploadOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.uploadByFileNameWithOptions(stream, fileName, options).onComplete($handler));
    }

    public Future<String> uploadByFileNameWithOptions(Flowable<Buffer> stream, String fileName, GridFsUploadOptions options) {
        Future ret = this.delegate.uploadByFileNameWithOptions(ReadStreamSubscriber.asReadStream(stream, obj -> obj).resume(), fileName, options).map(val -> val);
        return ret;
    }

    public Single<String> rxUploadByFileNameWithOptions(Flowable<Buffer> stream, String fileName, GridFsUploadOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.uploadByFileNameWithOptions(stream, fileName, options).onComplete($handler));
    }

    public Future<String> uploadFile(String fileName) {
        Future ret = this.delegate.uploadFile(fileName).map(val -> val);
        return ret;
    }

    public Single<String> rxUploadFile(String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.uploadFile(fileName).onComplete($handler));
    }

    public Future<String> uploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        Future ret = this.delegate.uploadFileWithOptions(fileName, options).map(val -> val);
        return ret;
    }

    public Single<String> rxUploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.uploadFileWithOptions(fileName, options).onComplete($handler));
    }

    public void close() {
        this.delegate.close();
    }

    public static MongoGridFsClient newInstance(io.vertx.ext.mongo.MongoGridFsClient arg) {
        return arg != null ? new MongoGridFsClient(arg) : null;
    }
}

