/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.stomp;

import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.stomp.Frame;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.Map;

@RxGen(value=io.vertx.ext.stomp.StompClientConnection.class)
public class StompClientConnection
implements RxDelegate {
    public static final TypeArg<StompClientConnection> __TYPE_ARG = new TypeArg(obj -> new StompClientConnection((io.vertx.ext.stomp.StompClientConnection)obj), StompClientConnection::getDelegate);
    private final io.vertx.ext.stomp.StompClientConnection delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StompClientConnection that = (StompClientConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public StompClientConnection(io.vertx.ext.stomp.StompClientConnection delegate) {
        this.delegate = delegate;
    }

    public StompClientConnection(Object delegate) {
        this.delegate = (io.vertx.ext.stomp.StompClientConnection)delegate;
    }

    public io.vertx.ext.stomp.StompClientConnection getDelegate() {
        return this.delegate;
    }

    public String session() {
        String ret = this.delegate.session();
        return ret;
    }

    public String version() {
        String ret = this.delegate.version();
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public String server() {
        String ret = this.delegate.server();
        return ret;
    }

    public Future<Frame> send(Map<String, String> headers, Buffer body) {
        Future ret = this.delegate.send(headers, body).map(val -> val);
        return ret;
    }

    public Single<Frame> rxSend(Map<String, String> headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(headers, body).onComplete($handler));
    }

    public Future<Frame> send(String destination, Buffer body) {
        Future ret = this.delegate.send(destination, body).map(val -> val);
        return ret;
    }

    public Single<Frame> rxSend(String destination, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(destination, body).onComplete($handler));
    }

    public Future<Frame> send(Frame frame) {
        Future ret = this.delegate.send(frame).map(val -> val);
        return ret;
    }

    public Single<Frame> rxSend(Frame frame) {
        return AsyncResultSingle.toSingle($handler -> this.send(frame).onComplete($handler));
    }

    public Future<Frame> send(String destination, Map<String, String> headers, Buffer body) {
        Future ret = this.delegate.send(destination, headers, body).map(val -> val);
        return ret;
    }

    public Single<Frame> rxSend(String destination, Map<String, String> headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(destination, headers, body).onComplete($handler));
    }

    public Future<String> subscribe(String destination, Handler<Frame> handler) {
        Future ret = this.delegate.subscribe(destination, handler).map(val -> val);
        return ret;
    }

    public Single<String> rxSubscribe(String destination, Handler<Frame> handler) {
        return AsyncResultSingle.toSingle($handler -> this.subscribe(destination, handler).onComplete($handler));
    }

    public Future<String> subscribe(String destination, Map<String, String> headers, Handler<Frame> handler) {
        Future ret = this.delegate.subscribe(destination, headers, handler).map(val -> val);
        return ret;
    }

    public Single<String> rxSubscribe(String destination, Map<String, String> headers, Handler<Frame> handler) {
        return AsyncResultSingle.toSingle($handler -> this.subscribe(destination, headers, handler).onComplete($handler));
    }

    public Future<Frame> unsubscribe(String destination) {
        Future ret = this.delegate.unsubscribe(destination).map(val -> val);
        return ret;
    }

    public Single<Frame> rxUnsubscribe(String destination) {
        return AsyncResultSingle.toSingle($handler -> this.unsubscribe(destination).onComplete($handler));
    }

    public Future<Frame> unsubscribe(String destination, Map<String, String> headers) {
        Future ret = this.delegate.unsubscribe(destination, headers).map(val -> val);
        return ret;
    }

    public Single<Frame> rxUnsubscribe(String destination, Map<String, String> headers) {
        return AsyncResultSingle.toSingle($handler -> this.unsubscribe(destination, headers).onComplete($handler));
    }

    public StompClientConnection errorHandler(Handler<Frame> handler) {
        StompClientConnection ret = StompClientConnection.newInstance(this.delegate.errorHandler(handler));
        return ret;
    }

    public StompClientConnection closeHandler(Handler<StompClientConnection> handler) {
        this.delegate.closeHandler(Helper.convertHandler(handler, event -> StompClientConnection.newInstance(event)));
        return this;
    }

    public StompClientConnection connectionDroppedHandler(Handler<StompClientConnection> handler) {
        this.delegate.connectionDroppedHandler(Helper.convertHandler(handler, event -> StompClientConnection.newInstance(event)));
        return this;
    }

    public StompClientConnection pingHandler(Handler<StompClientConnection> handler) {
        this.delegate.pingHandler(Helper.convertHandler(handler, event -> StompClientConnection.newInstance(event)));
        return this;
    }

    public Future<Frame> beginTX(String id) {
        Future ret = this.delegate.beginTX(id).map(val -> val);
        return ret;
    }

    public Single<Frame> rxBeginTX(String id) {
        return AsyncResultSingle.toSingle($handler -> this.beginTX(id).onComplete($handler));
    }

    public Future<Frame> beginTX(String id, Map<String, String> headers) {
        Future ret = this.delegate.beginTX(id, headers).map(val -> val);
        return ret;
    }

    public Single<Frame> rxBeginTX(String id, Map<String, String> headers) {
        return AsyncResultSingle.toSingle($handler -> this.beginTX(id, headers).onComplete($handler));
    }

    public Future<Frame> commit(String id) {
        Future ret = this.delegate.commit(id).map(val -> val);
        return ret;
    }

    public Single<Frame> rxCommit(String id) {
        return AsyncResultSingle.toSingle($handler -> this.commit(id).onComplete($handler));
    }

    public Future<Frame> commit(String id, Map<String, String> headers) {
        Future ret = this.delegate.commit(id, headers).map(val -> val);
        return ret;
    }

    public Single<Frame> rxCommit(String id, Map<String, String> headers) {
        return AsyncResultSingle.toSingle($handler -> this.commit(id, headers).onComplete($handler));
    }

    public Future<Frame> abort(String id) {
        Future ret = this.delegate.abort(id).map(val -> val);
        return ret;
    }

    public Single<Frame> rxAbort(String id) {
        return AsyncResultSingle.toSingle($handler -> this.abort(id).onComplete($handler));
    }

    public Future<Frame> abort(String id, Map<String, String> headers) {
        Future ret = this.delegate.abort(id, headers).map(val -> val);
        return ret;
    }

    public Single<Frame> rxAbort(String id, Map<String, String> headers) {
        return AsyncResultSingle.toSingle($handler -> this.abort(id, headers).onComplete($handler));
    }

    public Future<Frame> disconnect() {
        Future ret = this.delegate.disconnect().map(val -> val);
        return ret;
    }

    public Single<Frame> rxDisconnect() {
        return AsyncResultSingle.toSingle($handler -> this.disconnect().onComplete($handler));
    }

    public Future<Frame> disconnect(Frame frame) {
        Future ret = this.delegate.disconnect(frame).map(val -> val);
        return ret;
    }

    public Single<Frame> rxDisconnect(Frame frame) {
        return AsyncResultSingle.toSingle($handler -> this.disconnect(frame).onComplete($handler));
    }

    public Future<Frame> ack(String id) {
        Future ret = this.delegate.ack(id).map(val -> val);
        return ret;
    }

    public Single<Frame> rxAck(String id) {
        return AsyncResultSingle.toSingle($handler -> this.ack(id).onComplete($handler));
    }

    public Future<Frame> nack(String id) {
        Future ret = this.delegate.nack(id).map(val -> val);
        return ret;
    }

    public Single<Frame> rxNack(String id) {
        return AsyncResultSingle.toSingle($handler -> this.nack(id).onComplete($handler));
    }

    public Future<Frame> ack(String id, String txId) {
        Future ret = this.delegate.ack(id, txId).map(val -> val);
        return ret;
    }

    public Single<Frame> rxAck(String id, String txId) {
        return AsyncResultSingle.toSingle($handler -> this.ack(id, txId).onComplete($handler));
    }

    public Future<Frame> nack(String id, String txId) {
        Future ret = this.delegate.nack(id, txId).map(val -> val);
        return ret;
    }

    public Single<Frame> rxNack(String id, String txId) {
        return AsyncResultSingle.toSingle($handler -> this.nack(id, txId).onComplete($handler));
    }

    public StompClientConnection receivedFrameHandler(Handler<Frame> handler) {
        this.delegate.receivedFrameHandler(handler);
        return this;
    }

    public StompClientConnection writingFrameHandler(Handler<Frame> handler) {
        this.delegate.writingFrameHandler(handler);
        return this;
    }

    public StompClientConnection exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.delegate.exceptionHandler(exceptionHandler);
        return this;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public static StompClientConnection newInstance(io.vertx.ext.stomp.StompClientConnection arg) {
        return arg != null ? new StompClientConnection(arg) : null;
    }
}

