/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.net;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.net.ServerSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrafficShapingOptions;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.net.NetSocket;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.concurrent.TimeUnit;

@RxGen(value=io.vertx.core.net.NetServer.class)
public class NetServer
implements Measured {
    public static final TypeArg<NetServer> __TYPE_ARG = new TypeArg(obj -> new NetServer((io.vertx.core.net.NetServer)obj), NetServer::getDelegate);
    private final io.vertx.core.net.NetServer delegate;
    private static final TypeArg<NetServer> TYPE_ARG_0 = new TypeArg(o1 -> NetServer.newInstance((io.vertx.core.net.NetServer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<NetServer> TYPE_ARG_1 = new TypeArg(o1 -> NetServer.newInstance((io.vertx.core.net.NetServer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<NetServer> TYPE_ARG_2 = new TypeArg(o1 -> NetServer.newInstance((io.vertx.core.net.NetServer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<NetServer> TYPE_ARG_3 = new TypeArg(o1 -> NetServer.newInstance((io.vertx.core.net.NetServer)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetServer that = (NetServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetServer(io.vertx.core.net.NetServer delegate) {
        this.delegate = delegate;
    }

    public NetServer(Object delegate) {
        this.delegate = (io.vertx.core.net.NetServer)delegate;
    }

    public io.vertx.core.net.NetServer getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public NetServer connectHandler(Handler<NetSocket> handler) {
        NetServer ret = NetServer.newInstance(this.delegate.connectHandler((Handler)new DelegatingHandler(handler, event -> NetSocket.newInstance(event))));
        return ret;
    }

    public Future<NetServer> listen() {
        Future ret = this.delegate.listen().map(val -> NetServer.newInstance(val));
        return ret;
    }

    public Single<NetServer> rxListen() {
        return AsyncResultSingle.toSingle($handler -> this.listen().onComplete($handler));
    }

    public Future<NetServer> listen(int port, String host) {
        Future ret = this.delegate.listen(port, host).map(val -> NetServer.newInstance(val));
        return ret;
    }

    public Single<NetServer> rxListen(int port, String host) {
        return AsyncResultSingle.toSingle($handler -> this.listen(port, host).onComplete($handler));
    }

    public Future<NetServer> listen(int port) {
        Future ret = this.delegate.listen(port).map(val -> NetServer.newInstance(val));
        return ret;
    }

    public Single<NetServer> rxListen(int port) {
        return AsyncResultSingle.toSingle($handler -> this.listen(port).onComplete($handler));
    }

    public Future<NetServer> listen(SocketAddress localAddress) {
        Future ret = this.delegate.listen(localAddress).map(val -> NetServer.newInstance(val));
        return ret;
    }

    public Single<NetServer> rxListen(SocketAddress localAddress) {
        return AsyncResultSingle.toSingle($handler -> this.listen(localAddress).onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<Void> shutdown() {
        Future ret = this.delegate.shutdown().map(val -> val);
        return ret;
    }

    public Completable rxShutdown() {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown().onComplete($handler));
    }

    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        Future ret = this.delegate.shutdown(timeout, unit).map(val -> val);
        return ret;
    }

    public Completable rxShutdown(long timeout, TimeUnit unit) {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown(timeout, unit).onComplete($handler));
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public Future<Boolean> updateSSLOptions(ServerSSLOptions options) {
        Future ret = this.delegate.updateSSLOptions(options).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ServerSSLOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options).onComplete($handler));
    }

    public Future<Boolean> updateSSLOptions(ServerSSLOptions options, boolean force) {
        Future ret = this.delegate.updateSSLOptions(options, force).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ServerSSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options, force).onComplete($handler));
    }

    public void updateTrafficShapingOptions(TrafficShapingOptions options) {
        this.delegate.updateTrafficShapingOptions(options);
    }

    public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
        return arg != null ? new NetServer(arg) : null;
    }
}

