/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.sqlclient;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.net.NetClientOptions;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.sqlclient.SqlConnection;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.List;
import java.util.function.Supplier;

@RxGen(value=io.vertx.sqlclient.ClientBuilder.class)
public class ClientBuilder<C> {
    public static final TypeArg<ClientBuilder> __TYPE_ARG = new TypeArg(obj -> new ClientBuilder((io.vertx.sqlclient.ClientBuilder)obj), ClientBuilder::getDelegate);
    private final io.vertx.sqlclient.ClientBuilder<C> delegate;
    public final TypeArg<C> __typeArg_0;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientBuilder that = (ClientBuilder)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ClientBuilder(io.vertx.sqlclient.ClientBuilder delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public ClientBuilder(Object delegate, TypeArg<C> typeArg_0) {
        this.delegate = (io.vertx.sqlclient.ClientBuilder)delegate;
        this.__typeArg_0 = typeArg_0;
    }

    public io.vertx.sqlclient.ClientBuilder getDelegate() {
        return this.delegate;
    }

    public ClientBuilder<C> with(PoolOptions options) {
        this.delegate.with(options);
        return this;
    }

    public ClientBuilder<C> with(NetClientOptions options) {
        this.delegate.with(options);
        return this;
    }

    public ClientBuilder<C> connectingTo(SqlConnectOptions database) {
        this.delegate.connectingTo(database);
        return this;
    }

    public ClientBuilder<C> connectingTo(String database) {
        this.delegate.connectingTo(database);
        return this;
    }

    public ClientBuilder<C> connectingTo(final Supplier<Future<SqlConnectOptions>> supplier) {
        this.delegate.connectingTo((Supplier)new Supplier<Future<SqlConnectOptions>>(){

            @Override
            public Future<SqlConnectOptions> get() {
                Future ret = (Future)supplier.get();
                return ret.map(val -> val);
            }
        });
        return this;
    }

    public ClientBuilder<C> connectingTo(List<SqlConnectOptions> databases) {
        this.delegate.connectingTo(databases);
        return this;
    }

    public ClientBuilder<C> using(Vertx vertx) {
        this.delegate.using(vertx.getDelegate());
        return this;
    }

    public ClientBuilder<C> withConnectHandler(Handler<SqlConnection> handler) {
        this.delegate.withConnectHandler((Handler)new DelegatingHandler(handler, event -> SqlConnection.newInstance(event)));
        return this;
    }

    public C build() {
        Object ret = this.__typeArg_0.wrap(this.delegate.build());
        return (C)ret;
    }

    public static <C> ClientBuilder<C> newInstance(io.vertx.sqlclient.ClientBuilder arg) {
        return arg != null ? new ClientBuilder<C>(arg) : null;
    }

    public static <C> ClientBuilder<C> newInstance(io.vertx.sqlclient.ClientBuilder arg, TypeArg<C> __typeArg_C) {
        return arg != null ? new ClientBuilder<C>(arg, __typeArg_C) : null;
    }
}

