/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.streams.WriteStream;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.ReadStreamSubscriber;
import java.util.Set;

@RxGen(value=io.vertx.core.http.HttpServerResponse.class)
public class HttpServerResponse
implements io.vertx.reactivex.core.streams.WriteStream<Buffer> {
    public static final TypeArg<HttpServerResponse> __TYPE_ARG = new TypeArg(obj -> new HttpServerResponse((io.vertx.core.http.HttpServerResponse)obj), HttpServerResponse::getDelegate);
    private final io.vertx.core.http.HttpServerResponse delegate;
    private WriteStreamObserver<Buffer> observer;
    private WriteStreamSubscriber<Buffer> subscriber;
    private static final TypeArg<HttpServerResponse> TYPE_ARG_0 = new TypeArg(o1 -> HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServerResponse> TYPE_ARG_1 = new TypeArg(o1 -> HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServerResponse> TYPE_ARG_2 = new TypeArg(o1 -> HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServerResponse> TYPE_ARG_3 = new TypeArg(o1 -> HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServerResponse> TYPE_ARG_4 = new TypeArg(o1 -> HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)o1), o1 -> o1.getDelegate());
    private MultiMap cached_0;
    private MultiMap cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerResponse that = (HttpServerResponse)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServerResponse(io.vertx.core.http.HttpServerResponse delegate) {
        this.delegate = delegate;
    }

    public HttpServerResponse(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServerResponse)delegate;
    }

    public io.vertx.core.http.HttpServerResponse getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized WriteStreamObserver<Buffer> toObserver() {
        if (this.observer == null) {
            this.observer = RxHelper.toObserver((WriteStream)this.getDelegate());
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            this.subscriber = RxHelper.toSubscriber((WriteStream)this.getDelegate());
        }
        return this.subscriber;
    }

    @Override
    public Future<Void> write(Buffer data) {
        Future ret = this.delegate.write((Object)data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWrite(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(data).onComplete($handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpServerResponse drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public int getStatusCode() {
        int ret = this.delegate.getStatusCode();
        return ret;
    }

    public HttpServerResponse setStatusCode(int statusCode) {
        this.delegate.setStatusCode(statusCode);
        return this;
    }

    public String getStatusMessage() {
        String ret = this.delegate.getStatusMessage();
        return ret;
    }

    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.delegate.setStatusMessage(statusMessage);
        return this;
    }

    public HttpServerResponse setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.headers();
        return ret;
    }

    public HttpServerResponse putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.trailers();
        return ret;
    }

    public HttpServerResponse putTrailer(String name, String value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public HttpServerResponse closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public HttpServerResponse endHandler(Handler<Void> handler) {
        this.delegate.endHandler(handler);
        return this;
    }

    public Future<Void> write(String chunk, String enc) {
        Future ret = this.delegate.write(chunk, enc).map(val -> val);
        return ret;
    }

    public Completable rxWrite(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(chunk, enc).onComplete($handler));
    }

    @Override
    public Future<Void> write(String chunk) {
        Future ret = this.delegate.write(chunk).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWrite(String chunk) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(chunk).onComplete($handler));
    }

    public Future<Void> writeContinue() {
        Future ret = this.delegate.writeContinue().map(val -> val);
        return ret;
    }

    public Completable rxWriteContinue() {
        return AsyncResultCompletable.toCompletable($handler -> this.writeContinue().onComplete($handler));
    }

    public Future<Void> writeEarlyHints(MultiMap headers) {
        Future ret = this.delegate.writeEarlyHints(headers).map(val -> val);
        return ret;
    }

    public Completable rxWriteEarlyHints(MultiMap headers) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeEarlyHints(headers).onComplete($handler));
    }

    @Override
    public Future<Void> end(String chunk) {
        Future ret = this.delegate.end(chunk).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd(String chunk) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(chunk).onComplete($handler));
    }

    public Future<Void> end(String chunk, String enc) {
        Future ret = this.delegate.end(chunk, enc).map(val -> val);
        return ret;
    }

    public Completable rxEnd(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(chunk, enc).onComplete($handler));
    }

    @Override
    public Future<Void> end(Buffer chunk) {
        Future ret = this.delegate.end(chunk).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd(Buffer chunk) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(chunk).onComplete($handler));
    }

    @Override
    public Future<Void> end() {
        Future ret = this.delegate.end().map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end().onComplete($handler));
    }

    public Future<Void> send() {
        Future ret = this.delegate.send().map(val -> val);
        return ret;
    }

    public Completable rxSend() {
        return AsyncResultCompletable.toCompletable($handler -> this.send().onComplete($handler));
    }

    public Future<Void> send(String body) {
        Future ret = this.delegate.send(body).map(val -> val);
        return ret;
    }

    public Completable rxSend(String body) {
        return AsyncResultCompletable.toCompletable($handler -> this.send(body).onComplete($handler));
    }

    public Future<Void> send(Buffer body) {
        Future ret = this.delegate.send(body).map(val -> val);
        return ret;
    }

    public Completable rxSend(Buffer body) {
        return AsyncResultCompletable.toCompletable($handler -> this.send(body).onComplete($handler));
    }

    public Future<Void> send(ReadStream<Buffer> body) {
        Future ret = this.delegate.send(body.getDelegate()).map(val -> val);
        return ret;
    }

    public Completable rxSend(ReadStream<Buffer> body) {
        return AsyncResultCompletable.toCompletable($handler -> this.send(body).onComplete($handler));
    }

    public Future<Void> send(Flowable<Buffer> body) {
        Future ret = this.delegate.send(ReadStreamSubscriber.asReadStream(body, obj -> obj).resume()).map(val -> val);
        return ret;
    }

    public Completable rxSend(Flowable<Buffer> body) {
        return AsyncResultCompletable.toCompletable($handler -> this.send(body).onComplete($handler));
    }

    public Future<Void> sendFile(String filename) {
        Future ret = this.delegate.sendFile(filename).map(val -> val);
        return ret;
    }

    public Completable rxSendFile(String filename) {
        return AsyncResultCompletable.toCompletable($handler -> this.sendFile(filename).onComplete($handler));
    }

    public Future<Void> sendFile(String filename, long offset) {
        Future ret = this.delegate.sendFile(filename, offset).map(val -> val);
        return ret;
    }

    public Completable rxSendFile(String filename, long offset) {
        return AsyncResultCompletable.toCompletable($handler -> this.sendFile(filename, offset).onComplete($handler));
    }

    public Future<Void> sendFile(String filename, long offset, long length) {
        Future ret = this.delegate.sendFile(filename, offset, length).map(val -> val);
        return ret;
    }

    public Completable rxSendFile(String filename, long offset, long length) {
        return AsyncResultCompletable.toCompletable($handler -> this.sendFile(filename, offset, length).onComplete($handler));
    }

    public boolean ended() {
        boolean ret = this.delegate.ended();
        return ret;
    }

    public boolean closed() {
        boolean ret = this.delegate.closed();
        return ret;
    }

    public boolean headWritten() {
        boolean ret = this.delegate.headWritten();
        return ret;
    }

    public HttpServerResponse headersEndHandler(Handler<Void> handler) {
        this.delegate.headersEndHandler(handler);
        return this;
    }

    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        this.delegate.bodyEndHandler(handler);
        return this;
    }

    public long bytesWritten() {
        long ret = this.delegate.bytesWritten();
        return ret;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public Future<HttpServerResponse> push(HttpMethod method, String host, String path) {
        Future ret = this.delegate.push(method, host, path).map(val -> HttpServerResponse.newInstance(val));
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path) {
        return AsyncResultSingle.toSingle($handler -> this.push(method, host, path).onComplete($handler));
    }

    public Future<HttpServerResponse> push(HttpMethod method, String path, MultiMap headers) {
        Future ret = this.delegate.push(method, path, headers).map(val -> HttpServerResponse.newInstance(val));
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.push(method, path, headers).onComplete($handler));
    }

    public Future<HttpServerResponse> push(HttpMethod method, String path) {
        Future ret = this.delegate.push(method, path).map(val -> HttpServerResponse.newInstance(val));
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path) {
        return AsyncResultSingle.toSingle($handler -> this.push(method, path).onComplete($handler));
    }

    public Future<HttpServerResponse> push(HttpMethod method, HostAndPort authority, String path, MultiMap headers) {
        Future ret = this.delegate.push(method, authority, path, headers).map(val -> HttpServerResponse.newInstance(val));
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, HostAndPort authority, String path, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.push(method, authority, path, headers).onComplete($handler));
    }

    @Deprecated
    public Future<HttpServerResponse> push(HttpMethod method, String host, String path, MultiMap headers) {
        Future ret = this.delegate.push(method, host, path, headers).map(val -> HttpServerResponse.newInstance(val));
        return ret;
    }

    @Deprecated
    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.push(method, host, path, headers).onComplete($handler));
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public Future<Void> writeCustomFrame(int type, int flags, Buffer payload) {
        Future ret = this.delegate.writeCustomFrame(type, flags, payload).map(val -> val);
        return ret;
    }

    public Completable rxWriteCustomFrame(int type, int flags, Buffer payload) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeCustomFrame(type, flags, payload).onComplete($handler));
    }

    public Future<Void> writeCustomFrame(HttpFrame frame) {
        Future ret = this.delegate.writeCustomFrame(frame).map(val -> val);
        return ret;
    }

    public Completable rxWriteCustomFrame(HttpFrame frame) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeCustomFrame(frame).onComplete($handler));
    }

    public HttpServerResponse setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public HttpServerResponse addCookie(Cookie cookie) {
        this.delegate.addCookie(cookie);
        return this;
    }

    public Cookie removeCookie(String name) {
        Cookie ret = this.delegate.removeCookie(name);
        return ret;
    }

    public Cookie removeCookie(String name, boolean invalidate) {
        Cookie ret = this.delegate.removeCookie(name, invalidate);
        return ret;
    }

    public Set<Cookie> removeCookies(String name) {
        Set ret = this.delegate.removeCookies(name);
        return ret;
    }

    public Set<Cookie> removeCookies(String name, boolean invalidate) {
        Set ret = this.delegate.removeCookies(name, invalidate);
        return ret;
    }

    public Cookie removeCookie(String name, String domain, String path) {
        Cookie ret = this.delegate.removeCookie(name, domain, path);
        return ret;
    }

    public Cookie removeCookie(String name, String domain, String path, boolean invalidate) {
        Cookie ret = this.delegate.removeCookie(name, domain, path, invalidate);
        return ret;
    }

    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpServerResponse putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public HttpServerResponse putTrailer(String name, Iterable<String> values) {
        this.delegate.putTrailer(name, values);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public static HttpServerResponse newInstance(io.vertx.core.http.HttpServerResponse arg) {
        return arg != null ? new HttpServerResponse(arg) : null;
    }
}

