/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.servicediscovery;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.servicediscovery.ServiceReference;
import io.vertx.reactivex.servicediscovery.spi.ServiceExporter;
import io.vertx.reactivex.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.servicediscovery.ServiceDiscovery.class)
public class ServiceDiscovery {
    public static final TypeArg<ServiceDiscovery> __TYPE_ARG = new TypeArg(obj -> new ServiceDiscovery((io.vertx.servicediscovery.ServiceDiscovery)obj), ServiceDiscovery::getDelegate);
    private final io.vertx.servicediscovery.ServiceDiscovery delegate;
    private static final TypeArg<ServiceReference> TYPE_ARG_0 = new TypeArg(o1 -> ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)o1), o1 -> o1.getDelegate());
    public static final String EVENT_TYPE = "type";
    public static final String EVENT_TYPE_BIND = "bind";
    public static final String EVENT_TYPE_RELEASE = "release";
    public static final String EVENT_RECORD = "record";
    public static final String EVENT_ID = "id";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDiscovery that = (ServiceDiscovery)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ServiceDiscovery(io.vertx.servicediscovery.ServiceDiscovery delegate) {
        this.delegate = delegate;
    }

    public ServiceDiscovery(Object delegate) {
        this.delegate = (io.vertx.servicediscovery.ServiceDiscovery)delegate;
    }

    public io.vertx.servicediscovery.ServiceDiscovery getDelegate() {
        return this.delegate;
    }

    public static ServiceDiscovery create(io.vertx.reactivex.core.Vertx vertx, ServiceDiscoveryOptions options) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create((Vertx)vertx.getDelegate(), (ServiceDiscoveryOptions)options));
        return ret;
    }

    public static ServiceDiscovery create(io.vertx.reactivex.core.Vertx vertx) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public ServiceReference getReference(Record record) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReference(record));
        return ret;
    }

    public ServiceReference getReferenceWithConfiguration(Record record, JsonObject configuration) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReferenceWithConfiguration(record, configuration));
        return ret;
    }

    public boolean release(ServiceReference reference) {
        boolean ret = this.delegate.release(reference.getDelegate());
        return ret;
    }

    public ServiceDiscovery registerServiceImporter(ServiceImporter importer, JsonObject configuration, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.registerServiceImporter(importer.getDelegate(), configuration, completionHandler);
        return this;
    }

    public ServiceDiscovery registerServiceImporter(ServiceImporter importer, JsonObject configuration) {
        return this.registerServiceImporter(importer, configuration, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxRegisterServiceImporter(ServiceImporter importer, JsonObject configuration) {
        return AsyncResultCompletable.toCompletable($handler -> this.registerServiceImporter(importer, configuration, (Handler<AsyncResult<Void>>)$handler));
    }

    public ServiceDiscovery registerServiceExporter(ServiceExporter exporter, JsonObject configuration, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.registerServiceExporter(exporter.getDelegate(), configuration, completionHandler);
        return this;
    }

    public ServiceDiscovery registerServiceExporter(ServiceExporter exporter, JsonObject configuration) {
        return this.registerServiceExporter(exporter, configuration, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxRegisterServiceExporter(ServiceExporter exporter, JsonObject configuration) {
        return AsyncResultCompletable.toCompletable($handler -> this.registerServiceExporter(exporter, configuration, (Handler<AsyncResult<Void>>)$handler));
    }

    public void close() {
        this.delegate.close();
    }

    public void publish(Record record, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.publish(record, resultHandler);
    }

    public void publish(Record record) {
        this.publish(record, (Handler<AsyncResult<Record>>)((Handler)ar -> {}));
    }

    public Single<Record> rxPublish(Record record) {
        return AsyncResultSingle.toSingle($handler -> this.publish(record, (Handler<AsyncResult<Record>>)$handler));
    }

    public void unpublish(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.unpublish(id, resultHandler);
    }

    public void unpublish(String id) {
        this.unpublish(id, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxUnpublish(String id) {
        return AsyncResultCompletable.toCompletable($handler -> this.unpublish(id, (Handler<AsyncResult<Void>>)$handler));
    }

    public void getRecord(JsonObject filter, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.getRecord(filter, resultHandler);
    }

    public void getRecord(JsonObject filter) {
        this.getRecord(filter, (Handler<AsyncResult<Record>>)((Handler)ar -> {}));
    }

    public Maybe<Record> rxGetRecord(JsonObject filter) {
        return AsyncResultMaybe.toMaybe($handler -> this.getRecord(filter, (Handler<AsyncResult<Record>>)$handler));
    }

    public void getRecord(String id, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.getRecord(id, resultHandler);
    }

    public void getRecord(String id) {
        this.getRecord(id, (Handler<AsyncResult<Record>>)((Handler)ar -> {}));
    }

    public Maybe<Record> rxGetRecord(String id) {
        return AsyncResultMaybe.toMaybe($handler -> this.getRecord(id, (Handler<AsyncResult<Record>>)$handler));
    }

    public void getRecord(Function<Record, Boolean> filter, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.getRecord(filter, resultHandler);
    }

    public void getRecord(Function<Record, Boolean> filter) {
        this.getRecord(filter, (Handler<AsyncResult<Record>>)((Handler)ar -> {}));
    }

    public Maybe<Record> rxGetRecord(Function<Record, Boolean> filter) {
        return AsyncResultMaybe.toMaybe($handler -> this.getRecord(filter, (Handler<AsyncResult<Record>>)$handler));
    }

    public void getRecord(Function<Record, Boolean> filter, boolean includeOutOfService, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.getRecord(filter, includeOutOfService, resultHandler);
    }

    public void getRecord(Function<Record, Boolean> filter, boolean includeOutOfService) {
        this.getRecord(filter, includeOutOfService, (Handler<AsyncResult<Record>>)((Handler)ar -> {}));
    }

    public Maybe<Record> rxGetRecord(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return AsyncResultMaybe.toMaybe($handler -> this.getRecord(filter, includeOutOfService, (Handler<AsyncResult<Record>>)$handler));
    }

    public void getRecords(JsonObject filter, Handler<AsyncResult<List<Record>>> resultHandler) {
        this.delegate.getRecords(filter, resultHandler);
    }

    public void getRecords(JsonObject filter) {
        this.getRecords(filter, (Handler<AsyncResult<List<Record>>>)((Handler)ar -> {}));
    }

    public Single<List<Record>> rxGetRecords(JsonObject filter) {
        return AsyncResultSingle.toSingle($handler -> this.getRecords(filter, (Handler<AsyncResult<List<Record>>>)$handler));
    }

    public void getRecords(Function<Record, Boolean> filter, Handler<AsyncResult<List<Record>>> resultHandler) {
        this.delegate.getRecords(filter, resultHandler);
    }

    public void getRecords(Function<Record, Boolean> filter) {
        this.getRecords(filter, (Handler<AsyncResult<List<Record>>>)((Handler)ar -> {}));
    }

    public Single<List<Record>> rxGetRecords(Function<Record, Boolean> filter) {
        return AsyncResultSingle.toSingle($handler -> this.getRecords(filter, (Handler<AsyncResult<List<Record>>>)$handler));
    }

    public void getRecords(Function<Record, Boolean> filter, boolean includeOutOfService, Handler<AsyncResult<List<Record>>> resultHandler) {
        this.delegate.getRecords(filter, includeOutOfService, resultHandler);
    }

    public void getRecords(Function<Record, Boolean> filter, boolean includeOutOfService) {
        this.getRecords(filter, includeOutOfService, (Handler<AsyncResult<List<Record>>>)((Handler)ar -> {}));
    }

    public Single<List<Record>> rxGetRecords(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return AsyncResultSingle.toSingle($handler -> this.getRecords(filter, includeOutOfService, (Handler<AsyncResult<List<Record>>>)$handler));
    }

    public void update(Record record, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.update(record, resultHandler);
    }

    public void update(Record record) {
        this.update(record, (Handler<AsyncResult<Record>>)((Handler)ar -> {}));
    }

    public Single<Record> rxUpdate(Record record) {
        return AsyncResultSingle.toSingle($handler -> this.update(record, (Handler<AsyncResult<Record>>)$handler));
    }

    public Set<ServiceReference> bindings() {
        Set<ServiceReference> ret = this.delegate.bindings().stream().map(elt -> ServiceReference.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public ServiceDiscoveryOptions options() {
        ServiceDiscoveryOptions ret = this.delegate.options();
        return ret;
    }

    public static void releaseServiceObject(ServiceDiscovery discovery, Object svcObject) {
        io.vertx.servicediscovery.ServiceDiscovery.releaseServiceObject((io.vertx.servicediscovery.ServiceDiscovery)discovery.getDelegate(), (Object)svcObject);
    }

    public static ServiceDiscovery newInstance(io.vertx.servicediscovery.ServiceDiscovery arg) {
        return arg != null ? new ServiceDiscovery(arg) : null;
    }
}

