/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.auth.oauth2;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.oauth2.OAuth2AuthorizationURL;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth
extends io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider {
    public static final TypeArg<OAuth2Auth> __TYPE_ARG = new TypeArg(obj -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth)obj), OAuth2Auth::getDelegate);
    private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Auth that = (OAuth2Auth)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
        super((AuthenticationProvider)delegate);
        this.delegate = delegate;
    }

    public OAuth2Auth(Object delegate) {
        super((AuthenticationProvider)((io.vertx.ext.auth.oauth2.OAuth2Auth)delegate));
        this.delegate = (io.vertx.ext.auth.oauth2.OAuth2Auth)delegate;
    }

    public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
        return this.delegate;
    }

    public static OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, OAuth2Options config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate(), (OAuth2Options)config));
        return ret;
    }

    public OAuth2Auth jWKSet(Handler<AsyncResult<Void>> handler) {
        this.delegate.jWKSet(handler);
        return this;
    }

    public OAuth2Auth jWKSet() {
        return this.jWKSet((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxJWKSet() {
        return AsyncResultCompletable.toCompletable($handler -> this.jWKSet((Handler<AsyncResult<Void>>)$handler));
    }

    public OAuth2Auth missingKeyHandler(Handler<String> handler) {
        this.delegate.missingKeyHandler(handler);
        return this;
    }

    @Deprecated
    public String authorizeURL(JsonObject params) {
        String ret = this.delegate.authorizeURL(params);
        return ret;
    }

    public String authorizeURL(OAuth2AuthorizationURL url) {
        String ret = this.delegate.authorizeURL(url);
        return ret;
    }

    public OAuth2Auth refresh(User user, Handler<AsyncResult<User>> handler) {
        this.delegate.refresh(user.getDelegate(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> User.newInstance(event))));
        return this;
    }

    public OAuth2Auth refresh(User user) {
        return this.refresh(user, (Handler<AsyncResult<User>>)((Handler)ar -> {}));
    }

    public Single<User> rxRefresh(User user) {
        return AsyncResultSingle.toSingle($handler -> this.refresh(user, (Handler<AsyncResult<User>>)$handler));
    }

    public OAuth2Auth revoke(User user, String tokenType, Handler<AsyncResult<Void>> handler) {
        this.delegate.revoke(user.getDelegate(), tokenType, handler);
        return this;
    }

    public OAuth2Auth revoke(User user, String tokenType) {
        return this.revoke(user, tokenType, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxRevoke(User user, String tokenType) {
        return AsyncResultCompletable.toCompletable($handler -> this.revoke(user, tokenType, (Handler<AsyncResult<Void>>)$handler));
    }

    public OAuth2Auth revoke(User user, Handler<AsyncResult<Void>> handler) {
        this.delegate.revoke(user.getDelegate(), handler);
        return this;
    }

    public OAuth2Auth revoke(User user) {
        return this.revoke(user, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxRevoke(User user) {
        return AsyncResultCompletable.toCompletable($handler -> this.revoke(user, (Handler<AsyncResult<Void>>)$handler));
    }

    public OAuth2Auth userInfo(User user, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.userInfo(user.getDelegate(), handler);
        return this;
    }

    public OAuth2Auth userInfo(User user) {
        return this.userInfo(user, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {}));
    }

    public Single<JsonObject> rxUserInfo(User user) {
        return AsyncResultSingle.toSingle($handler -> this.userInfo(user, (Handler<AsyncResult<JsonObject>>)$handler));
    }

    public String endSessionURL(User user, JsonObject params) {
        String ret = this.delegate.endSessionURL(user.getDelegate(), params);
        return ret;
    }

    public String endSessionURL(User user) {
        String ret = this.delegate.endSessionURL(user.getDelegate());
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public static OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
        return arg != null ? new OAuth2Auth(arg) : null;
    }
}

