/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A transaction.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Transaction original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Transaction.class)
public class Transaction implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Transaction that = (Transaction) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Transaction> __TYPE_ARG = new TypeArg<>(    obj -> new Transaction((io.vertx.sqlclient.Transaction) obj),
    Transaction::getDelegate
  );

  private final io.vertx.sqlclient.Transaction delegate;
  
  public Transaction(io.vertx.sqlclient.Transaction delegate) {
    this.delegate = delegate;
  }

  public Transaction(Object delegate) {
    this.delegate = (io.vertx.sqlclient.Transaction)delegate;
  }

  @Override 
  public io.vertx.sqlclient.Transaction getDelegate() {
    return delegate;
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#commit} with an handler to be notified when the transaction commit has completed
   * @param handler 
   */
  public void commit(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.commit(handler);
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#commit} with an handler to be notified when the transaction commit has completed
   */
  public void commit() {
    commit(ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#commit} with an handler to be notified when the transaction commit has completed
   * @return 
   */
  public io.reactivex.Completable rxCommit() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      commit($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#rollback} with an handler to be notified when the transaction rollback has completed
   * @param handler 
   */
  public void rollback(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.rollback(handler);
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#rollback} with an handler to be notified when the transaction rollback has completed
   */
  public void rollback() {
    rollback(ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#rollback} with an handler to be notified when the transaction rollback has completed
   * @return 
   */
  public io.reactivex.Completable rxRollback() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      rollback($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#completion} but with a callback
   * @param handler 
   */
  public void completion(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.completion(handler);
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#completion} but with a callback
   */
  public void completion() {
    completion(ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#completion} but with a callback
   * @return 
   */
  public io.reactivex.Completable rxCompletion() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      completion($handler);
    });
  }

  public static Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
    return arg != null ? new Transaction(arg) : null;
  }

}
