/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <b>Auto generated</b> Redis API client wrapper.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisAPI original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.RedisAPI.class)
public class RedisAPI implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisAPI that = (RedisAPI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisAPI> __TYPE_ARG = new TypeArg<>(    obj -> new RedisAPI((io.vertx.redis.client.RedisAPI) obj),
    RedisAPI::getDelegate
  );

  private final io.vertx.redis.client.RedisAPI delegate;
  
  public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
    this.delegate = delegate;
  }

  public RedisAPI(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
  }

  @Override 
  public io.vertx.redis.client.RedisAPI getDelegate() {
    return delegate;
  }

  public void close() { 
    delegate.close();
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.add/">FT.ADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAdd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftAdd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.add/">FT.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAdd(java.util.List<java.lang.String> args) {
    return 
ftAdd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.add/">FT.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftAdd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aggregate/">FT.AGGREGATE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAggregate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftAggregate(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aggregate/">FT.AGGREGATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAggregate(java.util.List<java.lang.String> args) {
    return 
ftAggregate(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aggregate/">FT.AGGREGATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtAggregate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftAggregate(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasadd/">FT.ALIASADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAliasadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftAliasadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasadd/">FT.ALIASADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAliasadd(java.util.List<java.lang.String> args) {
    return 
ftAliasadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasadd/">FT.ALIASADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtAliasadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftAliasadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasdel/">FT.ALIASDEL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAliasdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftAliasdel(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasdel/">FT.ALIASDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAliasdel(java.util.List<java.lang.String> args) {
    return 
ftAliasdel(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasdel/">FT.ALIASDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtAliasdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftAliasdel(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasupdate/">FT.ALIASUPDATE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAliasupdate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftAliasupdate(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasupdate/">FT.ALIASUPDATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAliasupdate(java.util.List<java.lang.String> args) {
    return 
ftAliasupdate(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasupdate/">FT.ALIASUPDATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtAliasupdate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftAliasupdate(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.alter/">FT.ALTER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAlter(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftAlter(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.alter/">FT.ALTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAlter(java.util.List<java.lang.String> args) {
    return 
ftAlter(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.alter/">FT.ALTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtAlter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftAlter(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.config/">FT.CONFIG</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftConfig(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftConfig(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.config/">FT.CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftConfig(java.util.List<java.lang.String> args) {
    return 
ftConfig(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.config/">FT.CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftConfig(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.create/">FT.CREATE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftCreate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftCreate(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.create/">FT.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftCreate(java.util.List<java.lang.String> args) {
    return 
ftCreate(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.create/">FT.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtCreate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftCreate(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.cursor/">FT.CURSOR</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftCursor(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftCursor(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.cursor/">FT.CURSOR</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftCursor(java.util.List<java.lang.String> args) {
    return 
ftCursor(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.cursor/">FT.CURSOR</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtCursor(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftCursor(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.debug/">FT.DEBUG</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftDebug(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.debug/">FT.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDebug(java.util.List<java.lang.String> args) {
    return 
ftDebug(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.debug/">FT.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftDebug(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.del/">FT.DEL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftDel(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.del/">FT.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDel(java.util.List<java.lang.String> args) {
    return 
ftDel(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.del/">FT.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftDel(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictadd/">FT.DICTADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDictadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftDictadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictadd/">FT.DICTADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDictadd(java.util.List<java.lang.String> args) {
    return 
ftDictadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictadd/">FT.DICTADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtDictadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftDictadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdel/">FT.DICTDEL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDictdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftDictdel(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdel/">FT.DICTDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDictdel(java.util.List<java.lang.String> args) {
    return 
ftDictdel(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdel/">FT.DICTDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtDictdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftDictdel(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdump/">FT.DICTDUMP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDictdump(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftDictdump(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdump/">FT.DICTDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDictdump(java.util.List<java.lang.String> args) {
    return 
ftDictdump(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdump/">FT.DICTDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtDictdump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftDictdump(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.drop/">FT.DROP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDrop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftDrop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.drop/">FT.DROP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDrop(java.util.List<java.lang.String> args) {
    return 
ftDrop(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.drop/">FT.DROP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtDrop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftDrop(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dropindex/">FT.DROPINDEX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDropindex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftDropindex(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dropindex/">FT.DROPINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDropindex(java.util.List<java.lang.String> args) {
    return 
ftDropindex(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dropindex/">FT.DROPINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtDropindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftDropindex(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explain/">FT.EXPLAIN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftExplain(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftExplain(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explain/">FT.EXPLAIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftExplain(java.util.List<java.lang.String> args) {
    return 
ftExplain(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explain/">FT.EXPLAIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtExplain(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftExplain(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explaincli/">FT.EXPLAINCLI</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftExplaincli(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftExplaincli(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explaincli/">FT.EXPLAINCLI</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftExplaincli(java.util.List<java.lang.String> args) {
    return 
ftExplaincli(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explaincli/">FT.EXPLAINCLI</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtExplaincli(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftExplaincli(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.get/">FT.GET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftGet(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftGet(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.get/">FT.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftGet(java.util.List<java.lang.String> args) {
    return 
ftGet(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.get/">FT.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftGet(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.info/">FT.INFO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftInfo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.info/">FT.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftInfo(java.util.List<java.lang.String> args) {
    return 
ftInfo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.info/">FT.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftInfo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.mget/">FT.MGET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftMget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftMget(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.mget/">FT.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftMget(java.util.List<java.lang.String> args) {
    return 
ftMget(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.mget/">FT.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftMget(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.profile/">FT.PROFILE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftProfile(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftProfile(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.profile/">FT.PROFILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftProfile(java.util.List<java.lang.String> args) {
    return 
ftProfile(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.profile/">FT.PROFILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtProfile(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftProfile(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.safeadd/">FT.SAFEADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSafeadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftSafeadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.safeadd/">FT.SAFEADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSafeadd(java.util.List<java.lang.String> args) {
    return 
ftSafeadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.safeadd/">FT.SAFEADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtSafeadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftSafeadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.search/">FT.SEARCH</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSearch(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftSearch(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.search/">FT.SEARCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSearch(java.util.List<java.lang.String> args) {
    return 
ftSearch(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.search/">FT.SEARCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtSearch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftSearch(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.spellcheck/">FT.SPELLCHECK</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSpellcheck(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftSpellcheck(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.spellcheck/">FT.SPELLCHECK</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSpellcheck(java.util.List<java.lang.String> args) {
    return 
ftSpellcheck(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.spellcheck/">FT.SPELLCHECK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtSpellcheck(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftSpellcheck(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugadd/">FT.SUGADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSugadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftSugadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugadd/">FT.SUGADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSugadd(java.util.List<java.lang.String> args) {
    return 
ftSugadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugadd/">FT.SUGADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtSugadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftSugadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugdel/">FT.SUGDEL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSugdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftSugdel(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugdel/">FT.SUGDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSugdel(java.util.List<java.lang.String> args) {
    return 
ftSugdel(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugdel/">FT.SUGDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtSugdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftSugdel(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugget/">FT.SUGGET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSugget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftSugget(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugget/">FT.SUGGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSugget(java.util.List<java.lang.String> args) {
    return 
ftSugget(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugget/">FT.SUGGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtSugget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftSugget(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.suglen/">FT.SUGLEN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSuglen(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftSuglen(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.suglen/">FT.SUGLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSuglen(java.util.List<java.lang.String> args) {
    return 
ftSuglen(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.suglen/">FT.SUGLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtSuglen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftSuglen(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synadd/">FT.SYNADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSynadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftSynadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synadd/">FT.SYNADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSynadd(java.util.List<java.lang.String> args) {
    return 
ftSynadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synadd/">FT.SYNADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtSynadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftSynadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.syndump/">FT.SYNDUMP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSyndump(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftSyndump(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.syndump/">FT.SYNDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSyndump(java.util.List<java.lang.String> args) {
    return 
ftSyndump(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.syndump/">FT.SYNDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtSyndump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftSyndump(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synupdate/">FT.SYNUPDATE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSynupdate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftSynupdate(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synupdate/">FT.SYNUPDATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftSynupdate(java.util.List<java.lang.String> args) {
    return 
ftSynupdate(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synupdate/">FT.SYNUPDATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtSynupdate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftSynupdate(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.tagvals/">FT.TAGVALS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftTagvals(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftTagvals(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.tagvals/">FT.TAGVALS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftTagvals(java.util.List<java.lang.String> args) {
    return 
ftTagvals(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.tagvals/">FT.TAGVALS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtTagvals(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftTagvals(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasaddifnx/">FT._ALIASADDIFNX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAliasaddifnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftAliasaddifnx(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasaddifnx/">FT._ALIASADDIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAliasaddifnx(java.util.List<java.lang.String> args) {
    return 
ftAliasaddifnx(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasaddifnx/">FT._ALIASADDIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtAliasaddifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftAliasaddifnx(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasdelifx/">FT._ALIASDELIFX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAliasdelifx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftAliasdelifx(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasdelifx/">FT._ALIASDELIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAliasdelifx(java.util.List<java.lang.String> args) {
    return 
ftAliasdelifx(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasdelifx/">FT._ALIASDELIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtAliasdelifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftAliasdelifx(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._alterifnx/">FT._ALTERIFNX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAlterifnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftAlterifnx(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._alterifnx/">FT._ALTERIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftAlterifnx(java.util.List<java.lang.String> args) {
    return 
ftAlterifnx(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._alterifnx/">FT._ALTERIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtAlterifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftAlterifnx(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._createifnx/">FT._CREATEIFNX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftCreateifnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftCreateifnx(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._createifnx/">FT._CREATEIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftCreateifnx(java.util.List<java.lang.String> args) {
    return 
ftCreateifnx(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._createifnx/">FT._CREATEIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtCreateifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftCreateifnx(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropifx/">FT._DROPIFX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDropifx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftDropifx(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropifx/">FT._DROPIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDropifx(java.util.List<java.lang.String> args) {
    return 
ftDropifx(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropifx/">FT._DROPIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtDropifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftDropifx(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropindexifx/">FT._DROPINDEXIFX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDropindexifx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftDropindexifx(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropindexifx/">FT._DROPINDEXIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftDropindexifx(java.util.List<java.lang.String> args) {
    return 
ftDropindexifx(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropindexifx/">FT._DROPINDEXIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtDropindexifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftDropindexifx(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._list/">FT._LIST</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftList(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ftList(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._list/">FT._LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ftList(java.util.List<java.lang.String> args) {
    return 
ftList(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._list/">FT._LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFtList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ftList(args, $handler);
    });
  }

  /**
   * A container for Access List Control commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/acl/">ACL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI acl(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.acl(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for Access List Control commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/acl/">ACL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI acl(java.util.List<java.lang.String> args) {
    return 
acl(args, ar -> { });
  }

  /**
   * A container for Access List Control commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/acl/">ACL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxAcl(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      acl(args, $handler);
    });
  }

  /**
   * Append a value to a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/append/">APPEND</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI append(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.append(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Append a value to a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/append/">APPEND</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI append(java.lang.String arg0, java.lang.String arg1) {
    return 
append(arg0, arg1, ar -> { });
  }

  /**
   * Append a value to a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/append/">APPEND</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxAppend(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      append(arg0, arg1, $handler);
    });
  }

  /**
   * Sent by cluster clients after an -ASK redirect.
   * <p>
   * Redis command <a href="https://redis.io/commands/asking/">ASKING</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI asking(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.asking(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Sent by cluster clients after an -ASK redirect.
   * <p>
   * Redis command <a href="https://redis.io/commands/asking/">ASKING</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI asking() {
    return 
asking(ar -> { });
  }

  /**
   * Sent by cluster clients after an -ASK redirect.
   * <p>
   * Redis command <a href="https://redis.io/commands/asking/">ASKING</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxAsking() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      asking($handler);
    });
  }

  /**
   * Authenticate to the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/auth/">AUTH</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI auth(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.auth(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Authenticate to the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/auth/">AUTH</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI auth(java.util.List<java.lang.String> args) {
    return 
auth(args, ar -> { });
  }

  /**
   * Authenticate to the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/auth/">AUTH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxAuth(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      auth(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add/">BF.ADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfAdd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bfAdd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add/">BF.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfAdd(java.util.List<java.lang.String> args) {
    return 
bfAdd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add/">BF.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBfAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bfAdd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.card/">BF.CARD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfCard(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bfCard(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.card/">BF.CARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfCard(java.util.List<java.lang.String> args) {
    return 
bfCard(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.card/">BF.CARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBfCard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bfCard(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug/">BF.DEBUG</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfDebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bfDebug(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug/">BF.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfDebug(java.util.List<java.lang.String> args) {
    return 
bfDebug(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug/">BF.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBfDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bfDebug(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists/">BF.EXISTS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfExists(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bfExists(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists/">BF.EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfExists(java.util.List<java.lang.String> args) {
    return 
bfExists(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists/">BF.EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBfExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bfExists(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info/">BF.INFO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bfInfo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info/">BF.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfInfo(java.util.List<java.lang.String> args) {
    return 
bfInfo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info/">BF.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBfInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bfInfo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert/">BF.INSERT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfInsert(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bfInsert(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert/">BF.INSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfInsert(java.util.List<java.lang.String> args) {
    return 
bfInsert(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert/">BF.INSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBfInsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bfInsert(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk/">BF.LOADCHUNK</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfLoadchunk(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bfLoadchunk(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk/">BF.LOADCHUNK</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfLoadchunk(java.util.List<java.lang.String> args) {
    return 
bfLoadchunk(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk/">BF.LOADCHUNK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBfLoadchunk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bfLoadchunk(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd/">BF.MADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfMadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bfMadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd/">BF.MADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfMadd(java.util.List<java.lang.String> args) {
    return 
bfMadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd/">BF.MADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBfMadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bfMadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists/">BF.MEXISTS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfMexists(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bfMexists(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists/">BF.MEXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfMexists(java.util.List<java.lang.String> args) {
    return 
bfMexists(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists/">BF.MEXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBfMexists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bfMexists(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve/">BF.RESERVE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfReserve(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bfReserve(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve/">BF.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfReserve(java.util.List<java.lang.String> args) {
    return 
bfReserve(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve/">BF.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBfReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bfReserve(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump/">BF.SCANDUMP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfScandump(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bfScandump(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump/">BF.SCANDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bfScandump(java.util.List<java.lang.String> args) {
    return 
bfScandump(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump/">BF.SCANDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBfScandump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bfScandump(args, $handler);
    });
  }

  /**
   * Asynchronously rewrite the append-only file.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgrewriteaof/">BGREWRITEAOF</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bgrewriteaof(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bgrewriteaof(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Asynchronously rewrite the append-only file.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgrewriteaof/">BGREWRITEAOF</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bgrewriteaof() {
    return 
bgrewriteaof(ar -> { });
  }

  /**
   * Asynchronously rewrite the append-only file.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgrewriteaof/">BGREWRITEAOF</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBgrewriteaof() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bgrewriteaof($handler);
    });
  }

  /**
   * Asynchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgsave/">BGSAVE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bgsave(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bgsave(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Asynchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgsave/">BGSAVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bgsave(java.util.List<java.lang.String> args) {
    return 
bgsave(args, ar -> { });
  }

  /**
   * Asynchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgsave/">BGSAVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBgsave(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bgsave(args, $handler);
    });
  }

  /**
   * Count set bits in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitcount/">BITCOUNT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitcount(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitcount(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Count set bits in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitcount/">BITCOUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitcount(java.util.List<java.lang.String> args) {
    return 
bitcount(args, ar -> { });
  }

  /**
   * Count set bits in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitcount/">BITCOUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBitcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bitcount(args, $handler);
    });
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield/">BITFIELD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitfield(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitfield(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield/">BITFIELD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitfield(java.util.List<java.lang.String> args) {
    return 
bitfield(args, ar -> { });
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield/">BITFIELD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBitfield(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bitfield(args, $handler);
    });
  }

  /**
   * Perform arbitrary bitfield integer operations on strings. Read-only variant of BITFIELD.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield_ro/">BITFIELD_RO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitfieldRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitfieldRo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Perform arbitrary bitfield integer operations on strings. Read-only variant of BITFIELD.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield_ro/">BITFIELD_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitfieldRo(java.util.List<java.lang.String> args) {
    return 
bitfieldRo(args, ar -> { });
  }

  /**
   * Perform arbitrary bitfield integer operations on strings. Read-only variant of BITFIELD.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield_ro/">BITFIELD_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBitfieldRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bitfieldRo(args, $handler);
    });
  }

  /**
   * Perform bitwise operations between strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitop/">BITOP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Perform bitwise operations between strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitop/">BITOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitop(java.util.List<java.lang.String> args) {
    return 
bitop(args, ar -> { });
  }

  /**
   * Perform bitwise operations between strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitop/">BITOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBitop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bitop(args, $handler);
    });
  }

  /**
   * Find first bit set or clear in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitpos/">BITPOS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitpos(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitpos(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Find first bit set or clear in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitpos/">BITPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitpos(java.util.List<java.lang.String> args) {
    return 
bitpos(args, ar -> { });
  }

  /**
   * Find first bit set or clear in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitpos/">BITPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBitpos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bitpos(args, $handler);
    });
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmove/">BLMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI blmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.blmove(arg0, arg1, arg2, arg3, arg4, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmove/">BLMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI blmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4) {
    return 
blmove(arg0, arg1, arg2, arg3, arg4, ar -> { });
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmove/">BLMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBlmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      blmove(arg0, arg1, arg2, arg3, arg4, $handler);
    });
  }

  /**
   * Pop elements from a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmpop/">BLMPOP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI blmpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.blmpop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Pop elements from a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmpop/">BLMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI blmpop(java.util.List<java.lang.String> args) {
    return 
blmpop(args, ar -> { });
  }

  /**
   * Pop elements from a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmpop/">BLMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBlmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      blmpop(args, $handler);
    });
  }

  /**
   * Remove and get the first element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blpop/">BLPOP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI blpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.blpop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove and get the first element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blpop/">BLPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI blpop(java.util.List<java.lang.String> args) {
    return 
blpop(args, ar -> { });
  }

  /**
   * Remove and get the first element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blpop/">BLPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBlpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      blpop(args, $handler);
    });
  }

  /**
   * Remove and get the last element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpop/">BRPOP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI brpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.brpop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove and get the last element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpop/">BRPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI brpop(java.util.List<java.lang.String> args) {
    return 
brpop(args, ar -> { });
  }

  /**
   * Remove and get the last element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpop/">BRPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBrpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      brpop(args, $handler);
    });
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpoplpush/">BRPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI brpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.brpoplpush(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpoplpush/">BRPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI brpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
brpoplpush(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpoplpush/">BRPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBrpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      brpoplpush(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Remove and return members with scores in a sorted set or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzmpop/">BZMPOP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzmpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bzmpop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove and return members with scores in a sorted set or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzmpop/">BZMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzmpop(java.util.List<java.lang.String> args) {
    return 
bzmpop(args, ar -> { });
  }

  /**
   * Remove and return members with scores in a sorted set or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzmpop/">BZMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBzmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bzmpop(args, $handler);
    });
  }

  /**
   * Remove and return the member with the highest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmax/">BZPOPMAX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzpopmax(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bzpopmax(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove and return the member with the highest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmax/">BZPOPMAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzpopmax(java.util.List<java.lang.String> args) {
    return 
bzpopmax(args, ar -> { });
  }

  /**
   * Remove and return the member with the highest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmax/">BZPOPMAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBzpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bzpopmax(args, $handler);
    });
  }

  /**
   * Remove and return the member with the lowest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmin/">BZPOPMIN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzpopmin(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bzpopmin(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove and return the member with the lowest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmin/">BZPOPMIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzpopmin(java.util.List<java.lang.String> args) {
    return 
bzpopmin(args, ar -> { });
  }

  /**
   * Remove and return the member with the lowest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmin/">BZPOPMIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBzpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bzpopmin(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add/">CF.ADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfAdd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfAdd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add/">CF.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfAdd(java.util.List<java.lang.String> args) {
    return 
cfAdd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add/">CF.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfAdd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx/">CF.ADDNX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfAddnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfAddnx(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx/">CF.ADDNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfAddnx(java.util.List<java.lang.String> args) {
    return 
cfAddnx(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx/">CF.ADDNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfAddnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfAddnx(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact/">CF.COMPACT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfCompact(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfCompact(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact/">CF.COMPACT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfCompact(java.util.List<java.lang.String> args) {
    return 
cfCompact(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact/">CF.COMPACT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfCompact(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfCompact(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count/">CF.COUNT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfCount(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfCount(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count/">CF.COUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfCount(java.util.List<java.lang.String> args) {
    return 
cfCount(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count/">CF.COUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfCount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfCount(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug/">CF.DEBUG</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfDebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfDebug(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug/">CF.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfDebug(java.util.List<java.lang.String> args) {
    return 
cfDebug(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug/">CF.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfDebug(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del/">CF.DEL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfDel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfDel(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del/">CF.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfDel(java.util.List<java.lang.String> args) {
    return 
cfDel(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del/">CF.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfDel(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists/">CF.EXISTS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfExists(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfExists(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists/">CF.EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfExists(java.util.List<java.lang.String> args) {
    return 
cfExists(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists/">CF.EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfExists(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info/">CF.INFO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfInfo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info/">CF.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfInfo(java.util.List<java.lang.String> args) {
    return 
cfInfo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info/">CF.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfInfo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert/">CF.INSERT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfInsert(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfInsert(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert/">CF.INSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfInsert(java.util.List<java.lang.String> args) {
    return 
cfInsert(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert/">CF.INSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfInsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfInsert(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx/">CF.INSERTNX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfInsertnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfInsertnx(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx/">CF.INSERTNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfInsertnx(java.util.List<java.lang.String> args) {
    return 
cfInsertnx(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx/">CF.INSERTNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfInsertnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfInsertnx(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk/">CF.LOADCHUNK</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfLoadchunk(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfLoadchunk(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk/">CF.LOADCHUNK</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfLoadchunk(java.util.List<java.lang.String> args) {
    return 
cfLoadchunk(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk/">CF.LOADCHUNK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfLoadchunk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfLoadchunk(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists/">CF.MEXISTS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfMexists(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfMexists(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists/">CF.MEXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfMexists(java.util.List<java.lang.String> args) {
    return 
cfMexists(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists/">CF.MEXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfMexists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfMexists(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve/">CF.RESERVE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfReserve(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfReserve(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve/">CF.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfReserve(java.util.List<java.lang.String> args) {
    return 
cfReserve(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve/">CF.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfReserve(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump/">CF.SCANDUMP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfScandump(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cfScandump(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump/">CF.SCANDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cfScandump(java.util.List<java.lang.String> args) {
    return 
cfScandump(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump/">CF.SCANDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCfScandump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cfScandump(args, $handler);
    });
  }

  /**
   * A container for client connection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/client/">CLIENT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI client(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.client(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for client connection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/client/">CLIENT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI client(java.util.List<java.lang.String> args) {
    return 
client(args, ar -> { });
  }

  /**
   * A container for client connection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/client/">CLIENT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxClient(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      client(args, $handler);
    });
  }

  /**
   * A container for cluster commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/cluster/">CLUSTER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cluster(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cluster(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for cluster commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/cluster/">CLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cluster(java.util.List<java.lang.String> args) {
    return 
cluster(args, ar -> { });
  }

  /**
   * A container for cluster commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/cluster/">CLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cluster(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby/">CMS.INCRBY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsIncrby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cmsIncrby(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby/">CMS.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsIncrby(java.util.List<java.lang.String> args) {
    return 
cmsIncrby(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby/">CMS.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCmsIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cmsIncrby(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info/">CMS.INFO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cmsInfo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info/">CMS.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsInfo(java.util.List<java.lang.String> args) {
    return 
cmsInfo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info/">CMS.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCmsInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cmsInfo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim/">CMS.INITBYDIM</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsInitbydim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cmsInitbydim(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim/">CMS.INITBYDIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsInitbydim(java.util.List<java.lang.String> args) {
    return 
cmsInitbydim(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim/">CMS.INITBYDIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCmsInitbydim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cmsInitbydim(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob/">CMS.INITBYPROB</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsInitbyprob(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cmsInitbyprob(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob/">CMS.INITBYPROB</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsInitbyprob(java.util.List<java.lang.String> args) {
    return 
cmsInitbyprob(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob/">CMS.INITBYPROB</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCmsInitbyprob(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cmsInitbyprob(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge/">CMS.MERGE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsMerge(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cmsMerge(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge/">CMS.MERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsMerge(java.util.List<java.lang.String> args) {
    return 
cmsMerge(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge/">CMS.MERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCmsMerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cmsMerge(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query/">CMS.QUERY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsQuery(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cmsQuery(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query/">CMS.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cmsQuery(java.util.List<java.lang.String> args) {
    return 
cmsQuery(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query/">CMS.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCmsQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cmsQuery(args, $handler);
    });
  }

  /**
   * Get array of Redis command details.
   * <p>
   * Redis command <a href="https://redis.io/commands/command/">COMMAND</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI command(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.command(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get array of Redis command details.
   * <p>
   * Redis command <a href="https://redis.io/commands/command/">COMMAND</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI command(java.util.List<java.lang.String> args) {
    return 
command(args, ar -> { });
  }

  /**
   * Get array of Redis command details.
   * <p>
   * Redis command <a href="https://redis.io/commands/command/">COMMAND</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCommand(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      command(args, $handler);
    });
  }

  /**
   * A container for server configuration commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/config/">CONFIG</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI config(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.config(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for server configuration commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/config/">CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI config(java.util.List<java.lang.String> args) {
    return 
config(args, ar -> { });
  }

  /**
   * A container for server configuration commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/config/">CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      config(args, $handler);
    });
  }

  /**
   * Copy a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/copy/">COPY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI copy(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.copy(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Copy a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/copy/">COPY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI copy(java.util.List<java.lang.String> args) {
    return 
copy(args, ar -> { });
  }

  /**
   * Copy a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/copy/">COPY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCopy(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      copy(args, $handler);
    });
  }

  /**
   * Return the number of keys in the selected database.
   * <p>
   * Redis command <a href="https://redis.io/commands/dbsize/">DBSIZE</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI dbsize(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.dbsize(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return the number of keys in the selected database.
   * <p>
   * Redis command <a href="https://redis.io/commands/dbsize/">DBSIZE</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI dbsize() {
    return 
dbsize(ar -> { });
  }

  /**
   * Return the number of keys in the selected database.
   * <p>
   * Redis command <a href="https://redis.io/commands/dbsize/">DBSIZE</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDbsize() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      dbsize($handler);
    });
  }

  /**
   * A container for debugging commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/debug/">DEBUG</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI debug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.debug(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for debugging commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/debug/">DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI debug(java.util.List<java.lang.String> args) {
    return 
debug(args, ar -> { });
  }

  /**
   * A container for debugging commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/debug/">DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      debug(args, $handler);
    });
  }

  /**
   * Decrement the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/decr/">DECR</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI decr(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.decr(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Decrement the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/decr/">DECR</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI decr(java.lang.String arg0) {
    return 
decr(arg0, ar -> { });
  }

  /**
   * Decrement the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/decr/">DECR</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDecr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      decr(arg0, $handler);
    });
  }

  /**
   * Decrement the integer value of a key by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/decrby/">DECRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI decrby(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.decrby(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Decrement the integer value of a key by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/decrby/">DECRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI decrby(java.lang.String arg0, java.lang.String arg1) {
    return 
decrby(arg0, arg1, ar -> { });
  }

  /**
   * Decrement the integer value of a key by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/decrby/">DECRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDecrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      decrby(arg0, arg1, $handler);
    });
  }

  /**
   * Delete a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/del/">DEL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI del(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.del(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Delete a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/del/">DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI del(java.util.List<java.lang.String> args) {
    return 
del(args, ar -> { });
  }

  /**
   * Delete a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/del/">DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      del(args, $handler);
    });
  }

  /**
   * Discard all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/discard/">DISCARD</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI discard(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.discard(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Discard all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/discard/">DISCARD</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI discard() {
    return 
discard(ar -> { });
  }

  /**
   * Discard all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/discard/">DISCARD</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDiscard() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      discard($handler);
    });
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * <p>
   * Redis command <a href="https://redis.io/commands/dump/">DUMP</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI dump(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.dump(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * <p>
   * Redis command <a href="https://redis.io/commands/dump/">DUMP</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI dump(java.lang.String arg0) {
    return 
dump(arg0, ar -> { });
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * <p>
   * Redis command <a href="https://redis.io/commands/dump/">DUMP</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDump(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      dump(arg0, $handler);
    });
  }

  /**
   * Echo the given string.
   * <p>
   * Redis command <a href="https://redis.io/commands/echo/">ECHO</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI echo(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.echo(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Echo the given string.
   * <p>
   * Redis command <a href="https://redis.io/commands/echo/">ECHO</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI echo(java.lang.String arg0) {
    return 
echo(arg0, ar -> { });
  }

  /**
   * Echo the given string.
   * <p>
   * Redis command <a href="https://redis.io/commands/echo/">ECHO</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxEcho(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      echo(arg0, $handler);
    });
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval/">EVAL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI eval(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.eval(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval/">EVAL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI eval(java.util.List<java.lang.String> args) {
    return 
eval(args, ar -> { });
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval/">EVAL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxEval(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      eval(args, $handler);
    });
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval_ro/">EVAL_RO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI evalRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.evalRo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval_ro/">EVAL_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI evalRo(java.util.List<java.lang.String> args) {
    return 
evalRo(args, ar -> { });
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval_ro/">EVAL_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxEvalRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      evalRo(args, $handler);
    });
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha/">EVALSHA</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI evalsha(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.evalsha(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha/">EVALSHA</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI evalsha(java.util.List<java.lang.String> args) {
    return 
evalsha(args, ar -> { });
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha/">EVALSHA</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxEvalsha(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      evalsha(args, $handler);
    });
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha_ro/">EVALSHA_RO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI evalshaRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.evalshaRo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha_ro/">EVALSHA_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI evalshaRo(java.util.List<java.lang.String> args) {
    return 
evalshaRo(args, ar -> { });
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha_ro/">EVALSHA_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxEvalshaRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      evalshaRo(args, $handler);
    });
  }

  /**
   * Execute all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/exec/">EXEC</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI exec(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.exec(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Execute all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/exec/">EXEC</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI exec() {
    return 
exec(ar -> { });
  }

  /**
   * Execute all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/exec/">EXEC</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxExec() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      exec($handler);
    });
  }

  /**
   * Determine if a key exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/exists/">EXISTS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI exists(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.exists(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Determine if a key exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/exists/">EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI exists(java.util.List<java.lang.String> args) {
    return 
exists(args, ar -> { });
  }

  /**
   * Determine if a key exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/exists/">EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      exists(args, $handler);
    });
  }

  /**
   * Set a key&#x27;s time to live in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/expire/">EXPIRE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expire(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.expire(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set a key&#x27;s time to live in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/expire/">EXPIRE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expire(java.util.List<java.lang.String> args) {
    return 
expire(args, ar -> { });
  }

  /**
   * Set a key&#x27;s time to live in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/expire/">EXPIRE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxExpire(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      expire(args, $handler);
    });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp.
   * <p>
   * Redis command <a href="https://redis.io/commands/expireat/">EXPIREAT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expireat(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.expireat(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp.
   * <p>
   * Redis command <a href="https://redis.io/commands/expireat/">EXPIREAT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expireat(java.util.List<java.lang.String> args) {
    return 
expireat(args, ar -> { });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp.
   * <p>
   * Redis command <a href="https://redis.io/commands/expireat/">EXPIREAT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxExpireat(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      expireat(args, $handler);
    });
  }

  /**
   * Get the expiration Unix timestamp for a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/expiretime/">EXPIRETIME</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expiretime(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.expiretime(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the expiration Unix timestamp for a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/expiretime/">EXPIRETIME</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expiretime(java.lang.String arg0) {
    return 
expiretime(arg0, ar -> { });
  }

  /**
   * Get the expiration Unix timestamp for a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/expiretime/">EXPIRETIME</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxExpiretime(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      expiretime(arg0, $handler);
    });
  }

  /**
   * Start a coordinated failover between this server and one of its replicas.
   * <p>
   * Redis command <a href="https://redis.io/commands/failover/">FAILOVER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI failover(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.failover(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Start a coordinated failover between this server and one of its replicas.
   * <p>
   * Redis command <a href="https://redis.io/commands/failover/">FAILOVER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI failover(java.util.List<java.lang.String> args) {
    return 
failover(args, ar -> { });
  }

  /**
   * Start a coordinated failover between this server and one of its replicas.
   * <p>
   * Redis command <a href="https://redis.io/commands/failover/">FAILOVER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFailover(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      failover(args, $handler);
    });
  }

  /**
   * Invoke a function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall/">FCALL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI fcall(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.fcall(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Invoke a function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall/">FCALL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI fcall(java.util.List<java.lang.String> args) {
    return 
fcall(args, ar -> { });
  }

  /**
   * Invoke a function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall/">FCALL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFcall(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      fcall(args, $handler);
    });
  }

  /**
   * Invoke a read-only function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall_ro/">FCALL_RO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI fcallRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.fcallRo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Invoke a read-only function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall_ro/">FCALL_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI fcallRo(java.util.List<java.lang.String> args) {
    return 
fcallRo(args, ar -> { });
  }

  /**
   * Invoke a read-only function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall_ro/">FCALL_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFcallRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      fcallRo(args, $handler);
    });
  }

  /**
   * Remove all keys from all databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushall/">FLUSHALL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI flushall(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.flushall(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove all keys from all databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushall/">FLUSHALL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI flushall(java.util.List<java.lang.String> args) {
    return 
flushall(args, ar -> { });
  }

  /**
   * Remove all keys from all databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushall/">FLUSHALL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFlushall(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      flushall(args, $handler);
    });
  }

  /**
   * Remove all keys from the current database.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushdb/">FLUSHDB</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI flushdb(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.flushdb(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove all keys from the current database.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushdb/">FLUSHDB</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI flushdb(java.util.List<java.lang.String> args) {
    return 
flushdb(args, ar -> { });
  }

  /**
   * Remove all keys from the current database.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushdb/">FLUSHDB</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFlushdb(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      flushdb(args, $handler);
    });
  }

  /**
   * A container for function commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/function/">FUNCTION</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI function(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.function(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for function commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/function/">FUNCTION</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI function(java.util.List<java.lang.String> args) {
    return 
function(args, ar -> { });
  }

  /**
   * A container for function commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/function/">FUNCTION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFunction(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      function(args, $handler);
    });
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/geoadd/">GEOADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geoadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geoadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/geoadd/">GEOADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geoadd(java.util.List<java.lang.String> args) {
    return 
geoadd(args, ar -> { });
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/geoadd/">GEOADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeoadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      geoadd(args, $handler);
    });
  }

  /**
   * Returns the distance between two members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geodist/">GEODIST</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geodist(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geodist(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Returns the distance between two members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geodist/">GEODIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geodist(java.util.List<java.lang.String> args) {
    return 
geodist(args, ar -> { });
  }

  /**
   * Returns the distance between two members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geodist/">GEODIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeodist(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      geodist(args, $handler);
    });
  }

  /**
   * Returns members of a geospatial index as standard geohash strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/geohash/">GEOHASH</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geohash(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geohash(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Returns members of a geospatial index as standard geohash strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/geohash/">GEOHASH</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geohash(java.util.List<java.lang.String> args) {
    return 
geohash(args, ar -> { });
  }

  /**
   * Returns members of a geospatial index as standard geohash strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/geohash/">GEOHASH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeohash(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      geohash(args, $handler);
    });
  }

  /**
   * Returns longitude and latitude of members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geopos/">GEOPOS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geopos(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geopos(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Returns longitude and latitude of members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geopos/">GEOPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geopos(java.util.List<java.lang.String> args) {
    return 
geopos(args, ar -> { });
  }

  /**
   * Returns longitude and latitude of members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geopos/">GEOPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeopos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      geopos(args, $handler);
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius/">GEORADIUS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadius(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadius(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius/">GEORADIUS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadius(java.util.List<java.lang.String> args) {
    return 
georadius(args, ar -> { });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius/">GEORADIUS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradius(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      georadius(args, $handler);
    });
  }

  /**
   * A read-only variant for GEORADIUS.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius_ro/">GEORADIUS_RO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadiusRo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A read-only variant for GEORADIUS.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius_ro/">GEORADIUS_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusRo(java.util.List<java.lang.String> args) {
    return 
georadiusRo(args, ar -> { });
  }

  /**
   * A read-only variant for GEORADIUS.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius_ro/">GEORADIUS_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradiusRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      georadiusRo(args, $handler);
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember/">GEORADIUSBYMEMBER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusbymember(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadiusbymember(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember/">GEORADIUSBYMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusbymember(java.util.List<java.lang.String> args) {
    return 
georadiusbymember(args, ar -> { });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember/">GEORADIUSBYMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradiusbymember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      georadiusbymember(args, $handler);
    });
  }

  /**
   * A read-only variant for GEORADIUSBYMEMBER.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro/">GEORADIUSBYMEMBER_RO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusbymemberRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadiusbymemberRo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A read-only variant for GEORADIUSBYMEMBER.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro/">GEORADIUSBYMEMBER_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusbymemberRo(java.util.List<java.lang.String> args) {
    return 
georadiusbymemberRo(args, ar -> { });
  }

  /**
   * A read-only variant for GEORADIUSBYMEMBER.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro/">GEORADIUSBYMEMBER_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradiusbymemberRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      georadiusbymemberRo(args, $handler);
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearch/">GEOSEARCH</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geosearch(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geosearch(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearch/">GEOSEARCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geosearch(java.util.List<java.lang.String> args) {
    return 
geosearch(args, ar -> { });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearch/">GEOSEARCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeosearch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      geosearch(args, $handler);
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle, and store the result in another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearchstore/">GEOSEARCHSTORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geosearchstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geosearchstore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle, and store the result in another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearchstore/">GEOSEARCHSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geosearchstore(java.util.List<java.lang.String> args) {
    return 
geosearchstore(args, ar -> { });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle, and store the result in another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearchstore/">GEOSEARCHSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeosearchstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      geosearchstore(args, $handler);
    });
  }

  /**
   * Get the value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/get/">GET</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI get(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.get(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/get/">GET</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI get(java.lang.String arg0) {
    return 
get(arg0, ar -> { });
  }

  /**
   * Get the value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/get/">GET</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGet(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      get(arg0, $handler);
    });
  }

  /**
   * Returns the bit value at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getbit/">GETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getbit(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.getbit(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Returns the bit value at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getbit/">GETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getbit(java.lang.String arg0, java.lang.String arg1) {
    return 
getbit(arg0, arg1, ar -> { });
  }

  /**
   * Returns the bit value at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getbit/">GETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGetbit(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      getbit(arg0, arg1, $handler);
    });
  }

  /**
   * Get the value of a key and delete the key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getdel/">GETDEL</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getdel(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.getdel(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the value of a key and delete the key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getdel/">GETDEL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getdel(java.lang.String arg0) {
    return 
getdel(arg0, ar -> { });
  }

  /**
   * Get the value of a key and delete the key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getdel/">GETDEL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGetdel(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      getdel(arg0, $handler);
    });
  }

  /**
   * Get the value of a key and optionally set its expiration.
   * <p>
   * Redis command <a href="https://redis.io/commands/getex/">GETEX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.getex(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the value of a key and optionally set its expiration.
   * <p>
   * Redis command <a href="https://redis.io/commands/getex/">GETEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getex(java.util.List<java.lang.String> args) {
    return 
getex(args, ar -> { });
  }

  /**
   * Get the value of a key and optionally set its expiration.
   * <p>
   * Redis command <a href="https://redis.io/commands/getex/">GETEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGetex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      getex(args, $handler);
    });
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getrange/">GETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.getrange(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getrange/">GETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
getrange(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getrange/">GETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      getrange(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Set the string value of a key and return its old value.
   * <p>
   * Redis command <a href="https://redis.io/commands/getset/">GETSET</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getset(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.getset(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set the string value of a key and return its old value.
   * <p>
   * Redis command <a href="https://redis.io/commands/getset/">GETSET</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getset(java.lang.String arg0, java.lang.String arg1) {
    return 
getset(arg0, arg1, ar -> { });
  }

  /**
   * Set the string value of a key and return its old value.
   * <p>
   * Redis command <a href="https://redis.io/commands/getset/">GETSET</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGetset(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      getset(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.bulk/">GRAPH.BULK</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphBulk(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.graphBulk(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.bulk/">GRAPH.BULK</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphBulk(java.util.List<java.lang.String> args) {
    return 
graphBulk(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.bulk/">GRAPH.BULK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGraphBulk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      graphBulk(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.config/">GRAPH.CONFIG</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphConfig(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.graphConfig(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.config/">GRAPH.CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphConfig(java.util.List<java.lang.String> args) {
    return 
graphConfig(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.config/">GRAPH.CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGraphConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      graphConfig(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.debug/">GRAPH.DEBUG</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphDebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.graphDebug(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.debug/">GRAPH.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphDebug(java.util.List<java.lang.String> args) {
    return 
graphDebug(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.debug/">GRAPH.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGraphDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      graphDebug(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.delete/">GRAPH.DELETE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphDelete(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.graphDelete(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.delete/">GRAPH.DELETE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphDelete(java.util.List<java.lang.String> args) {
    return 
graphDelete(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.delete/">GRAPH.DELETE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGraphDelete(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      graphDelete(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.explain/">GRAPH.EXPLAIN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphExplain(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.graphExplain(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.explain/">GRAPH.EXPLAIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphExplain(java.util.List<java.lang.String> args) {
    return 
graphExplain(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.explain/">GRAPH.EXPLAIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGraphExplain(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      graphExplain(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.list/">GRAPH.LIST</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphList(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.graphList(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.list/">GRAPH.LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphList(java.util.List<java.lang.String> args) {
    return 
graphList(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.list/">GRAPH.LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGraphList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      graphList(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.profile/">GRAPH.PROFILE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphProfile(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.graphProfile(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.profile/">GRAPH.PROFILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphProfile(java.util.List<java.lang.String> args) {
    return 
graphProfile(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.profile/">GRAPH.PROFILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGraphProfile(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      graphProfile(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.query/">GRAPH.QUERY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphQuery(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.graphQuery(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.query/">GRAPH.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphQuery(java.util.List<java.lang.String> args) {
    return 
graphQuery(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.query/">GRAPH.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGraphQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      graphQuery(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.ro_query/">GRAPH.RO_QUERY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphRoQuery(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.graphRoQuery(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.ro_query/">GRAPH.RO_QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphRoQuery(java.util.List<java.lang.String> args) {
    return 
graphRoQuery(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.ro_query/">GRAPH.RO_QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGraphRoQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      graphRoQuery(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.slowlog/">GRAPH.SLOWLOG</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphSlowlog(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.graphSlowlog(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.slowlog/">GRAPH.SLOWLOG</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI graphSlowlog(java.util.List<java.lang.String> args) {
    return 
graphSlowlog(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.slowlog/">GRAPH.SLOWLOG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGraphSlowlog(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      graphSlowlog(args, $handler);
    });
  }

  /**
   * Delete one or more hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hdel/">HDEL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hdel(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Delete one or more hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hdel/">HDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hdel(java.util.List<java.lang.String> args) {
    return 
hdel(args, ar -> { });
  }

  /**
   * Delete one or more hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hdel/">HDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hdel(args, $handler);
    });
  }

  /**
   * Handshake with Redis.
   * <p>
   * Redis command <a href="https://redis.io/commands/hello/">HELLO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hello(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hello(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Handshake with Redis.
   * <p>
   * Redis command <a href="https://redis.io/commands/hello/">HELLO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hello(java.util.List<java.lang.String> args) {
    return 
hello(args, ar -> { });
  }

  /**
   * Handshake with Redis.
   * <p>
   * Redis command <a href="https://redis.io/commands/hello/">HELLO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHello(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hello(args, $handler);
    });
  }

  /**
   * Determine if a hash field exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/hexists/">HEXISTS</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hexists(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hexists(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Determine if a hash field exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/hexists/">HEXISTS</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hexists(java.lang.String arg0, java.lang.String arg1) {
    return 
hexists(arg0, arg1, ar -> { });
  }

  /**
   * Determine if a hash field exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/hexists/">HEXISTS</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHexists(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hexists(arg0, arg1, $handler);
    });
  }

  /**
   * Get the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hget/">HGET</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hget(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hget(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hget/">HGET</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hget(java.lang.String arg0, java.lang.String arg1) {
    return 
hget(arg0, arg1, ar -> { });
  }

  /**
   * Get the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hget/">HGET</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHget(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hget(arg0, arg1, $handler);
    });
  }

  /**
   * Get all the fields and values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hgetall/">HGETALL</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hgetall(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hgetall(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get all the fields and values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hgetall/">HGETALL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hgetall(java.lang.String arg0) {
    return 
hgetall(arg0, ar -> { });
  }

  /**
   * Get all the fields and values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hgetall/">HGETALL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHgetall(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hgetall(arg0, $handler);
    });
  }

  /**
   * Increment the integer value of a hash field by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrby/">HINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hincrby(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Increment the integer value of a hash field by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrby/">HINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
hincrby(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Increment the integer value of a hash field by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrby/">HINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hincrby(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Increment the float value of a hash field by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrbyfloat/">HINCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hincrbyfloat(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Increment the float value of a hash field by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrbyfloat/">HINCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
hincrbyfloat(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Increment the float value of a hash field by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrbyfloat/">HINCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hincrbyfloat(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Get all the fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hkeys/">HKEYS</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hkeys(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hkeys(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get all the fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hkeys/">HKEYS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hkeys(java.lang.String arg0) {
    return 
hkeys(arg0, ar -> { });
  }

  /**
   * Get all the fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hkeys/">HKEYS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHkeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hkeys(arg0, $handler);
    });
  }

  /**
   * Get the number of fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hlen/">HLEN</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hlen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hlen(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the number of fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hlen/">HLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hlen(java.lang.String arg0) {
    return 
hlen(arg0, ar -> { });
  }

  /**
   * Get the number of fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hlen/">HLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hlen(arg0, $handler);
    });
  }

  /**
   * Get the values of all the given hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmget/">HMGET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hmget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hmget(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the values of all the given hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmget/">HMGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hmget(java.util.List<java.lang.String> args) {
    return 
hmget(args, ar -> { });
  }

  /**
   * Get the values of all the given hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmget/">HMGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHmget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hmget(args, $handler);
    });
  }

  /**
   * Set multiple hash fields to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmset/">HMSET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hmset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hmset(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set multiple hash fields to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmset/">HMSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hmset(java.util.List<java.lang.String> args) {
    return 
hmset(args, ar -> { });
  }

  /**
   * Set multiple hash fields to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmset/">HMSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHmset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hmset(args, $handler);
    });
  }

  /**
   * Get one or multiple random fields from a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hrandfield/">HRANDFIELD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hrandfield(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hrandfield(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get one or multiple random fields from a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hrandfield/">HRANDFIELD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hrandfield(java.util.List<java.lang.String> args) {
    return 
hrandfield(args, ar -> { });
  }

  /**
   * Get one or multiple random fields from a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hrandfield/">HRANDFIELD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHrandfield(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hrandfield(args, $handler);
    });
  }

  /**
   * Incrementally iterate hash fields and associated values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hscan/">HSCAN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hscan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hscan(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Incrementally iterate hash fields and associated values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hscan/">HSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hscan(java.util.List<java.lang.String> args) {
    return 
hscan(args, ar -> { });
  }

  /**
   * Incrementally iterate hash fields and associated values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hscan/">HSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hscan(args, $handler);
    });
  }

  /**
   * Set the string value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hset/">HSET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hset(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set the string value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hset/">HSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hset(java.util.List<java.lang.String> args) {
    return 
hset(args, ar -> { });
  }

  /**
   * Set the string value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hset/">HSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hset(args, $handler);
    });
  }

  /**
   * Set the value of a hash field, only if the field does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/hsetnx/">HSETNX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hsetnx(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set the value of a hash field, only if the field does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/hsetnx/">HSETNX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
hsetnx(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Set the value of a hash field, only if the field does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/hsetnx/">HSETNX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hsetnx(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Get the length of the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hstrlen/">HSTRLEN</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hstrlen(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hstrlen(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the length of the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hstrlen/">HSTRLEN</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hstrlen(java.lang.String arg0, java.lang.String arg1) {
    return 
hstrlen(arg0, arg1, ar -> { });
  }

  /**
   * Get the length of the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hstrlen/">HSTRLEN</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHstrlen(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hstrlen(arg0, arg1, $handler);
    });
  }

  /**
   * Get all the values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hvals/">HVALS</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hvals(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hvals(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get all the values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hvals/">HVALS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hvals(java.lang.String arg0) {
    return 
hvals(arg0, ar -> { });
  }

  /**
   * Get all the values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hvals/">HVALS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHvals(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hvals(arg0, $handler);
    });
  }

  /**
   * Increment the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/incr/">INCR</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incr(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.incr(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Increment the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/incr/">INCR</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incr(java.lang.String arg0) {
    return 
incr(arg0, ar -> { });
  }

  /**
   * Increment the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/incr/">INCR</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxIncr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      incr(arg0, $handler);
    });
  }

  /**
   * Increment the integer value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrby/">INCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incrby(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.incrby(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Increment the integer value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrby/">INCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incrby(java.lang.String arg0, java.lang.String arg1) {
    return 
incrby(arg0, arg1, ar -> { });
  }

  /**
   * Increment the integer value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrby/">INCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxIncrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      incrby(arg0, arg1, $handler);
    });
  }

  /**
   * Increment the float value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrbyfloat/">INCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incrbyfloat(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.incrbyfloat(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Increment the float value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrbyfloat/">INCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incrbyfloat(java.lang.String arg0, java.lang.String arg1) {
    return 
incrbyfloat(arg0, arg1, ar -> { });
  }

  /**
   * Increment the float value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrbyfloat/">INCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxIncrbyfloat(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      incrbyfloat(arg0, arg1, $handler);
    });
  }

  /**
   * Get information and statistics about the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/info/">INFO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI info(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.info(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get information and statistics about the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/info/">INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI info(java.util.List<java.lang.String> args) {
    return 
info(args, ar -> { });
  }

  /**
   * Get information and statistics about the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/info/">INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      info(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend/">JSON.ARRAPPEND</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrappend(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonArrappend(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend/">JSON.ARRAPPEND</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrappend(java.util.List<java.lang.String> args) {
    return 
jsonArrappend(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend/">JSON.ARRAPPEND</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonArrappend(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonArrappend(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex/">JSON.ARRINDEX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrindex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonArrindex(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex/">JSON.ARRINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrindex(java.util.List<java.lang.String> args) {
    return 
jsonArrindex(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex/">JSON.ARRINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonArrindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonArrindex(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert/">JSON.ARRINSERT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrinsert(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonArrinsert(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert/">JSON.ARRINSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrinsert(java.util.List<java.lang.String> args) {
    return 
jsonArrinsert(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert/">JSON.ARRINSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonArrinsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonArrinsert(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen/">JSON.ARRLEN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrlen(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonArrlen(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen/">JSON.ARRLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrlen(java.util.List<java.lang.String> args) {
    return 
jsonArrlen(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen/">JSON.ARRLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonArrlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonArrlen(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop/">JSON.ARRPOP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonArrpop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop/">JSON.ARRPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrpop(java.util.List<java.lang.String> args) {
    return 
jsonArrpop(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop/">JSON.ARRPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonArrpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonArrpop(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim/">JSON.ARRTRIM</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrtrim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonArrtrim(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim/">JSON.ARRTRIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonArrtrim(java.util.List<java.lang.String> args) {
    return 
jsonArrtrim(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim/">JSON.ARRTRIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonArrtrim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonArrtrim(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear/">JSON.CLEAR</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonClear(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonClear(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear/">JSON.CLEAR</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonClear(java.util.List<java.lang.String> args) {
    return 
jsonClear(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear/">JSON.CLEAR</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonClear(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonClear(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug/">JSON.DEBUG</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonDebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonDebug(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug/">JSON.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonDebug(java.util.List<java.lang.String> args) {
    return 
jsonDebug(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug/">JSON.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonDebug(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del/">JSON.DEL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonDel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonDel(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del/">JSON.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonDel(java.util.List<java.lang.String> args) {
    return 
jsonDel(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del/">JSON.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonDel(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget/">JSON.FORGET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonForget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonForget(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget/">JSON.FORGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonForget(java.util.List<java.lang.String> args) {
    return 
jsonForget(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget/">JSON.FORGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonForget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonForget(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get/">JSON.GET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonGet(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonGet(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get/">JSON.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonGet(java.util.List<java.lang.String> args) {
    return 
jsonGet(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get/">JSON.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonGet(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget/">JSON.MGET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonMget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonMget(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget/">JSON.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonMget(java.util.List<java.lang.String> args) {
    return 
jsonMget(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget/">JSON.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonMget(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby/">JSON.NUMINCRBY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonNumincrby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonNumincrby(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby/">JSON.NUMINCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonNumincrby(java.util.List<java.lang.String> args) {
    return 
jsonNumincrby(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby/">JSON.NUMINCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonNumincrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonNumincrby(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby/">JSON.NUMMULTBY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonNummultby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonNummultby(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby/">JSON.NUMMULTBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonNummultby(java.util.List<java.lang.String> args) {
    return 
jsonNummultby(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby/">JSON.NUMMULTBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonNummultby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonNummultby(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby/">JSON.NUMPOWBY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonNumpowby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonNumpowby(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby/">JSON.NUMPOWBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonNumpowby(java.util.List<java.lang.String> args) {
    return 
jsonNumpowby(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby/">JSON.NUMPOWBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonNumpowby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonNumpowby(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys/">JSON.OBJKEYS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonObjkeys(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonObjkeys(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys/">JSON.OBJKEYS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonObjkeys(java.util.List<java.lang.String> args) {
    return 
jsonObjkeys(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys/">JSON.OBJKEYS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonObjkeys(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonObjkeys(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen/">JSON.OBJLEN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonObjlen(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonObjlen(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen/">JSON.OBJLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonObjlen(java.util.List<java.lang.String> args) {
    return 
jsonObjlen(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen/">JSON.OBJLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonObjlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonObjlen(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp/">JSON.RESP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonResp(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonResp(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp/">JSON.RESP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonResp(java.util.List<java.lang.String> args) {
    return 
jsonResp(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp/">JSON.RESP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonResp(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonResp(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set/">JSON.SET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonSet(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonSet(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set/">JSON.SET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonSet(java.util.List<java.lang.String> args) {
    return 
jsonSet(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set/">JSON.SET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonSet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonSet(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend/">JSON.STRAPPEND</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonStrappend(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonStrappend(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend/">JSON.STRAPPEND</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonStrappend(java.util.List<java.lang.String> args) {
    return 
jsonStrappend(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend/">JSON.STRAPPEND</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonStrappend(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonStrappend(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen/">JSON.STRLEN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonStrlen(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonStrlen(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen/">JSON.STRLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonStrlen(java.util.List<java.lang.String> args) {
    return 
jsonStrlen(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen/">JSON.STRLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonStrlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonStrlen(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle/">JSON.TOGGLE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonToggle(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonToggle(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle/">JSON.TOGGLE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonToggle(java.util.List<java.lang.String> args) {
    return 
jsonToggle(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle/">JSON.TOGGLE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonToggle(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonToggle(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type/">JSON.TYPE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonType(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.jsonType(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type/">JSON.TYPE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI jsonType(java.util.List<java.lang.String> args) {
    return 
jsonType(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type/">JSON.TYPE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxJsonType(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      jsonType(args, $handler);
    });
  }

  /**
   * Find all keys matching the given pattern.
   * <p>
   * Redis command <a href="https://redis.io/commands/keys/">KEYS</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI keys(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.keys(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Find all keys matching the given pattern.
   * <p>
   * Redis command <a href="https://redis.io/commands/keys/">KEYS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI keys(java.lang.String arg0) {
    return 
keys(arg0, ar -> { });
  }

  /**
   * Find all keys matching the given pattern.
   * <p>
   * Redis command <a href="https://redis.io/commands/keys/">KEYS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxKeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      keys(arg0, $handler);
    });
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/lastsave/">LASTSAVE</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lastsave(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lastsave(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/lastsave/">LASTSAVE</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lastsave() {
    return 
lastsave(ar -> { });
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/lastsave/">LASTSAVE</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLastsave() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lastsave($handler);
    });
  }

  /**
   * A container for latency diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/latency/">LATENCY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI latency(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.latency(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for latency diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/latency/">LATENCY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI latency(java.util.List<java.lang.String> args) {
    return 
latency(args, ar -> { });
  }

  /**
   * A container for latency diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/latency/">LATENCY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLatency(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      latency(args, $handler);
    });
  }

  /**
   * Find longest common substring.
   * <p>
   * Redis command <a href="https://redis.io/commands/lcs/">LCS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lcs(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lcs(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Find longest common substring.
   * <p>
   * Redis command <a href="https://redis.io/commands/lcs/">LCS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lcs(java.util.List<java.lang.String> args) {
    return 
lcs(args, ar -> { });
  }

  /**
   * Find longest common substring.
   * <p>
   * Redis command <a href="https://redis.io/commands/lcs/">LCS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLcs(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lcs(args, $handler);
    });
  }

  /**
   * Get an element from a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lindex/">LINDEX</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lindex(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lindex(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get an element from a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lindex/">LINDEX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lindex(java.lang.String arg0, java.lang.String arg1) {
    return 
lindex(arg0, arg1, ar -> { });
  }

  /**
   * Get an element from a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lindex/">LINDEX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLindex(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lindex(arg0, arg1, $handler);
    });
  }

  /**
   * Insert an element before or after another element in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/linsert/">LINSERT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI linsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.linsert(arg0, arg1, arg2, arg3, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Insert an element before or after another element in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/linsert/">LINSERT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI linsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) {
    return 
linsert(arg0, arg1, arg2, arg3, ar -> { });
  }

  /**
   * Insert an element before or after another element in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/linsert/">LINSERT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLinsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      linsert(arg0, arg1, arg2, arg3, $handler);
    });
  }

  /**
   * Get the length of a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/llen/">LLEN</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI llen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.llen(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the length of a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/llen/">LLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI llen(java.lang.String arg0) {
    return 
llen(arg0, ar -> { });
  }

  /**
   * Get the length of a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/llen/">LLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      llen(arg0, $handler);
    });
  }

  /**
   * Pop an element from a list, push it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmove/">LMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lmove(arg0, arg1, arg2, arg3, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Pop an element from a list, push it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmove/">LMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) {
    return 
lmove(arg0, arg1, arg2, arg3, ar -> { });
  }

  /**
   * Pop an element from a list, push it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmove/">LMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lmove(arg0, arg1, arg2, arg3, $handler);
    });
  }

  /**
   * Pop elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmpop/">LMPOP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lmpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lmpop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Pop elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmpop/">LMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lmpop(java.util.List<java.lang.String> args) {
    return 
lmpop(args, ar -> { });
  }

  /**
   * Pop elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmpop/">LMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lmpop(args, $handler);
    });
  }

  /**
   * Display some computer art and the Redis version.
   * <p>
   * Redis command <a href="https://redis.io/commands/lolwut/">LOLWUT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lolwut(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lolwut(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Display some computer art and the Redis version.
   * <p>
   * Redis command <a href="https://redis.io/commands/lolwut/">LOLWUT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lolwut(java.util.List<java.lang.String> args) {
    return 
lolwut(args, ar -> { });
  }

  /**
   * Display some computer art and the Redis version.
   * <p>
   * Redis command <a href="https://redis.io/commands/lolwut/">LOLWUT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLolwut(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lolwut(args, $handler);
    });
  }

  /**
   * Remove and get the first elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpop/">LPOP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lpop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove and get the first elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpop/">LPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpop(java.util.List<java.lang.String> args) {
    return 
lpop(args, ar -> { });
  }

  /**
   * Remove and get the first elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpop/">LPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lpop(args, $handler);
    });
  }

  /**
   * Return the index of matching elements on a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpos/">LPOS</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpos(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lpos(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return the index of matching elements on a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpos/">LPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpos(java.util.List<java.lang.String> args) {
    return 
lpos(args, ar -> { });
  }

  /**
   * Return the index of matching elements on a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpos/">LPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLpos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lpos(args, $handler);
    });
  }

  /**
   * Prepend one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpush/">LPUSH</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpush(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lpush(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Prepend one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpush/">LPUSH</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpush(java.util.List<java.lang.String> args) {
    return 
lpush(args, ar -> { });
  }

  /**
   * Prepend one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpush/">LPUSH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lpush(args, $handler);
    });
  }

  /**
   * Prepend an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpushx/">LPUSHX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpushx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lpushx(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Prepend an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpushx/">LPUSHX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpushx(java.util.List<java.lang.String> args) {
    return 
lpushx(args, ar -> { });
  }

  /**
   * Prepend an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpushx/">LPUSHX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lpushx(args, $handler);
    });
  }

  /**
   * Get a range of elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrange/">LRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lrange(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get a range of elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrange/">LRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
lrange(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Get a range of elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrange/">LRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lrange(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Remove elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrem/">LREM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lrem(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrem/">LREM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
lrem(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Remove elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrem/">LREM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lrem(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Set the value of an element in a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lset/">LSET</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lset(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set the value of an element in a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lset/">LSET</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
lset(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Set the value of an element in a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lset/">LSET</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lset(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Trim a list to the specified range.
   * <p>
   * Redis command <a href="https://redis.io/commands/ltrim/">LTRIM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ltrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ltrim(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Trim a list to the specified range.
   * <p>
   * Redis command <a href="https://redis.io/commands/ltrim/">LTRIM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ltrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
ltrim(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Trim a list to the specified range.
   * <p>
   * Redis command <a href="https://redis.io/commands/ltrim/">LTRIM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLtrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ltrim(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * A container for memory diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/memory/">MEMORY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI memory(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.memory(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for memory diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/memory/">MEMORY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI memory(java.util.List<java.lang.String> args) {
    return 
memory(args, ar -> { });
  }

  /**
   * A container for memory diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/memory/">MEMORY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMemory(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      memory(args, $handler);
    });
  }

  /**
   * Get the values of all the given keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/mget/">MGET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI mget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.mget(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the values of all the given keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/mget/">MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI mget(java.util.List<java.lang.String> args) {
    return 
mget(args, ar -> { });
  }

  /**
   * Get the values of all the given keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/mget/">MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      mget(args, $handler);
    });
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * <p>
   * Redis command <a href="https://redis.io/commands/migrate/">MIGRATE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI migrate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.migrate(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * <p>
   * Redis command <a href="https://redis.io/commands/migrate/">MIGRATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI migrate(java.util.List<java.lang.String> args) {
    return 
migrate(args, ar -> { });
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * <p>
   * Redis command <a href="https://redis.io/commands/migrate/">MIGRATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMigrate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      migrate(args, $handler);
    });
  }

  /**
   * A container for module commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/module/">MODULE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI module(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.module(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for module commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/module/">MODULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI module(java.util.List<java.lang.String> args) {
    return 
module(args, ar -> { });
  }

  /**
   * A container for module commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/module/">MODULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxModule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      module(args, $handler);
    });
  }

  /**
   * Listen for all requests received by the server in real time.
   * <p>
   * Redis command <a href="https://redis.io/commands/monitor/">MONITOR</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI monitor(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.monitor(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Listen for all requests received by the server in real time.
   * <p>
   * Redis command <a href="https://redis.io/commands/monitor/">MONITOR</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI monitor() {
    return 
monitor(ar -> { });
  }

  /**
   * Listen for all requests received by the server in real time.
   * <p>
   * Redis command <a href="https://redis.io/commands/monitor/">MONITOR</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMonitor() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      monitor($handler);
    });
  }

  /**
   * Move a key to another database.
   * <p>
   * Redis command <a href="https://redis.io/commands/move/">MOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI move(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.move(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Move a key to another database.
   * <p>
   * Redis command <a href="https://redis.io/commands/move/">MOVE</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI move(java.lang.String arg0, java.lang.String arg1) {
    return 
move(arg0, arg1, ar -> { });
  }

  /**
   * Move a key to another database.
   * <p>
   * Redis command <a href="https://redis.io/commands/move/">MOVE</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMove(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      move(arg0, arg1, $handler);
    });
  }

  /**
   * Set multiple keys to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/mset/">MSET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI mset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.mset(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set multiple keys to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/mset/">MSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI mset(java.util.List<java.lang.String> args) {
    return 
mset(args, ar -> { });
  }

  /**
   * Set multiple keys to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/mset/">MSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      mset(args, $handler);
    });
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/msetnx/">MSETNX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI msetnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.msetnx(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/msetnx/">MSETNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI msetnx(java.util.List<java.lang.String> args) {
    return 
msetnx(args, ar -> { });
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/msetnx/">MSETNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMsetnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      msetnx(args, $handler);
    });
  }

  /**
   * Mark the start of a transaction block.
   * <p>
   * Redis command <a href="https://redis.io/commands/multi/">MULTI</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI multi(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.multi(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Mark the start of a transaction block.
   * <p>
   * Redis command <a href="https://redis.io/commands/multi/">MULTI</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI multi() {
    return 
multi(ar -> { });
  }

  /**
   * Mark the start of a transaction block.
   * <p>
   * Redis command <a href="https://redis.io/commands/multi/">MULTI</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMulti() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      multi($handler);
    });
  }

  /**
   * A container for object introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/object/">OBJECT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI object(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.object(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for object introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/object/">OBJECT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI object(java.util.List<java.lang.String> args) {
    return 
object(args, ar -> { });
  }

  /**
   * A container for object introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/object/">OBJECT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxObject(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      object(args, $handler);
    });
  }

  /**
   * Remove the expiration from a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/persist/">PERSIST</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI persist(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.persist(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove the expiration from a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/persist/">PERSIST</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI persist(java.lang.String arg0) {
    return 
persist(arg0, ar -> { });
  }

  /**
   * Remove the expiration from a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/persist/">PERSIST</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPersist(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      persist(arg0, $handler);
    });
  }

  /**
   * Set a key&#x27;s time to live in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpire/">PEXPIRE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpire(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pexpire(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set a key&#x27;s time to live in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpire/">PEXPIRE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpire(java.util.List<java.lang.String> args) {
    return 
pexpire(args, ar -> { });
  }

  /**
   * Set a key&#x27;s time to live in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpire/">PEXPIRE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPexpire(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pexpire(args, $handler);
    });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpireat/">PEXPIREAT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpireat(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pexpireat(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpireat/">PEXPIREAT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpireat(java.util.List<java.lang.String> args) {
    return 
pexpireat(args, ar -> { });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpireat/">PEXPIREAT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPexpireat(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pexpireat(args, $handler);
    });
  }

  /**
   * Get the expiration Unix timestamp for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpiretime/">PEXPIRETIME</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpiretime(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pexpiretime(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the expiration Unix timestamp for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpiretime/">PEXPIRETIME</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpiretime(java.lang.String arg0) {
    return 
pexpiretime(arg0, ar -> { });
  }

  /**
   * Get the expiration Unix timestamp for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpiretime/">PEXPIRETIME</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPexpiretime(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pexpiretime(arg0, $handler);
    });
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfadd/">PFADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfadd/">PFADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfadd(java.util.List<java.lang.String> args) {
    return 
pfadd(args, ar -> { });
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfadd/">PFADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPfadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pfadd(args, $handler);
    });
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * <p>
   * Redis command <a href="https://redis.io/commands/pfcount/">PFCOUNT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfcount(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfcount(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * <p>
   * Redis command <a href="https://redis.io/commands/pfcount/">PFCOUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfcount(java.util.List<java.lang.String> args) {
    return 
pfcount(args, ar -> { });
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * <p>
   * Redis command <a href="https://redis.io/commands/pfcount/">PFCOUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPfcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pfcount(args, $handler);
    });
  }

  /**
   * Internal commands for debugging HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfdebug/">PFDEBUG</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfdebug(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfdebug(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Internal commands for debugging HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfdebug/">PFDEBUG</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfdebug(java.lang.String arg0, java.lang.String arg1) {
    return 
pfdebug(arg0, arg1, ar -> { });
  }

  /**
   * Internal commands for debugging HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfdebug/">PFDEBUG</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPfdebug(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pfdebug(arg0, arg1, $handler);
    });
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfmerge/">PFMERGE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfmerge(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfmerge(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfmerge/">PFMERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfmerge(java.util.List<java.lang.String> args) {
    return 
pfmerge(args, ar -> { });
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfmerge/">PFMERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPfmerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pfmerge(args, $handler);
    });
  }

  /**
   * An internal command for testing HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfselftest/">PFSELFTEST</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfselftest(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfselftest(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * An internal command for testing HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfselftest/">PFSELFTEST</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfselftest() {
    return 
pfselftest(ar -> { });
  }

  /**
   * An internal command for testing HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfselftest/">PFSELFTEST</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPfselftest() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pfselftest($handler);
    });
  }

  /**
   * Ping the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/ping/">PING</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ping(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ping(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Ping the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/ping/">PING</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ping(java.util.List<java.lang.String> args) {
    return 
ping(args, ar -> { });
  }

  /**
   * Ping the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/ping/">PING</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPing(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ping(args, $handler);
    });
  }

  /**
   * Set the value and expiration in milliseconds of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/psetex/">PSETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.psetex(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set the value and expiration in milliseconds of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/psetex/">PSETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
psetex(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Set the value and expiration in milliseconds of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/psetex/">PSETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPsetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      psetex(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Listen for messages published to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/psubscribe/">PSUBSCRIBE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.psubscribe(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Listen for messages published to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/psubscribe/">PSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psubscribe(java.util.List<java.lang.String> args) {
    return 
psubscribe(args, ar -> { });
  }

  /**
   * Listen for messages published to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/psubscribe/">PSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      psubscribe(args, $handler);
    });
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/psync/">PSYNC</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psync(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.psync(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/psync/">PSYNC</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psync(java.util.List<java.lang.String> args) {
    return 
psync(args, ar -> { });
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/psync/">PSYNC</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPsync(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      psync(args, $handler);
    });
  }

  /**
   * Get the time to live for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pttl/">PTTL</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pttl(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pttl(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the time to live for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pttl/">PTTL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pttl(java.lang.String arg0) {
    return 
pttl(arg0, ar -> { });
  }

  /**
   * Get the time to live for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pttl/">PTTL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPttl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pttl(arg0, $handler);
    });
  }

  /**
   * Post a message to a channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/publish/">PUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI publish(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.publish(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Post a message to a channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/publish/">PUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI publish(java.lang.String arg0, java.lang.String arg1) {
    return 
publish(arg0, arg1, ar -> { });
  }

  /**
   * Post a message to a channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/publish/">PUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPublish(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      publish(arg0, arg1, $handler);
    });
  }

  /**
   * A container for Pub/Sub commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/pubsub/">PUBSUB</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pubsub(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pubsub(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for Pub/Sub commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/pubsub/">PUBSUB</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pubsub(java.util.List<java.lang.String> args) {
    return 
pubsub(args, ar -> { });
  }

  /**
   * A container for Pub/Sub commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/pubsub/">PUBSUB</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPubsub(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pubsub(args, $handler);
    });
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/punsubscribe/">PUNSUBSCRIBE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI punsubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.punsubscribe(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/punsubscribe/">PUNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI punsubscribe(java.util.List<java.lang.String> args) {
    return 
punsubscribe(args, ar -> { });
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/punsubscribe/">PUNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPunsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      punsubscribe(args, $handler);
    });
  }

  /**
   * Close the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/quit/">QUIT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI quit(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.quit(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Close the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/quit/">QUIT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI quit(java.util.List<java.lang.String> args) {
    return 
quit(args, ar -> { });
  }

  /**
   * Close the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/quit/">QUIT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxQuit(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      quit(args, $handler);
    });
  }

  /**
   * Return a random key from the keyspace.
   * <p>
   * Redis command <a href="https://redis.io/commands/randomkey/">RANDOMKEY</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI randomkey(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.randomkey(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return a random key from the keyspace.
   * <p>
   * Redis command <a href="https://redis.io/commands/randomkey/">RANDOMKEY</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI randomkey() {
    return 
randomkey(ar -> { });
  }

  /**
   * Return a random key from the keyspace.
   * <p>
   * Redis command <a href="https://redis.io/commands/randomkey/">RANDOMKEY</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRandomkey() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      randomkey($handler);
    });
  }

  /**
   * Enables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readonly/">READONLY</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI readonly(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.readonly(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Enables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readonly/">READONLY</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI readonly() {
    return 
readonly(ar -> { });
  }

  /**
   * Enables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readonly/">READONLY</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxReadonly() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      readonly($handler);
    });
  }

  /**
   * Disables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readwrite/">READWRITE</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI readwrite(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.readwrite(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Disables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readwrite/">READWRITE</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI readwrite() {
    return 
readwrite(ar -> { });
  }

  /**
   * Disables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readwrite/">READWRITE</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxReadwrite() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      readwrite($handler);
    });
  }

  /**
   * Rename a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/rename/">RENAME</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rename(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rename(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Rename a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/rename/">RENAME</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rename(java.lang.String arg0, java.lang.String arg1) {
    return 
rename(arg0, arg1, ar -> { });
  }

  /**
   * Rename a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/rename/">RENAME</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRename(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      rename(arg0, arg1, $handler);
    });
  }

  /**
   * Rename a key, only if the new key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/renamenx/">RENAMENX</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI renamenx(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.renamenx(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Rename a key, only if the new key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/renamenx/">RENAMENX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI renamenx(java.lang.String arg0, java.lang.String arg1) {
    return 
renamenx(arg0, arg1, ar -> { });
  }

  /**
   * Rename a key, only if the new key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/renamenx/">RENAMENX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRenamenx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      renamenx(arg0, arg1, $handler);
    });
  }

  /**
   * An internal command for configuring the replication stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/replconf/">REPLCONF</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI replconf(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.replconf(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * An internal command for configuring the replication stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/replconf/">REPLCONF</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI replconf(java.util.List<java.lang.String> args) {
    return 
replconf(args, ar -> { });
  }

  /**
   * An internal command for configuring the replication stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/replconf/">REPLCONF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxReplconf(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      replconf(args, $handler);
    });
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/replicaof/">REPLICAOF</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI replicaof(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.replicaof(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/replicaof/">REPLICAOF</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI replicaof(java.lang.String arg0, java.lang.String arg1) {
    return 
replicaof(arg0, arg1, ar -> { });
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/replicaof/">REPLICAOF</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxReplicaof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      replicaof(arg0, arg1, $handler);
    });
  }

  /**
   * Reset the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/reset/">RESET</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI reset(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.reset(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Reset the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/reset/">RESET</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI reset() {
    return 
reset(ar -> { });
  }

  /**
   * Reset the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/reset/">RESET</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxReset() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      reset($handler);
    });
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore/">RESTORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI restore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.restore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore/">RESTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI restore(java.util.List<java.lang.String> args) {
    return 
restore(args, ar -> { });
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore/">RESTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRestore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      restore(args, $handler);
    });
  }

  /**
   * An internal command for migrating keys in a cluster.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore asking/">RESTORE-ASKING</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI restoreAsking(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.restoreAsking(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * An internal command for migrating keys in a cluster.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore asking/">RESTORE-ASKING</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI restoreAsking(java.util.List<java.lang.String> args) {
    return 
restoreAsking(args, ar -> { });
  }

  /**
   * An internal command for migrating keys in a cluster.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore asking/">RESTORE-ASKING</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRestoreAsking(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      restoreAsking(args, $handler);
    });
  }

  /**
   * Return the role of the instance in the context of replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/role/">ROLE</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI role(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.role(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return the role of the instance in the context of replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/role/">ROLE</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI role() {
    return 
role(ar -> { });
  }

  /**
   * Return the role of the instance in the context of replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/role/">ROLE</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRole() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      role($handler);
    });
  }

  /**
   * Remove and get the last elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpop/">RPOP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove and get the last elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpop/">RPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpop(java.util.List<java.lang.String> args) {
    return 
rpop(args, ar -> { });
  }

  /**
   * Remove and get the last elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpop/">RPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      rpop(args, $handler);
    });
  }

  /**
   * Remove the last element in a list, prepend it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpoplpush/">RPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpoplpush(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpoplpush(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove the last element in a list, prepend it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpoplpush/">RPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpoplpush(java.lang.String arg0, java.lang.String arg1) {
    return 
rpoplpush(arg0, arg1, ar -> { });
  }

  /**
   * Remove the last element in a list, prepend it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpoplpush/">RPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRpoplpush(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      rpoplpush(arg0, arg1, $handler);
    });
  }

  /**
   * Append one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpush/">RPUSH</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpush(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpush(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Append one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpush/">RPUSH</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpush(java.util.List<java.lang.String> args) {
    return 
rpush(args, ar -> { });
  }

  /**
   * Append one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpush/">RPUSH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      rpush(args, $handler);
    });
  }

  /**
   * Append an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpushx/">RPUSHX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpushx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpushx(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Append an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpushx/">RPUSHX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpushx(java.util.List<java.lang.String> args) {
    return 
rpushx(args, ar -> { });
  }

  /**
   * Append an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpushx/">RPUSHX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      rpushx(args, $handler);
    });
  }

  /**
   * Add one or more members to a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sadd/">SADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Add one or more members to a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sadd/">SADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sadd(java.util.List<java.lang.String> args) {
    return 
sadd(args, ar -> { });
  }

  /**
   * Add one or more members to a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sadd/">SADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sadd(args, $handler);
    });
  }

  /**
   * Synchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/save/">SAVE</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI save(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.save(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Synchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/save/">SAVE</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI save() {
    return 
save(ar -> { });
  }

  /**
   * Synchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/save/">SAVE</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSave() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      save($handler);
    });
  }

  /**
   * Incrementally iterate the keys space.
   * <p>
   * Redis command <a href="https://redis.io/commands/scan/">SCAN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI scan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.scan(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Incrementally iterate the keys space.
   * <p>
   * Redis command <a href="https://redis.io/commands/scan/">SCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI scan(java.util.List<java.lang.String> args) {
    return 
scan(args, ar -> { });
  }

  /**
   * Incrementally iterate the keys space.
   * <p>
   * Redis command <a href="https://redis.io/commands/scan/">SCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxScan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      scan(args, $handler);
    });
  }

  /**
   * Get the number of members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/scard/">SCARD</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI scard(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.scard(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the number of members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/scard/">SCARD</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI scard(java.lang.String arg0) {
    return 
scard(arg0, ar -> { });
  }

  /**
   * Get the number of members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/scard/">SCARD</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxScard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      scard(arg0, $handler);
    });
  }

  /**
   * A container for Lua scripts management commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/script/">SCRIPT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI script(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.script(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for Lua scripts management commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/script/">SCRIPT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI script(java.util.List<java.lang.String> args) {
    return 
script(args, ar -> { });
  }

  /**
   * A container for Lua scripts management commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/script/">SCRIPT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxScript(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      script(args, $handler);
    });
  }

  /**
   * Subtract multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiff/">SDIFF</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sdiff(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sdiff(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Subtract multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiff/">SDIFF</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sdiff(java.util.List<java.lang.String> args) {
    return 
sdiff(args, ar -> { });
  }

  /**
   * Subtract multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiff/">SDIFF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSdiff(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sdiff(args, $handler);
    });
  }

  /**
   * Subtract multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiffstore/">SDIFFSTORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sdiffstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sdiffstore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Subtract multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiffstore/">SDIFFSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sdiffstore(java.util.List<java.lang.String> args) {
    return 
sdiffstore(args, ar -> { });
  }

  /**
   * Subtract multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiffstore/">SDIFFSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSdiffstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sdiffstore(args, $handler);
    });
  }

  /**
   * Change the selected database for the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/select/">SELECT</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI select(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.select(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Change the selected database for the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/select/">SELECT</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI select(java.lang.String arg0) {
    return 
select(arg0, ar -> { });
  }

  /**
   * Change the selected database for the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/select/">SELECT</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSelect(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      select(arg0, $handler);
    });
  }

  /**
   * Set the string value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/set/">SET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI set(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.set(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set the string value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/set/">SET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI set(java.util.List<java.lang.String> args) {
    return 
set(args, ar -> { });
  }

  /**
   * Set the string value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/set/">SET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      set(args, $handler);
    });
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setbit/">SETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setbit(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setbit/">SETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
setbit(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setbit/">SETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSetbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      setbit(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Set the value and expiration of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setex/">SETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setex(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set the value and expiration of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setex/">SETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
setex(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Set the value and expiration of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setex/">SETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      setex(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Set the value of a key, only if the key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/setnx/">SETNX</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setnx(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setnx(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Set the value of a key, only if the key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/setnx/">SETNX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setnx(java.lang.String arg0, java.lang.String arg1) {
    return 
setnx(arg0, arg1, ar -> { });
  }

  /**
   * Set the value of a key, only if the key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/setnx/">SETNX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSetnx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      setnx(arg0, arg1, $handler);
    });
  }

  /**
   * Overwrite part of a string at key starting at the specified offset.
   * <p>
   * Redis command <a href="https://redis.io/commands/setrange/">SETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setrange(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Overwrite part of a string at key starting at the specified offset.
   * <p>
   * Redis command <a href="https://redis.io/commands/setrange/">SETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
setrange(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Overwrite part of a string at key starting at the specified offset.
   * <p>
   * Redis command <a href="https://redis.io/commands/setrange/">SETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      setrange(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Synchronously save the dataset to disk and then shut down the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/shutdown/">SHUTDOWN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI shutdown(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.shutdown(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Synchronously save the dataset to disk and then shut down the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/shutdown/">SHUTDOWN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI shutdown(java.util.List<java.lang.String> args) {
    return 
shutdown(args, ar -> { });
  }

  /**
   * Synchronously save the dataset to disk and then shut down the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/shutdown/">SHUTDOWN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxShutdown(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      shutdown(args, $handler);
    });
  }

  /**
   * Intersect multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinter/">SINTER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sinter(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sinter(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Intersect multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinter/">SINTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sinter(java.util.List<java.lang.String> args) {
    return 
sinter(args, ar -> { });
  }

  /**
   * Intersect multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinter/">SINTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSinter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sinter(args, $handler);
    });
  }

  /**
   * Intersect multiple sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/sintercard/">SINTERCARD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sintercard(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sintercard(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Intersect multiple sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/sintercard/">SINTERCARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sintercard(java.util.List<java.lang.String> args) {
    return 
sintercard(args, ar -> { });
  }

  /**
   * Intersect multiple sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/sintercard/">SINTERCARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSintercard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sintercard(args, $handler);
    });
  }

  /**
   * Intersect multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinterstore/">SINTERSTORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sinterstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sinterstore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Intersect multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinterstore/">SINTERSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sinterstore(java.util.List<java.lang.String> args) {
    return 
sinterstore(args, ar -> { });
  }

  /**
   * Intersect multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinterstore/">SINTERSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sinterstore(args, $handler);
    });
  }

  /**
   * Determine if a given value is a member of a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sismember/">SISMEMBER</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sismember(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sismember(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Determine if a given value is a member of a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sismember/">SISMEMBER</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sismember(java.lang.String arg0, java.lang.String arg1) {
    return 
sismember(arg0, arg1, ar -> { });
  }

  /**
   * Determine if a given value is a member of a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sismember/">SISMEMBER</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSismember(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sismember(arg0, arg1, $handler);
    });
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/slaveof/">SLAVEOF</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI slaveof(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.slaveof(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/slaveof/">SLAVEOF</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI slaveof(java.lang.String arg0, java.lang.String arg1) {
    return 
slaveof(arg0, arg1, ar -> { });
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/slaveof/">SLAVEOF</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSlaveof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      slaveof(arg0, arg1, $handler);
    });
  }

  /**
   * A container for slow log commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/slowlog/">SLOWLOG</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI slowlog(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.slowlog(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for slow log commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/slowlog/">SLOWLOG</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI slowlog(java.util.List<java.lang.String> args) {
    return 
slowlog(args, ar -> { });
  }

  /**
   * A container for slow log commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/slowlog/">SLOWLOG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSlowlog(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      slowlog(args, $handler);
    });
  }

  /**
   * Get all the members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smembers/">SMEMBERS</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smembers(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.smembers(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get all the members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smembers/">SMEMBERS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smembers(java.lang.String arg0) {
    return 
smembers(arg0, ar -> { });
  }

  /**
   * Get all the members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smembers/">SMEMBERS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSmembers(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      smembers(arg0, $handler);
    });
  }

  /**
   * Returns the membership associated with the given elements for a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smismember/">SMISMEMBER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smismember(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.smismember(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Returns the membership associated with the given elements for a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smismember/">SMISMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smismember(java.util.List<java.lang.String> args) {
    return 
smismember(args, ar -> { });
  }

  /**
   * Returns the membership associated with the given elements for a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smismember/">SMISMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSmismember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      smismember(args, $handler);
    });
  }

  /**
   * Move a member from one set to another.
   * <p>
   * Redis command <a href="https://redis.io/commands/smove/">SMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.smove(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Move a member from one set to another.
   * <p>
   * Redis command <a href="https://redis.io/commands/smove/">SMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
smove(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Move a member from one set to another.
   * <p>
   * Redis command <a href="https://redis.io/commands/smove/">SMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      smove(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Sort the elements in a list, set or sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort/">SORT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sort(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sort(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Sort the elements in a list, set or sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort/">SORT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sort(java.util.List<java.lang.String> args) {
    return 
sort(args, ar -> { });
  }

  /**
   * Sort the elements in a list, set or sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort/">SORT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSort(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sort(args, $handler);
    });
  }

  /**
   * Sort the elements in a list, set or sorted set. Read-only variant of SORT.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort_ro/">SORT_RO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sortRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sortRo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Sort the elements in a list, set or sorted set. Read-only variant of SORT.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort_ro/">SORT_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sortRo(java.util.List<java.lang.String> args) {
    return 
sortRo(args, ar -> { });
  }

  /**
   * Sort the elements in a list, set or sorted set. Read-only variant of SORT.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort_ro/">SORT_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSortRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sortRo(args, $handler);
    });
  }

  /**
   * Remove and return one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/spop/">SPOP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI spop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.spop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove and return one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/spop/">SPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI spop(java.util.List<java.lang.String> args) {
    return 
spop(args, ar -> { });
  }

  /**
   * Remove and return one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/spop/">SPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      spop(args, $handler);
    });
  }

  /**
   * Post a message to a shard channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/spublish/">SPUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI spublish(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.spublish(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Post a message to a shard channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/spublish/">SPUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI spublish(java.lang.String arg0, java.lang.String arg1) {
    return 
spublish(arg0, arg1, ar -> { });
  }

  /**
   * Post a message to a shard channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/spublish/">SPUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSpublish(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      spublish(arg0, arg1, $handler);
    });
  }

  /**
   * Get one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srandmember/">SRANDMEMBER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI srandmember(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.srandmember(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srandmember/">SRANDMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI srandmember(java.util.List<java.lang.String> args) {
    return 
srandmember(args, ar -> { });
  }

  /**
   * Get one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srandmember/">SRANDMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSrandmember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      srandmember(args, $handler);
    });
  }

  /**
   * Remove one or more members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srem/">SREM</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI srem(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.srem(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove one or more members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srem/">SREM</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI srem(java.util.List<java.lang.String> args) {
    return 
srem(args, ar -> { });
  }

  /**
   * Remove one or more members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srem/">SREM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      srem(args, $handler);
    });
  }

  /**
   * Incrementally iterate Set elements.
   * <p>
   * Redis command <a href="https://redis.io/commands/sscan/">SSCAN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sscan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sscan(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Incrementally iterate Set elements.
   * <p>
   * Redis command <a href="https://redis.io/commands/sscan/">SSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sscan(java.util.List<java.lang.String> args) {
    return 
sscan(args, ar -> { });
  }

  /**
   * Incrementally iterate Set elements.
   * <p>
   * Redis command <a href="https://redis.io/commands/sscan/">SSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sscan(args, $handler);
    });
  }

  /**
   * Listen for messages published to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/ssubscribe/">SSUBSCRIBE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ssubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ssubscribe(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Listen for messages published to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/ssubscribe/">SSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ssubscribe(java.util.List<java.lang.String> args) {
    return 
ssubscribe(args, ar -> { });
  }

  /**
   * Listen for messages published to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/ssubscribe/">SSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ssubscribe(args, $handler);
    });
  }

  /**
   * Get the length of the value stored in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/strlen/">STRLEN</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI strlen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.strlen(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the length of the value stored in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/strlen/">STRLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI strlen(java.lang.String arg0) {
    return 
strlen(arg0, ar -> { });
  }

  /**
   * Get the length of the value stored in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/strlen/">STRLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxStrlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      strlen(arg0, $handler);
    });
  }

  /**
   * Listen for messages published to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/subscribe/">SUBSCRIBE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI subscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.subscribe(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Listen for messages published to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/subscribe/">SUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI subscribe(java.util.List<java.lang.String> args) {
    return 
subscribe(args, ar -> { });
  }

  /**
   * Listen for messages published to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/subscribe/">SUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      subscribe(args, $handler);
    });
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/substr/">SUBSTR</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI substr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.substr(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/substr/">SUBSTR</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI substr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
substr(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/substr/">SUBSTR</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSubstr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      substr(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Add multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunion/">SUNION</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunion(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sunion(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Add multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunion/">SUNION</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunion(java.util.List<java.lang.String> args) {
    return 
sunion(args, ar -> { });
  }

  /**
   * Add multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunion/">SUNION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSunion(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sunion(args, $handler);
    });
  }

  /**
   * Add multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunionstore/">SUNIONSTORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunionstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sunionstore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Add multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunionstore/">SUNIONSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunionstore(java.util.List<java.lang.String> args) {
    return 
sunionstore(args, ar -> { });
  }

  /**
   * Add multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunionstore/">SUNIONSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sunionstore(args, $handler);
    });
  }

  /**
   * Stop listening for messages posted to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunsubscribe/">SUNSUBSCRIBE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunsubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sunsubscribe(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Stop listening for messages posted to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunsubscribe/">SUNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunsubscribe(java.util.List<java.lang.String> args) {
    return 
sunsubscribe(args, ar -> { });
  }

  /**
   * Stop listening for messages posted to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunsubscribe/">SUNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSunsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sunsubscribe(args, $handler);
    });
  }

  /**
   * Swaps two Redis databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/swapdb/">SWAPDB</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI swapdb(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.swapdb(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Swaps two Redis databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/swapdb/">SWAPDB</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI swapdb(java.lang.String arg0, java.lang.String arg1) {
    return 
swapdb(arg0, arg1, ar -> { });
  }

  /**
   * Swaps two Redis databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/swapdb/">SWAPDB</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSwapdb(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      swapdb(arg0, arg1, $handler);
    });
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/sync/">SYNC</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sync(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sync(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/sync/">SYNC</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sync() {
    return 
sync(ar -> { });
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/sync/">SYNC</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSync() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sync($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.add/">TDIGEST.ADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestAdd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestAdd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.add/">TDIGEST.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestAdd(java.util.List<java.lang.String> args) {
    return 
tdigestAdd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.add/">TDIGEST.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestAdd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrank/">TDIGEST.BYRANK</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestByrank(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestByrank(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrank/">TDIGEST.BYRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestByrank(java.util.List<java.lang.String> args) {
    return 
tdigestByrank(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrank/">TDIGEST.BYRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestByrank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestByrank(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrevrank/">TDIGEST.BYREVRANK</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestByrevrank(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestByrevrank(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrevrank/">TDIGEST.BYREVRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestByrevrank(java.util.List<java.lang.String> args) {
    return 
tdigestByrevrank(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrevrank/">TDIGEST.BYREVRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestByrevrank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestByrevrank(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.cdf/">TDIGEST.CDF</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestCdf(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestCdf(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.cdf/">TDIGEST.CDF</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestCdf(java.util.List<java.lang.String> args) {
    return 
tdigestCdf(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.cdf/">TDIGEST.CDF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestCdf(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestCdf(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.create/">TDIGEST.CREATE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestCreate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestCreate(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.create/">TDIGEST.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestCreate(java.util.List<java.lang.String> args) {
    return 
tdigestCreate(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.create/">TDIGEST.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestCreate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestCreate(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.info/">TDIGEST.INFO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestInfo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.info/">TDIGEST.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestInfo(java.util.List<java.lang.String> args) {
    return 
tdigestInfo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.info/">TDIGEST.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestInfo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.max/">TDIGEST.MAX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestMax(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestMax(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.max/">TDIGEST.MAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestMax(java.util.List<java.lang.String> args) {
    return 
tdigestMax(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.max/">TDIGEST.MAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestMax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestMax(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.merge/">TDIGEST.MERGE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestMerge(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestMerge(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.merge/">TDIGEST.MERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestMerge(java.util.List<java.lang.String> args) {
    return 
tdigestMerge(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.merge/">TDIGEST.MERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestMerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestMerge(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.min/">TDIGEST.MIN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestMin(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestMin(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.min/">TDIGEST.MIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestMin(java.util.List<java.lang.String> args) {
    return 
tdigestMin(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.min/">TDIGEST.MIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestMin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestMin(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.quantile/">TDIGEST.QUANTILE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestQuantile(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestQuantile(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.quantile/">TDIGEST.QUANTILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestQuantile(java.util.List<java.lang.String> args) {
    return 
tdigestQuantile(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.quantile/">TDIGEST.QUANTILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestQuantile(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestQuantile(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.rank/">TDIGEST.RANK</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestRank(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestRank(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.rank/">TDIGEST.RANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestRank(java.util.List<java.lang.String> args) {
    return 
tdigestRank(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.rank/">TDIGEST.RANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestRank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestRank(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.reset/">TDIGEST.RESET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestReset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestReset(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.reset/">TDIGEST.RESET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestReset(java.util.List<java.lang.String> args) {
    return 
tdigestReset(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.reset/">TDIGEST.RESET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestReset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestReset(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.revrank/">TDIGEST.REVRANK</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestRevrank(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestRevrank(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.revrank/">TDIGEST.REVRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestRevrank(java.util.List<java.lang.String> args) {
    return 
tdigestRevrank(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.revrank/">TDIGEST.REVRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestRevrank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestRevrank(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.trimmed_mean/">TDIGEST.TRIMMED_MEAN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestTrimmedMean(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tdigestTrimmedMean(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.trimmed_mean/">TDIGEST.TRIMMED_MEAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tdigestTrimmedMean(java.util.List<java.lang.String> args) {
    return 
tdigestTrimmedMean(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.trimmed_mean/">TDIGEST.TRIMMED_MEAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTdigestTrimmedMean(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tdigestTrimmedMean(args, $handler);
    });
  }

  /**
   * Return the current server time.
   * <p>
   * Redis command <a href="https://redis.io/commands/time/">TIME</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI time(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.time(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return the current server time.
   * <p>
   * Redis command <a href="https://redis.io/commands/time/">TIME</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI time() {
    return 
time(ar -> { });
  }

  /**
   * Return the current server time.
   * <p>
   * Redis command <a href="https://redis.io/commands/time/">TIME</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTime() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      time($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clusterset/">TIMESERIES.CLUSTERSET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesClusterset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.timeseriesClusterset(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clusterset/">TIMESERIES.CLUSTERSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesClusterset(java.util.List<java.lang.String> args) {
    return 
timeseriesClusterset(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clusterset/">TIMESERIES.CLUSTERSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTimeseriesClusterset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      timeseriesClusterset(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clustersetfromshard/">TIMESERIES.CLUSTERSETFROMSHARD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesClustersetfromshard(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.timeseriesClustersetfromshard(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clustersetfromshard/">TIMESERIES.CLUSTERSETFROMSHARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesClustersetfromshard(java.util.List<java.lang.String> args) {
    return 
timeseriesClustersetfromshard(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clustersetfromshard/">TIMESERIES.CLUSTERSETFROMSHARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTimeseriesClustersetfromshard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      timeseriesClustersetfromshard(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.hello/">TIMESERIES.HELLO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesHello(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.timeseriesHello(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.hello/">TIMESERIES.HELLO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesHello(java.util.List<java.lang.String> args) {
    return 
timeseriesHello(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.hello/">TIMESERIES.HELLO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTimeseriesHello(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      timeseriesHello(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.infocluster/">TIMESERIES.INFOCLUSTER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesInfocluster(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.timeseriesInfocluster(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.infocluster/">TIMESERIES.INFOCLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesInfocluster(java.util.List<java.lang.String> args) {
    return 
timeseriesInfocluster(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.infocluster/">TIMESERIES.INFOCLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTimeseriesInfocluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      timeseriesInfocluster(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.innercommunication/">TIMESERIES.INNERCOMMUNICATION</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesInnercommunication(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.timeseriesInnercommunication(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.innercommunication/">TIMESERIES.INNERCOMMUNICATION</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesInnercommunication(java.util.List<java.lang.String> args) {
    return 
timeseriesInnercommunication(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.innercommunication/">TIMESERIES.INNERCOMMUNICATION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTimeseriesInnercommunication(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      timeseriesInnercommunication(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.networktest/">TIMESERIES.NETWORKTEST</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesNetworktest(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.timeseriesNetworktest(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.networktest/">TIMESERIES.NETWORKTEST</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesNetworktest(java.util.List<java.lang.String> args) {
    return 
timeseriesNetworktest(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.networktest/">TIMESERIES.NETWORKTEST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTimeseriesNetworktest(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      timeseriesNetworktest(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.refreshcluster/">TIMESERIES.REFRESHCLUSTER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesRefreshcluster(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.timeseriesRefreshcluster(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.refreshcluster/">TIMESERIES.REFRESHCLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI timeseriesRefreshcluster(java.util.List<java.lang.String> args) {
    return 
timeseriesRefreshcluster(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.refreshcluster/">TIMESERIES.REFRESHCLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTimeseriesRefreshcluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      timeseriesRefreshcluster(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add/">TOPK.ADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkAdd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.topkAdd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add/">TOPK.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkAdd(java.util.List<java.lang.String> args) {
    return 
topkAdd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add/">TOPK.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTopkAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      topkAdd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count/">TOPK.COUNT</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkCount(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.topkCount(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count/">TOPK.COUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkCount(java.util.List<java.lang.String> args) {
    return 
topkCount(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count/">TOPK.COUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTopkCount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      topkCount(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby/">TOPK.INCRBY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkIncrby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.topkIncrby(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby/">TOPK.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkIncrby(java.util.List<java.lang.String> args) {
    return 
topkIncrby(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby/">TOPK.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTopkIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      topkIncrby(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info/">TOPK.INFO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.topkInfo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info/">TOPK.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkInfo(java.util.List<java.lang.String> args) {
    return 
topkInfo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info/">TOPK.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTopkInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      topkInfo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list/">TOPK.LIST</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkList(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.topkList(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list/">TOPK.LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkList(java.util.List<java.lang.String> args) {
    return 
topkList(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list/">TOPK.LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTopkList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      topkList(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query/">TOPK.QUERY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkQuery(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.topkQuery(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query/">TOPK.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkQuery(java.util.List<java.lang.String> args) {
    return 
topkQuery(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query/">TOPK.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTopkQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      topkQuery(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve/">TOPK.RESERVE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkReserve(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.topkReserve(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve/">TOPK.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI topkReserve(java.util.List<java.lang.String> args) {
    return 
topkReserve(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve/">TOPK.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTopkReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      topkReserve(args, $handler);
    });
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * <p>
   * Redis command <a href="https://redis.io/commands/touch/">TOUCH</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI touch(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.touch(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * <p>
   * Redis command <a href="https://redis.io/commands/touch/">TOUCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI touch(java.util.List<java.lang.String> args) {
    return 
touch(args, ar -> { });
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * <p>
   * Redis command <a href="https://redis.io/commands/touch/">TOUCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTouch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      touch(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add/">TS.ADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsAdd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsAdd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add/">TS.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsAdd(java.util.List<java.lang.String> args) {
    return 
tsAdd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add/">TS.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsAdd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter/">TS.ALTER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsAlter(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsAlter(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter/">TS.ALTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsAlter(java.util.List<java.lang.String> args) {
    return 
tsAlter(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter/">TS.ALTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsAlter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsAlter(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create/">TS.CREATE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsCreate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsCreate(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create/">TS.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsCreate(java.util.List<java.lang.String> args) {
    return 
tsCreate(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create/">TS.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsCreate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsCreate(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule/">TS.CREATERULE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsCreaterule(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsCreaterule(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule/">TS.CREATERULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsCreaterule(java.util.List<java.lang.String> args) {
    return 
tsCreaterule(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule/">TS.CREATERULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsCreaterule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsCreaterule(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby/">TS.DECRBY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsDecrby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsDecrby(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby/">TS.DECRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsDecrby(java.util.List<java.lang.String> args) {
    return 
tsDecrby(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby/">TS.DECRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsDecrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsDecrby(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del/">TS.DEL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsDel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsDel(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del/">TS.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsDel(java.util.List<java.lang.String> args) {
    return 
tsDel(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del/">TS.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsDel(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule/">TS.DELETERULE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsDeleterule(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsDeleterule(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule/">TS.DELETERULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsDeleterule(java.util.List<java.lang.String> args) {
    return 
tsDeleterule(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule/">TS.DELETERULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsDeleterule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsDeleterule(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get/">TS.GET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsGet(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsGet(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get/">TS.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsGet(java.util.List<java.lang.String> args) {
    return 
tsGet(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get/">TS.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsGet(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby/">TS.INCRBY</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsIncrby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsIncrby(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby/">TS.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsIncrby(java.util.List<java.lang.String> args) {
    return 
tsIncrby(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby/">TS.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsIncrby(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info/">TS.INFO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsInfo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info/">TS.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsInfo(java.util.List<java.lang.String> args) {
    return 
tsInfo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info/">TS.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsInfo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd/">TS.MADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsMadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsMadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd/">TS.MADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsMadd(java.util.List<java.lang.String> args) {
    return 
tsMadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd/">TS.MADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsMadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsMadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget/">TS.MGET</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsMget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsMget(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget/">TS.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsMget(java.util.List<java.lang.String> args) {
    return 
tsMget(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget/">TS.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsMget(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange/">TS.MRANGE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsMrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsMrange(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange/">TS.MRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsMrange(java.util.List<java.lang.String> args) {
    return 
tsMrange(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange/">TS.MRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsMrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsMrange(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange/">TS.MREVRANGE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsMrevrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsMrevrange(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange/">TS.MREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsMrevrange(java.util.List<java.lang.String> args) {
    return 
tsMrevrange(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange/">TS.MREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsMrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsMrevrange(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex/">TS.QUERYINDEX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsQueryindex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsQueryindex(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex/">TS.QUERYINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsQueryindex(java.util.List<java.lang.String> args) {
    return 
tsQueryindex(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex/">TS.QUERYINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsQueryindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsQueryindex(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range/">TS.RANGE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsRange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsRange(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range/">TS.RANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsRange(java.util.List<java.lang.String> args) {
    return 
tsRange(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range/">TS.RANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsRange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsRange(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange/">TS.REVRANGE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsRevrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.tsRevrange(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange/">TS.REVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI tsRevrange(java.util.List<java.lang.String> args) {
    return 
tsRevrange(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange/">TS.REVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTsRevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      tsRevrange(args, $handler);
    });
  }

  /**
   * Get the time to live for a key in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/ttl/">TTL</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ttl(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ttl(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the time to live for a key in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/ttl/">TTL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ttl(java.lang.String arg0) {
    return 
ttl(arg0, ar -> { });
  }

  /**
   * Get the time to live for a key in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/ttl/">TTL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTtl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ttl(arg0, $handler);
    });
  }

  /**
   * Determine the type stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/type/">TYPE</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI type(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.type(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Determine the type stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/type/">TYPE</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI type(java.lang.String arg0) {
    return 
type(arg0, ar -> { });
  }

  /**
   * Determine the type stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/type/">TYPE</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxType(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      type(arg0, $handler);
    });
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * <p>
   * Redis command <a href="https://redis.io/commands/unlink/">UNLINK</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unlink(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.unlink(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * <p>
   * Redis command <a href="https://redis.io/commands/unlink/">UNLINK</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unlink(java.util.List<java.lang.String> args) {
    return 
unlink(args, ar -> { });
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * <p>
   * Redis command <a href="https://redis.io/commands/unlink/">UNLINK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxUnlink(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      unlink(args, $handler);
    });
  }

  /**
   * Stop listening for messages posted to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/unsubscribe/">UNSUBSCRIBE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unsubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.unsubscribe(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Stop listening for messages posted to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/unsubscribe/">UNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unsubscribe(java.util.List<java.lang.String> args) {
    return 
unsubscribe(args, ar -> { });
  }

  /**
   * Stop listening for messages posted to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/unsubscribe/">UNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxUnsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      unsubscribe(args, $handler);
    });
  }

  /**
   * Forget about all watched keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/unwatch/">UNWATCH</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unwatch(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.unwatch(io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Forget about all watched keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/unwatch/">UNWATCH</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unwatch() {
    return 
unwatch(ar -> { });
  }

  /**
   * Forget about all watched keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/unwatch/">UNWATCH</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxUnwatch() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      unwatch($handler);
    });
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/wait/">WAIT</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI wait(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.wait(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/wait/">WAIT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI wait(java.lang.String arg0, java.lang.String arg1) {
    return 
wait(arg0, arg1, ar -> { });
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/wait/">WAIT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxWait(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      wait(arg0, arg1, $handler);
    });
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block.
   * <p>
   * Redis command <a href="https://redis.io/commands/watch/">WATCH</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI watch(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.watch(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block.
   * <p>
   * Redis command <a href="https://redis.io/commands/watch/">WATCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI watch(java.util.List<java.lang.String> args) {
    return 
watch(args, ar -> { });
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block.
   * <p>
   * Redis command <a href="https://redis.io/commands/watch/">WATCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxWatch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      watch(args, $handler);
    });
  }

  /**
   * Marks a pending message as correctly processed, effectively removing it from the pending entries list of the consumer group. Return value of the command is the number of messages successfully acknowledged, that is, the IDs we were actually able to resolve in the PEL.
   * <p>
   * Redis command <a href="https://redis.io/commands/xack/">XACK</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xack(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xack(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Marks a pending message as correctly processed, effectively removing it from the pending entries list of the consumer group. Return value of the command is the number of messages successfully acknowledged, that is, the IDs we were actually able to resolve in the PEL.
   * <p>
   * Redis command <a href="https://redis.io/commands/xack/">XACK</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xack(java.util.List<java.lang.String> args) {
    return 
xack(args, ar -> { });
  }

  /**
   * Marks a pending message as correctly processed, effectively removing it from the pending entries list of the consumer group. Return value of the command is the number of messages successfully acknowledged, that is, the IDs we were actually able to resolve in the PEL.
   * <p>
   * Redis command <a href="https://redis.io/commands/xack/">XACK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXack(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xack(args, $handler);
    });
  }

  /**
   * Appends a new entry to a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xadd/">XADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Appends a new entry to a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xadd/">XADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xadd(java.util.List<java.lang.String> args) {
    return 
xadd(args, ar -> { });
  }

  /**
   * Appends a new entry to a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xadd/">XADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xadd(args, $handler);
    });
  }

  /**
   * Changes (or acquires) ownership of messages in a consumer group, as if the messages were delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xautoclaim/">XAUTOCLAIM</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xautoclaim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xautoclaim(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Changes (or acquires) ownership of messages in a consumer group, as if the messages were delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xautoclaim/">XAUTOCLAIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xautoclaim(java.util.List<java.lang.String> args) {
    return 
xautoclaim(args, ar -> { });
  }

  /**
   * Changes (or acquires) ownership of messages in a consumer group, as if the messages were delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xautoclaim/">XAUTOCLAIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXautoclaim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xautoclaim(args, $handler);
    });
  }

  /**
   * Changes (or acquires) ownership of a message in a consumer group, as if the message was delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xclaim/">XCLAIM</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xclaim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xclaim(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Changes (or acquires) ownership of a message in a consumer group, as if the message was delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xclaim/">XCLAIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xclaim(java.util.List<java.lang.String> args) {
    return 
xclaim(args, ar -> { });
  }

  /**
   * Changes (or acquires) ownership of a message in a consumer group, as if the message was delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xclaim/">XCLAIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXclaim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xclaim(args, $handler);
    });
  }

  /**
   * Removes the specified entries from the stream. Returns the number of items actually deleted, that may be different from the number of IDs passed in case certain IDs do not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/xdel/">XDEL</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xdel(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Removes the specified entries from the stream. Returns the number of items actually deleted, that may be different from the number of IDs passed in case certain IDs do not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/xdel/">XDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xdel(java.util.List<java.lang.String> args) {
    return 
xdel(args, ar -> { });
  }

  /**
   * Removes the specified entries from the stream. Returns the number of items actually deleted, that may be different from the number of IDs passed in case certain IDs do not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/xdel/">XDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xdel(args, $handler);
    });
  }

  /**
   * A container for consumer groups commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xgroup/">XGROUP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xgroup(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xgroup(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for consumer groups commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xgroup/">XGROUP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xgroup(java.util.List<java.lang.String> args) {
    return 
xgroup(args, ar -> { });
  }

  /**
   * A container for consumer groups commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xgroup/">XGROUP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xgroup(args, $handler);
    });
  }

  /**
   * A container for stream introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xinfo/">XINFO</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xinfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xinfo(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * A container for stream introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xinfo/">XINFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xinfo(java.util.List<java.lang.String> args) {
    return 
xinfo(args, ar -> { });
  }

  /**
   * A container for stream introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xinfo/">XINFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXinfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xinfo(args, $handler);
    });
  }

  /**
   * Return the number of entries in a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xlen/">XLEN</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xlen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xlen(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return the number of entries in a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xlen/">XLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xlen(java.lang.String arg0) {
    return 
xlen(arg0, ar -> { });
  }

  /**
   * Return the number of entries in a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xlen/">XLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xlen(arg0, $handler);
    });
  }

  /**
   * Return information and entries from a stream consumer group pending entries list, that are messages fetched but never acknowledged.
   * <p>
   * Redis command <a href="https://redis.io/commands/xpending/">XPENDING</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xpending(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xpending(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return information and entries from a stream consumer group pending entries list, that are messages fetched but never acknowledged.
   * <p>
   * Redis command <a href="https://redis.io/commands/xpending/">XPENDING</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xpending(java.util.List<java.lang.String> args) {
    return 
xpending(args, ar -> { });
  }

  /**
   * Return information and entries from a stream consumer group pending entries list, that are messages fetched but never acknowledged.
   * <p>
   * Redis command <a href="https://redis.io/commands/xpending/">XPENDING</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXpending(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xpending(args, $handler);
    });
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrange/">XRANGE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xrange(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrange/">XRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xrange(java.util.List<java.lang.String> args) {
    return 
xrange(args, ar -> { });
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrange/">XRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xrange(args, $handler);
    });
  }

  /**
   * Return never seen elements in multiple streams, with IDs greater than the ones reported by the caller for each stream. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xread/">XREAD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xread(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xread(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return never seen elements in multiple streams, with IDs greater than the ones reported by the caller for each stream. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xread/">XREAD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xread(java.util.List<java.lang.String> args) {
    return 
xread(args, ar -> { });
  }

  /**
   * Return never seen elements in multiple streams, with IDs greater than the ones reported by the caller for each stream. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xread/">XREAD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXread(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xread(args, $handler);
    });
  }

  /**
   * Return new entries from a stream using a consumer group, or access the history of the pending entries for a given consumer. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xreadgroup/">XREADGROUP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xreadgroup(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xreadgroup(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return new entries from a stream using a consumer group, or access the history of the pending entries for a given consumer. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xreadgroup/">XREADGROUP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xreadgroup(java.util.List<java.lang.String> args) {
    return 
xreadgroup(args, ar -> { });
  }

  /**
   * Return new entries from a stream using a consumer group, or access the history of the pending entries for a given consumer. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xreadgroup/">XREADGROUP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXreadgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xreadgroup(args, $handler);
    });
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval, in reverse order (from greater to smaller IDs) compared to XRANGE.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrevrange/">XREVRANGE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xrevrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xrevrange(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval, in reverse order (from greater to smaller IDs) compared to XRANGE.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrevrange/">XREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xrevrange(java.util.List<java.lang.String> args) {
    return 
xrevrange(args, ar -> { });
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval, in reverse order (from greater to smaller IDs) compared to XRANGE.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrevrange/">XREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xrevrange(args, $handler);
    });
  }

  /**
   * An internal command for replicating stream values.
   * <p>
   * Redis command <a href="https://redis.io/commands/xsetid/">XSETID</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xsetid(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xsetid(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * An internal command for replicating stream values.
   * <p>
   * Redis command <a href="https://redis.io/commands/xsetid/">XSETID</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xsetid(java.util.List<java.lang.String> args) {
    return 
xsetid(args, ar -> { });
  }

  /**
   * An internal command for replicating stream values.
   * <p>
   * Redis command <a href="https://redis.io/commands/xsetid/">XSETID</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXsetid(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xsetid(args, $handler);
    });
  }

  /**
   * Trims the stream to (approximately if &#x27;~&#x27; is passed) a certain size.
   * <p>
   * Redis command <a href="https://redis.io/commands/xtrim/">XTRIM</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xtrim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xtrim(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Trims the stream to (approximately if &#x27;~&#x27; is passed) a certain size.
   * <p>
   * Redis command <a href="https://redis.io/commands/xtrim/">XTRIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xtrim(java.util.List<java.lang.String> args) {
    return 
xtrim(args, ar -> { });
  }

  /**
   * Trims the stream to (approximately if &#x27;~&#x27; is passed) a certain size.
   * <p>
   * Redis command <a href="https://redis.io/commands/xtrim/">XTRIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXtrim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xtrim(args, $handler);
    });
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/zadd/">ZADD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zadd(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/zadd/">ZADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zadd(java.util.List<java.lang.String> args) {
    return 
zadd(args, ar -> { });
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/zadd/">ZADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zadd(args, $handler);
    });
  }

  /**
   * Get the number of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcard/">ZCARD</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zcard(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zcard(arg0, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the number of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcard/">ZCARD</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zcard(java.lang.String arg0) {
    return 
zcard(arg0, ar -> { });
  }

  /**
   * Get the number of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcard/">ZCARD</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZcard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zcard(arg0, $handler);
    });
  }

  /**
   * Count the members in a sorted set with scores within the given values.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcount/">ZCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zcount(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Count the members in a sorted set with scores within the given values.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcount/">ZCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zcount(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Count the members in a sorted set with scores within the given values.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcount/">ZCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zcount(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Subtract multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiff/">ZDIFF</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zdiff(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zdiff(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Subtract multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiff/">ZDIFF</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zdiff(java.util.List<java.lang.String> args) {
    return 
zdiff(args, ar -> { });
  }

  /**
   * Subtract multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiff/">ZDIFF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZdiff(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zdiff(args, $handler);
    });
  }

  /**
   * Subtract multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiffstore/">ZDIFFSTORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zdiffstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zdiffstore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Subtract multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiffstore/">ZDIFFSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zdiffstore(java.util.List<java.lang.String> args) {
    return 
zdiffstore(args, ar -> { });
  }

  /**
   * Subtract multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiffstore/">ZDIFFSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZdiffstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zdiffstore(args, $handler);
    });
  }

  /**
   * Increment the score of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zincrby/">ZINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zincrby(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Increment the score of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zincrby/">ZINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zincrby(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Increment the score of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zincrby/">ZINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zincrby(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Intersect multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinter/">ZINTER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zinter(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zinter(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Intersect multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinter/">ZINTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zinter(java.util.List<java.lang.String> args) {
    return 
zinter(args, ar -> { });
  }

  /**
   * Intersect multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinter/">ZINTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZinter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zinter(args, $handler);
    });
  }

  /**
   * Intersect multiple sorted sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/zintercard/">ZINTERCARD</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zintercard(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zintercard(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Intersect multiple sorted sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/zintercard/">ZINTERCARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zintercard(java.util.List<java.lang.String> args) {
    return 
zintercard(args, ar -> { });
  }

  /**
   * Intersect multiple sorted sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/zintercard/">ZINTERCARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZintercard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zintercard(args, $handler);
    });
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinterstore/">ZINTERSTORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zinterstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zinterstore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinterstore/">ZINTERSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zinterstore(java.util.List<java.lang.String> args) {
    return 
zinterstore(args, ar -> { });
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinterstore/">ZINTERSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zinterstore(args, $handler);
    });
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zlexcount/">ZLEXCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zlexcount(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zlexcount/">ZLEXCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zlexcount(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zlexcount/">ZLEXCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zlexcount(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Remove and return members with scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmpop/">ZMPOP</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zmpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zmpop(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove and return members with scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmpop/">ZMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zmpop(java.util.List<java.lang.String> args) {
    return 
zmpop(args, ar -> { });
  }

  /**
   * Remove and return members with scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmpop/">ZMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zmpop(args, $handler);
    });
  }

  /**
   * Get the score associated with the given members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmscore/">ZMSCORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zmscore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zmscore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the score associated with the given members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmscore/">ZMSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zmscore(java.util.List<java.lang.String> args) {
    return 
zmscore(args, ar -> { });
  }

  /**
   * Get the score associated with the given members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmscore/">ZMSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZmscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zmscore(args, $handler);
    });
  }

  /**
   * Remove and return members with the highest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmax/">ZPOPMAX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zpopmax(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zpopmax(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove and return members with the highest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmax/">ZPOPMAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zpopmax(java.util.List<java.lang.String> args) {
    return 
zpopmax(args, ar -> { });
  }

  /**
   * Remove and return members with the highest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmax/">ZPOPMAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zpopmax(args, $handler);
    });
  }

  /**
   * Remove and return members with the lowest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmin/">ZPOPMIN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zpopmin(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zpopmin(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove and return members with the lowest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmin/">ZPOPMIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zpopmin(java.util.List<java.lang.String> args) {
    return 
zpopmin(args, ar -> { });
  }

  /**
   * Remove and return members with the lowest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmin/">ZPOPMIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zpopmin(args, $handler);
    });
  }

  /**
   * Get one or multiple random elements from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrandmember/">ZRANDMEMBER</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrandmember(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrandmember(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get one or multiple random elements from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrandmember/">ZRANDMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrandmember(java.util.List<java.lang.String> args) {
    return 
zrandmember(args, ar -> { });
  }

  /**
   * Get one or multiple random elements from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrandmember/">ZRANDMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrandmember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrandmember(args, $handler);
    });
  }

  /**
   * Return a range of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrange/">ZRANGE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrange(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return a range of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrange/">ZRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrange(java.util.List<java.lang.String> args) {
    return 
zrange(args, ar -> { });
  }

  /**
   * Return a range of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrange/">ZRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrange(args, $handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebylex/">ZRANGEBYLEX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangebylex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrangebylex(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebylex/">ZRANGEBYLEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangebylex(java.util.List<java.lang.String> args) {
    return 
zrangebylex(args, ar -> { });
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebylex/">ZRANGEBYLEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrangebylex(args, $handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by score.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebyscore/">ZRANGEBYSCORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangebyscore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrangebyscore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return a range of members in a sorted set, by score.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebyscore/">ZRANGEBYSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangebyscore(java.util.List<java.lang.String> args) {
    return 
zrangebyscore(args, ar -> { });
  }

  /**
   * Return a range of members in a sorted set, by score.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebyscore/">ZRANGEBYSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrangebyscore(args, $handler);
    });
  }

  /**
   * Store a range of members from sorted set into another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangestore/">ZRANGESTORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangestore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrangestore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Store a range of members from sorted set into another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangestore/">ZRANGESTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangestore(java.util.List<java.lang.String> args) {
    return 
zrangestore(args, ar -> { });
  }

  /**
   * Store a range of members from sorted set into another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangestore/">ZRANGESTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrangestore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrangestore(args, $handler);
    });
  }

  /**
   * Determine the index of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrank/">ZRANK</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrank(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrank(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Determine the index of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrank/">ZRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrank(java.lang.String arg0, java.lang.String arg1) {
    return 
zrank(arg0, arg1, ar -> { });
  }

  /**
   * Determine the index of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrank/">ZRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrank(arg0, arg1, $handler);
    });
  }

  /**
   * Remove one or more members from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrem/">ZREM</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrem(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrem(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove one or more members from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrem/">ZREM</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrem(java.util.List<java.lang.String> args) {
    return 
zrem(args, ar -> { });
  }

  /**
   * Remove one or more members from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrem/">ZREM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrem(args, $handler);
    });
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebylex/">ZREMRANGEBYLEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zremrangebylex(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebylex/">ZREMRANGEBYLEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zremrangebylex(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebylex/">ZREMRANGEBYLEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zremrangebylex(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Remove all members in a sorted set within the given indexes.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyrank/">ZREMRANGEBYRANK</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zremrangebyrank(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove all members in a sorted set within the given indexes.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyrank/">ZREMRANGEBYRANK</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zremrangebyrank(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Remove all members in a sorted set within the given indexes.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyrank/">ZREMRANGEBYRANK</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zremrangebyrank(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Remove all members in a sorted set within the given scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyscore/">ZREMRANGEBYSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zremrangebyscore(arg0, arg1, arg2, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Remove all members in a sorted set within the given scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyscore/">ZREMRANGEBYSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zremrangebyscore(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Remove all members in a sorted set within the given scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyscore/">ZREMRANGEBYSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zremrangebyscore(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrange/">ZREVRANGE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrange(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrange/">ZREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrange(java.util.List<java.lang.String> args) {
    return 
zrevrange(args, ar -> { });
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrange/">ZREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrevrange(args, $handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range, ordered from higher to lower strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebylex/">ZREVRANGEBYLEX</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrangebylex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrangebylex(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range, ordered from higher to lower strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebylex/">ZREVRANGEBYLEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrangebylex(java.util.List<java.lang.String> args) {
    return 
zrevrangebylex(args, ar -> { });
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range, ordered from higher to lower strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebylex/">ZREVRANGEBYLEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrevrangebylex(args, $handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore/">ZREVRANGEBYSCORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrangebyscore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrangebyscore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore/">ZREVRANGEBYSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrangebyscore(java.util.List<java.lang.String> args) {
    return 
zrevrangebyscore(args, ar -> { });
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore/">ZREVRANGEBYSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrevrangebyscore(args, $handler);
    });
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrank/">ZREVRANK</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrank(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrank(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrank/">ZREVRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrank(java.lang.String arg0, java.lang.String arg1) {
    return 
zrevrank(arg0, arg1, ar -> { });
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrank/">ZREVRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrevrank(arg0, arg1, $handler);
    });
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscan/">ZSCAN</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zscan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zscan(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscan/">ZSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zscan(java.util.List<java.lang.String> args) {
    return 
zscan(args, ar -> { });
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscan/">ZSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zscan(args, $handler);
    });
  }

  /**
   * Get the score associated with the given member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscore/">ZSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zscore(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zscore(arg0, arg1, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Get the score associated with the given member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscore/">ZSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zscore(java.lang.String arg0, java.lang.String arg1) {
    return 
zscore(arg0, arg1, ar -> { });
  }

  /**
   * Get the score associated with the given member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscore/">ZSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZscore(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zscore(arg0, arg1, $handler);
    });
  }

  /**
   * Add multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunion/">ZUNION</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zunion(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zunion(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Add multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunion/">ZUNION</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zunion(java.util.List<java.lang.String> args) {
    return 
zunion(args, ar -> { });
  }

  /**
   * Add multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunion/">ZUNION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZunion(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zunion(args, $handler);
    });
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunionstore/">ZUNIONSTORE</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zunionstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zunionstore(args, io.vertx.lang.reactivex.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunionstore/">ZUNIONSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zunionstore(java.util.List<java.lang.String> args) {
    return 
zunionstore(args, ar -> { });
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunionstore/">ZUNIONSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zunionstore(args, $handler);
    });
  }

  public static io.vertx.reactivex.redis.client.RedisAPI api(io.vertx.reactivex.redis.client.Redis client) { 
    io.vertx.reactivex.redis.client.RedisAPI ret = io.vertx.reactivex.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(client.getDelegate()));
    return ret;
  }

  public static io.vertx.reactivex.redis.client.RedisAPI api(io.vertx.reactivex.redis.client.RedisConnection connection) { 
    io.vertx.reactivex.redis.client.RedisAPI ret = io.vertx.reactivex.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(connection.getDelegate()));
    return ret;
  }

  public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
    return arg != null ? new RedisAPI(arg) : null;
  }

}
