/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.authorization;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a wildcard permission (ie: 'manage:order:*' '*:orders', '*', etc.)
 * Note that it can optionally be assigned to a specific resource
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization.class)
public class WildcardPermissionBasedAuthorization extends io.vertx.reactivex.ext.auth.authorization.Authorization implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WildcardPermissionBasedAuthorization that = (WildcardPermissionBasedAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WildcardPermissionBasedAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new WildcardPermissionBasedAuthorization((io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization) obj),
    WildcardPermissionBasedAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization delegate;
  
  public WildcardPermissionBasedAuthorization(io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public WildcardPermissionBasedAuthorization(Object delegate) {
    super((io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization)delegate);
    this.delegate = (io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization)delegate;
  }

  @Override 
  public io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization getDelegate() {
    return delegate;
  }

  public static io.vertx.reactivex.ext.auth.authorization.WildcardPermissionBasedAuthorization create(java.lang.String permission) { 
    io.vertx.reactivex.ext.auth.authorization.WildcardPermissionBasedAuthorization ret = io.vertx.reactivex.ext.auth.authorization.WildcardPermissionBasedAuthorization.newInstance((io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization)io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization.create(permission));
    return ret;
  }

  /**
   * return the value of the wildcard permission
   * @return 
   */
  public java.lang.String getPermission() { 
    java.lang.String ret = delegate.getPermission();
    return ret;
  }

  /**
   * returns an optional resource that the permission is assigned-on
   * @return 
   */
  public java.lang.String getResource() { 
    java.lang.String ret = delegate.getResource();
    return ret;
  }

  /**
   * sets an optional resource that the permission is assigned-on
   * @param resource 
   * @return 
   */
  public io.vertx.reactivex.ext.auth.authorization.WildcardPermissionBasedAuthorization setResource(java.lang.String resource) { 
    delegate.setResource(resource);
    return this;
  }

  public static WildcardPermissionBasedAuthorization newInstance(io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization arg) {
    return arg != null ? new WildcardPermissionBasedAuthorization(arg) : null;
  }

}
