/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.authorization;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The AuthorizationContext contains properties that can be used to match
 * authorizations.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.AuthorizationContext original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.AuthorizationContext.class)
public class AuthorizationContext implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthorizationContext that = (AuthorizationContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AuthorizationContext> __TYPE_ARG = new TypeArg<>(    obj -> new AuthorizationContext((io.vertx.ext.auth.authorization.AuthorizationContext) obj),
    AuthorizationContext::getDelegate
  );

  private final io.vertx.ext.auth.authorization.AuthorizationContext delegate;
  
  public AuthorizationContext(io.vertx.ext.auth.authorization.AuthorizationContext delegate) {
    this.delegate = delegate;
  }

  public AuthorizationContext(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.AuthorizationContext)delegate;
  }

  @Override 
  public io.vertx.ext.auth.authorization.AuthorizationContext getDelegate() {
    return delegate;
  }

  /**
   * Factory for Authorization Context
   * @param user a user
   * @return a AuthorizationContext instance
   */
  public static io.vertx.reactivex.ext.auth.authorization.AuthorizationContext create(io.vertx.reactivex.ext.auth.User user) { 
    io.vertx.reactivex.ext.auth.authorization.AuthorizationContext ret = io.vertx.reactivex.ext.auth.authorization.AuthorizationContext.newInstance((io.vertx.ext.auth.authorization.AuthorizationContext)io.vertx.ext.auth.authorization.AuthorizationContext.create(user.getDelegate()));
    return ret;
  }

  /**
   * Get the authenticated user
   * @return the user
   */
  public io.vertx.reactivex.ext.auth.User user() { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.user());
    return ret;
  }

  /**
   * @return a Multimap containing variable names and values that can be resolved at runtime by {@link io.vertx.reactivex.ext.auth.authorization.Authorization}Authorizations
   */
  public io.vertx.reactivex.core.MultiMap variables() { 
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.variables());
    return ret;
  }

  public static AuthorizationContext newInstance(io.vertx.ext.auth.authorization.AuthorizationContext arg) {
    return arg != null ? new AuthorizationContext(arg) : null;
  }

}
