/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A secure non blocking random number generator isolated to the current context. The PRNG is bound to the vert.x
 * context and setup to close when the context shuts down.
 * <p>
 * When applicable, use of VertxContextPRNG rather than create new PRNG objects is helpful to keep the system entropy
 * usage to the minimum avoiding potential blocking across the application.
 * <p>
 * The use of VertxContextPRNG is particularly appropriate when multiple handlers use random numbers.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.VertxContextPRNG original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.VertxContextPRNG.class)
@Deprecated()
public class VertxContextPRNG extends io.vertx.reactivex.ext.auth.prng.VertxContextPRNG implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VertxContextPRNG that = (VertxContextPRNG) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<VertxContextPRNG> __TYPE_ARG = new TypeArg<>(    obj -> new VertxContextPRNG((io.vertx.ext.auth.VertxContextPRNG) obj),
    VertxContextPRNG::getDelegate
  );

  private final io.vertx.ext.auth.VertxContextPRNG delegate;
  
  public VertxContextPRNG(io.vertx.ext.auth.VertxContextPRNG delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public VertxContextPRNG(Object delegate) {
    super((io.vertx.ext.auth.VertxContextPRNG)delegate);
    this.delegate = (io.vertx.ext.auth.VertxContextPRNG)delegate;
  }

  @Override 
  public io.vertx.ext.auth.VertxContextPRNG getDelegate() {
    return delegate;
  }

  /**
   * Get or create a secure non blocking random number generator using the current vert.x context. If there is no
   * current context (i.e.: not running on the eventloop) then a {@link java.lang.IllegalStateException} is thrown.
   *
   * Note, if a context isn't allowed to be used, for example, exceptions are thrown on getting and putting data,
   * the VertxContextPRNG falls back to instantiate a new instance of the PRNG per call.
   * @return A secure non blocking random number generator.
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.auth.VertxContextPRNG current() { 
    io.vertx.reactivex.ext.auth.VertxContextPRNG ret = io.vertx.reactivex.ext.auth.VertxContextPRNG.newInstance((io.vertx.ext.auth.VertxContextPRNG)io.vertx.ext.auth.VertxContextPRNG.current());
    return ret;
  }

  /**
   * Get or create a secure non blocking random number generator using the current vert.x instance. Since the context
   * might be different this method will attempt to use the current context first if available and then fall back to
   * create a new instance of the PRNG.
   *
   * Note, if a context isn't allowed to be used, for example, exceptions are thrown on getting and putting data,
   * the VertxContextPRNG falls back to instantiate a new instance of the PRNG per call.
   * @param vertx a Vert.x instance.
   * @return A secure non blocking random number generator.
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.auth.VertxContextPRNG current(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.auth.VertxContextPRNG ret = io.vertx.reactivex.ext.auth.VertxContextPRNG.newInstance((io.vertx.ext.auth.VertxContextPRNG)io.vertx.ext.auth.VertxContextPRNG.current(vertx.getDelegate()));
    return ret;
  }

  public static VertxContextPRNG newInstance(io.vertx.ext.auth.VertxContextPRNG arg) {
    return arg != null ? new VertxContextPRNG(arg) : null;
  }

}
