/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.mongo;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x service used to interact with MongoDB server instances.
 * <p>
 * Some of the operations might change <i>_id</i> field of passed  document.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mongo.MongoClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.mongo.MongoClient.class)
public class MongoClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoClient that = (MongoClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoClient> __TYPE_ARG = new TypeArg<>(    obj -> new MongoClient((io.vertx.ext.mongo.MongoClient) obj),
    MongoClient::getDelegate
  );

  private final io.vertx.ext.mongo.MongoClient delegate;
  
  public MongoClient(io.vertx.ext.mongo.MongoClient delegate) {
    this.delegate = delegate;
  }

  public MongoClient(Object delegate) {
    this.delegate = (io.vertx.ext.mongo.MongoClient)delegate;
  }

  @Override 
  public io.vertx.ext.mongo.MongoClient getDelegate() {
    return delegate;
  }


  /**
   * Create a Mongo client which maintains its own data source.
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.reactivex.ext.mongo.MongoClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject config) { 
    io.vertx.reactivex.ext.mongo.MongoClient ret = io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a Mongo client which shares its data source with any other Mongo clients created with the same
   * data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param dataSourceName the data source name
   * @return the client
   */
  public static io.vertx.reactivex.ext.mongo.MongoClient createShared(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject config, java.lang.String dataSourceName) { 
    io.vertx.reactivex.ext.mongo.MongoClient ret = io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.createShared(vertx.getDelegate(), config, dataSourceName));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.mongo.MongoClient#createShared} but with the default data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.reactivex.ext.mongo.MongoClient createShared(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject config) { 
    io.vertx.reactivex.ext.mongo.MongoClient ret = io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Save a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient save(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.save(collection, document, resultHandler);
    return this;
  }

  /**
   * Save a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient save(java.lang.String collection, io.vertx.core.json.JsonObject document) {
    return 
save(collection, document, ar -> { });
  }

  /**
   * Save a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return 
   */
  public io.reactivex.Maybe<java.lang.String> rxSave(java.lang.String collection, io.vertx.core.json.JsonObject document) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      save(collection, document, $handler);
    });
  }

  /**
   * Save a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient saveWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.saveWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  /**
   * Save a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient saveWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) {
    return 
saveWithOptions(collection, document, writeOption, ar -> { });
  }

  /**
   * Save a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return 
   */
  public io.reactivex.Maybe<java.lang.String> rxSaveWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      saveWithOptions(collection, document, writeOption, $handler);
    });
  }

  /**
   * Insert a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient insert(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.insert(collection, document, resultHandler);
    return this;
  }

  /**
   * Insert a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient insert(java.lang.String collection, io.vertx.core.json.JsonObject document) {
    return 
insert(collection, document, ar -> { });
  }

  /**
   * Insert a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return 
   */
  public io.reactivex.Maybe<java.lang.String> rxInsert(java.lang.String collection, io.vertx.core.json.JsonObject document) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      insert(collection, document, $handler);
    });
  }

  /**
   * Insert a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient insertWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.insertWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  /**
   * Insert a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient insertWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) {
    return 
insertWithOptions(collection, document, writeOption, ar -> { });
  }

  /**
   * Insert a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return 
   */
  public io.reactivex.Maybe<java.lang.String> rxInsertWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      insertWithOptions(collection, document, writeOption, $handler);
    });
  }

  /**
   * Update matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient updateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollection(collection, query, update, resultHandler);
    return this;
  }

  /**
   * Update matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient updateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) {
    return 
updateCollection(collection, query, update, ar -> { });
  }

  /**
   * Update matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      updateCollection(collection, query, update, $handler);
    });
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient updateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollection(collection, query, update, resultHandler);
    return this;
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient updateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update) {
    return 
updateCollection(collection, query, update, ar -> { });
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      updateCollection(collection, query, update, $handler);
    });
  }

  /**
   * Update matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient updateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.UpdateOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  /**
   * Update matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient updateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.UpdateOptions options) {
    return 
updateCollectionWithOptions(collection, query, update, options, ar -> { });
  }

  /**
   * Update matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.UpdateOptions options) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      updateCollectionWithOptions(collection, query, update, options, $handler);
    });
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update aggregation pipeline used to describe how documents will be updated
   * @param options options to configure the update
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient updateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update, io.vertx.ext.mongo.UpdateOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update aggregation pipeline used to describe how documents will be updated
   * @param options options to configure the update
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient updateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update, io.vertx.ext.mongo.UpdateOptions options) {
    return 
updateCollectionWithOptions(collection, query, update, options, ar -> { });
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update aggregation pipeline used to describe how documents will be updated
   * @param options options to configure the update
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update, io.vertx.ext.mongo.UpdateOptions options) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      updateCollectionWithOptions(collection, query, update, options, $handler);
    });
  }

  /**
   * Replace matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient replaceDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocuments(collection, query, replace, resultHandler);
    return this;
  }

  /**
   * Replace matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient replaceDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) {
    return 
replaceDocuments(collection, query, replace, ar -> { });
  }

  /**
   * Replace matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxReplaceDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      replaceDocuments(collection, query, replace, $handler);
    });
  }

  /**
   * Replace matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient replaceDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.UpdateOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler);
    return this;
  }

  /**
   * Replace matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient replaceDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.UpdateOptions options) {
    return 
replaceDocumentsWithOptions(collection, query, replace, options, ar -> { });
  }

  /**
   * Replace matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxReplaceDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.UpdateOptions options) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      replaceDocumentsWithOptions(collection, query, replace, options, $handler);
    });
  }

  /**
   * Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientBulkWriteResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient bulkWrite(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWrite(collection, operations, resultHandler);
    return this;
  }

  /**
   * Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient bulkWrite(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations) {
    return 
bulkWrite(collection, operations, ar -> { });
  }

  /**
   * Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientBulkWriteResult> rxBulkWrite(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bulkWrite(collection, operations, $handler);
    });
  }

  /**
   * Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
   * documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientBulkWriteResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient bulkWriteWithOptions(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler);
    return this;
  }

  /**
   * Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
   * documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient bulkWriteWithOptions(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions) {
    return 
bulkWriteWithOptions(collection, operations, bulkWriteOptions, ar -> { });
  }

  /**
   * Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
   * documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientBulkWriteResult> rxBulkWriteWithOptions(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bulkWriteWithOptions(collection, operations, bulkWriteOptions, $handler);
    });
  }

  /**
   * Find matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match documents
   * @param resultHandler will be provided with list of documents
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient find(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonObject>>> resultHandler) { 
    delegate.find(collection, query, resultHandler);
    return this;
  }

  /**
   * Find matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient find(java.lang.String collection, io.vertx.core.json.JsonObject query) {
    return 
find(collection, query, ar -> { });
  }

  /**
   * Find matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public io.reactivex.Single<java.util.List<io.vertx.core.json.JsonObject>> rxFind(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return AsyncResultSingle.toSingle($handler -> {
      find(collection, query, $handler);
    });
  }

  /**
   * Find matching documents in the specified collection.
   * This method use batchCursor for returning each found document.
   * @param collection the collection
   * @param query query used to match documents
   * @return a  emitting found documents
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> findBatch(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.findBatch(collection, query), TypeArg.unknown());
    return ret;
  }

  /**
   * Find matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @param resultHandler will be provided with list of documents
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonObject>>> resultHandler) { 
    delegate.findWithOptions(collection, query, options, resultHandler);
    return this;
  }

  /**
   * Find matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions options) {
    return 
findWithOptions(collection, query, options, ar -> { });
  }

  /**
   * Find matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return 
   */
  public io.reactivex.Single<java.util.List<io.vertx.core.json.JsonObject>> rxFindWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      findWithOptions(collection, query, options, $handler);
    });
  }

  /**
   * Find matching documents in the specified collection, specifying options.
   * This method use batchCursor for returning each found document.
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return a  emitting found documents
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> findBatchWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.findBatchWithOptions(collection, query, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Find a single matching document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOne(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject fields, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOne(collection, query, fields, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOne(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject fields) {
    return 
findOne(collection, query, fields, ar -> { });
  }

  /**
   * Find a single matching document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOne(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject fields) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      findOne(collection, query, fields, $handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndUpdate(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndUpdate(collection, query, update, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndUpdate(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) {
    return 
findOneAndUpdate(collection, query, update, ar -> { });
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndUpdate(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      findOneAndUpdate(collection, query, update, $handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndUpdateWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndUpdateWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) {
    return 
findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, ar -> { });
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndUpdateWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, $handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndReplace(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndReplace(collection, query, replace, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndReplace(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) {
    return 
findOneAndReplace(collection, query, replace, ar -> { });
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndReplace(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      findOneAndReplace(collection, query, replace, $handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndReplaceWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndReplaceWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) {
    return 
findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, ar -> { });
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndReplaceWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, $handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param resultHandler will be provided with the deleted document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndDelete(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndDelete(collection, query, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndDelete(java.lang.String collection, io.vertx.core.json.JsonObject query) {
    return 
findOneAndDelete(collection, query, ar -> { });
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndDelete(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      findOneAndDelete(collection, query, $handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @param resultHandler will be provided with the deleted document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndDeleteWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndDeleteWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions findOptions) {
    return 
findOneAndDeleteWithOptions(collection, query, findOptions, ar -> { });
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndDeleteWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions findOptions) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      findOneAndDeleteWithOptions(collection, query, findOptions, $handler);
    });
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @param resultHandler will be provided with the number of matching documents
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient count(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.count(collection, query, resultHandler);
    return this;
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient count(java.lang.String collection, io.vertx.core.json.JsonObject query) {
    return 
count(collection, query, ar -> { });
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxCount(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return AsyncResultSingle.toSingle($handler -> {
      count(collection, query, $handler);
    });
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @param countOptions 
   * @param resultHandler will be provided with the number of matching documents
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient countWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.CountOptions countOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.countWithOptions(collection, query, countOptions, resultHandler);
    return this;
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @param countOptions 
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient countWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.CountOptions countOptions) {
    return 
countWithOptions(collection, query, countOptions, ar -> { });
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @param countOptions 
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxCountWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.CountOptions countOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      countWithOptions(collection, query, countOptions, $handler);
    });
  }

  /**
   * Remove matching documents from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocuments(collection, query, resultHandler);
    return this;
  }

  /**
   * Remove matching documents from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query) {
    return 
removeDocuments(collection, query, ar -> { });
  }

  /**
   * Remove matching documents from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      removeDocuments(collection, query, $handler);
    });
  }

  /**
   * Remove matching documents from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentsWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  /**
   * Remove matching documents from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) {
    return 
removeDocumentsWithOptions(collection, query, writeOption, ar -> { });
  }

  /**
   * Remove matching documents from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      removeDocumentsWithOptions(collection, query, writeOption, $handler);
    });
  }

  /**
   * Remove a single matching document from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocument(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocument(collection, query, resultHandler);
    return this;
  }

  /**
   * Remove a single matching document from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocument(java.lang.String collection, io.vertx.core.json.JsonObject query) {
    return 
removeDocument(collection, query, ar -> { });
  }

  /**
   * Remove a single matching document from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocument(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      removeDocument(collection, query, $handler);
    });
  }

  /**
   * Remove a single matching document from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocumentWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  /**
   * Remove a single matching document from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocumentWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) {
    return 
removeDocumentWithOptions(collection, query, writeOption, ar -> { });
  }

  /**
   * Remove a single matching document from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocumentWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      removeDocumentWithOptions(collection, query, writeOption, $handler);
    });
  }

  /**
   * Create a new collection
   * @param collectionName the name of the collection
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createCollection(java.lang.String collectionName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createCollection(collectionName, resultHandler);
    return this;
  }

  /**
   * Create a new collection
   * @param collectionName the name of the collection
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createCollection(java.lang.String collectionName) {
    return 
createCollection(collectionName, ar -> { });
  }

  /**
   * Create a new collection
   * @param collectionName the name of the collection
   * @return 
   */
  public io.reactivex.Completable rxCreateCollection(java.lang.String collectionName) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createCollection(collectionName, $handler);
    });
  }

  /**
   * Create a new collection with options
   * @param collectionName the name of the collection
   * @param collectionOptions options of the collection
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createCollectionWithOptions(java.lang.String collectionName, io.vertx.ext.mongo.CreateCollectionOptions collectionOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createCollectionWithOptions(collectionName, collectionOptions, resultHandler);
    return this;
  }

  /**
   * Create a new collection with options
   * @param collectionName the name of the collection
   * @param collectionOptions options of the collection
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createCollectionWithOptions(java.lang.String collectionName, io.vertx.ext.mongo.CreateCollectionOptions collectionOptions) {
    return 
createCollectionWithOptions(collectionName, collectionOptions, ar -> { });
  }

  /**
   * Create a new collection with options
   * @param collectionName the name of the collection
   * @param collectionOptions options of the collection
   * @return 
   */
  public io.reactivex.Completable rxCreateCollectionWithOptions(java.lang.String collectionName, io.vertx.ext.mongo.CreateCollectionOptions collectionOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createCollectionWithOptions(collectionName, collectionOptions, $handler);
    });
  }

  /**
   * Get a list of all collections in the database.
   * @param resultHandler will be called with a list of collections.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient getCollections(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> resultHandler) { 
    delegate.getCollections(resultHandler);
    return this;
  }

  /**
   * Get a list of all collections in the database.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient getCollections() {
    return 
getCollections(ar -> { });
  }

  /**
   * Get a list of all collections in the database.
   * @return 
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxGetCollections() { 
    return AsyncResultSingle.toSingle($handler -> {
      getCollections($handler);
    });
  }

  /**
   * Drop a collection
   * @param collection the collection
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient dropCollection(java.lang.String collection, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.dropCollection(collection, resultHandler);
    return this;
  }

  /**
   * Drop a collection
   * @param collection the collection
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient dropCollection(java.lang.String collection) {
    return 
dropCollection(collection, ar -> { });
  }

  /**
   * Drop a collection
   * @param collection the collection
   * @return 
   */
  public io.reactivex.Completable rxDropCollection(java.lang.String collection) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      dropCollection(collection, $handler);
    });
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createIndex(java.lang.String collection, io.vertx.core.json.JsonObject key, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createIndex(collection, key, resultHandler);
    return this;
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createIndex(java.lang.String collection, io.vertx.core.json.JsonObject key) {
    return 
createIndex(collection, key, ar -> { });
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return 
   */
  public io.reactivex.Completable rxCreateIndex(java.lang.String collection, io.vertx.core.json.JsonObject key) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createIndex(collection, key, $handler);
    });
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createIndexWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject key, io.vertx.ext.mongo.IndexOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createIndexWithOptions(collection, key, options, resultHandler);
    return this;
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createIndexWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject key, io.vertx.ext.mongo.IndexOptions options) {
    return 
createIndexWithOptions(collection, key, options, ar -> { });
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @return 
   */
  public io.reactivex.Completable rxCreateIndexWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject key, io.vertx.ext.mongo.IndexOptions options) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createIndexWithOptions(collection, key, options, $handler);
    });
  }

  /**
   * creates an indexes
   * @param collection the collection
   * @param indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createIndexes(java.lang.String collection, java.util.List<io.vertx.ext.mongo.IndexModel> indexes, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createIndexes(collection, indexes, resultHandler);
    return this;
  }

  /**
   * creates an indexes
   * @param collection the collection
   * @param indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createIndexes(java.lang.String collection, java.util.List<io.vertx.ext.mongo.IndexModel> indexes) {
    return 
createIndexes(collection, indexes, ar -> { });
  }

  /**
   * creates an indexes
   * @param collection the collection
   * @param indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return 
   */
  public io.reactivex.Completable rxCreateIndexes(java.lang.String collection, java.util.List<io.vertx.ext.mongo.IndexModel> indexes) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createIndexes(collection, indexes, $handler);
    });
  }

  /**
   * Get all the indexes in this collection.
   * @param collection the collection
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient listIndexes(java.lang.String collection, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> resultHandler) { 
    delegate.listIndexes(collection, resultHandler);
    return this;
  }

  /**
   * Get all the indexes in this collection.
   * @param collection the collection
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient listIndexes(java.lang.String collection) {
    return 
listIndexes(collection, ar -> { });
  }

  /**
   * Get all the indexes in this collection.
   * @param collection the collection
   * @return 
   */
  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxListIndexes(java.lang.String collection) { 
    return AsyncResultSingle.toSingle($handler -> {
      listIndexes(collection, $handler);
    });
  }

  /**
   * Drops the index given its name.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient dropIndex(java.lang.String collection, java.lang.String indexName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.dropIndex(collection, indexName, resultHandler);
    return this;
  }

  /**
   * Drops the index given its name.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient dropIndex(java.lang.String collection, java.lang.String indexName) {
    return 
dropIndex(collection, indexName, ar -> { });
  }

  /**
   * Drops the index given its name.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @return 
   */
  public io.reactivex.Completable rxDropIndex(java.lang.String collection, java.lang.String indexName) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      dropIndex(collection, indexName, $handler);
    });
  }

  /**
   * Run an arbitrary MongoDB command.
   * @param commandName the name of the command
   * @param command the command
   * @param resultHandler will be called with the result.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient runCommand(java.lang.String commandName, io.vertx.core.json.JsonObject command, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.runCommand(commandName, command, resultHandler);
    return this;
  }

  /**
   * Run an arbitrary MongoDB command.
   * @param commandName the name of the command
   * @param command the command
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient runCommand(java.lang.String commandName, io.vertx.core.json.JsonObject command) {
    return 
runCommand(commandName, command, ar -> { });
  }

  /**
   * Run an arbitrary MongoDB command.
   * @param commandName the name of the command
   * @param command the command
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxRunCommand(java.lang.String commandName, io.vertx.core.json.JsonObject command) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      runCommand(commandName, command, $handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param resultHandler will be provided with array of values.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient distinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> resultHandler) { 
    delegate.distinct(collection, fieldName, resultClassname, resultHandler);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient distinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname) {
    return 
distinct(collection, fieldName, resultClassname, ar -> { });
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return 
   */
  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxDistinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname) { 
    return AsyncResultSingle.toSingle($handler -> {
      distinct(collection, fieldName, resultClassname, $handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @param resultHandler will be provided with array of values.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient distinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> resultHandler) { 
    delegate.distinct(collection, fieldName, resultClassname, distinctOptions, resultHandler);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient distinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) {
    return 
distinct(collection, fieldName, resultClassname, distinctOptions, ar -> { });
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return 
   */
  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxDistinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      distinct(collection, fieldName, resultClassname, distinctOptions, $handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param resultHandler will be provided with array of values.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient distinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> resultHandler) { 
    delegate.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient distinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query) {
    return 
distinctWithQuery(collection, fieldName, resultClassname, query, ar -> { });
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return 
   */
  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxDistinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query) { 
    return AsyncResultSingle.toSingle($handler -> {
      distinctWithQuery(collection, fieldName, resultClassname, query, $handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @param resultHandler will be provided with array of values.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient distinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> resultHandler) { 
    delegate.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, resultHandler);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient distinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) {
    return 
distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, ar -> { });
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return 
   */
  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxDistinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, $handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatch(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatch(collection, fieldName, resultClassname), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatch(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatch(collection, fieldName, resultClassname, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param batchSize the number of documents to load in a batch
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, int batchSize) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param batchSize the number of documents to load in a batch
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, int batchSize, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * Run aggregate MongoDB command with default {@link io.vertx.ext.mongo.AggregateOptions}.
   * @param collection the collection
   * @param pipeline aggregation pipeline to be executed
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> aggregate(java.lang.String collection, io.vertx.core.json.JsonArray pipeline) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.aggregate(collection, pipeline), TypeArg.unknown());
    return ret;
  }

  /**
   * Run aggregate MongoDB command.
   * @param collection the collection
   * @param pipeline aggregation pipeline to be executed
   * @param options options to configure the aggregation command
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> aggregateWithOptions(java.lang.String collection, io.vertx.core.json.JsonArray pipeline, io.vertx.ext.mongo.AggregateOptions options) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.aggregateWithOptions(collection, pipeline, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Creates a {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @param resultHandler the {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} to interact with the bucket named bucketName
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createDefaultGridFsBucketService(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.mongo.MongoGridFsClient>> resultHandler) { 
    delegate.createDefaultGridFsBucketService(io.vertx.lang.reactivex.Helper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.reactivex.ext.mongo.MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)event))));
    return this;
  }

  /**
   * Creates a {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createDefaultGridFsBucketService() {
    return 
createDefaultGridFsBucketService(ar -> { });
  }

  /**
   * Creates a {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.mongo.MongoGridFsClient> rxCreateDefaultGridFsBucketService() { 
    return AsyncResultSingle.toSingle($handler -> {
      createDefaultGridFsBucketService($handler);
    });
  }

  /**
   * Creates a {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @param bucketName the name of the GridFS bucket
   * @param resultHandler the {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} to interact with the bucket named bucketName
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createGridFsBucketService(java.lang.String bucketName, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.mongo.MongoGridFsClient>> resultHandler) { 
    delegate.createGridFsBucketService(bucketName, io.vertx.lang.reactivex.Helper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.reactivex.ext.mongo.MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)event))));
    return this;
  }

  /**
   * Creates a {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @param bucketName the name of the GridFS bucket
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createGridFsBucketService(java.lang.String bucketName) {
    return 
createGridFsBucketService(bucketName, ar -> { });
  }

  /**
   * Creates a {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @param bucketName the name of the GridFS bucket
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.mongo.MongoGridFsClient> rxCreateGridFsBucketService(java.lang.String bucketName) { 
    return AsyncResultSingle.toSingle($handler -> {
      createGridFsBucketService(bucketName, $handler);
    });
  }

  /**
   * Close the client and release its resources
   * @param handler 
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the client and release its resources
   */
  public void close() {
    close(ar -> { });
  }

  /**
   * Close the client and release its resources
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  /**
   * Watch the collection change.
   * @param collection the collection
   * @param pipeline watching pipeline to be executed
   * @param withUpdatedDoc whether to get updated fullDocument for "update" operation
   * @param batchSize the number of documents to load in a batch
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<com.mongodb.client.model.changestream.ChangeStreamDocument<io.vertx.core.json.JsonObject>> watch(java.lang.String collection, io.vertx.core.json.JsonArray pipeline, boolean withUpdatedDoc, int batchSize) { 
    io.vertx.reactivex.core.streams.ReadStream<com.mongodb.client.model.changestream.ChangeStreamDocument<io.vertx.core.json.JsonObject>> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.watch(collection, pipeline, withUpdatedDoc, batchSize), TypeArg.unknown());
    return ret;
  }

  /**
   * The name of the default pool
   */
  public static final java.lang.String DEFAULT_POOL_NAME = io.vertx.ext.mongo.MongoClient.DEFAULT_POOL_NAME;
  /**
   * The name of the default database
   */
  public static final java.lang.String DEFAULT_DB_NAME = io.vertx.ext.mongo.MongoClient.DEFAULT_DB_NAME;
  public static MongoClient newInstance(io.vertx.ext.mongo.MongoClient arg) {
    return arg != null ? new MongoClient(arg) : null;
  }

}
