/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Builder for {@link io.vertx.reactivex.sqlclient.SqlClient} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.ClientBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.ClientBuilder.class)
public class ClientBuilder<C> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClientBuilder that = (ClientBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ClientBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new ClientBuilder((io.vertx.sqlclient.ClientBuilder) obj),
    ClientBuilder::getDelegate
  );

  private final io.vertx.sqlclient.ClientBuilder<C> delegate;
  public final TypeArg<C> __typeArg_0;
  
  public ClientBuilder(io.vertx.sqlclient.ClientBuilder delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public ClientBuilder(Object delegate, TypeArg<C> typeArg_0) {
    this.delegate = (io.vertx.sqlclient.ClientBuilder)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  @Override 
  public io.vertx.sqlclient.ClientBuilder getDelegate() {
    return delegate;
  }


  /**
   * Configure the client with the given pool <code>options</code>
   * @param options the pool options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.ClientBuilder<C> with(io.vertx.sqlclient.PoolOptions options) { 
    delegate.with(options);
    return this;
  }

  /**
   * Configure the <code>database</code> the client should connect to. The target <code>database</code> is specified as
   * a {@link io.vertx.sqlclient.SqlConnectOptions} coordinates.
   * @param database the database coordinates
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.ClientBuilder<C> connectingTo(io.vertx.sqlclient.SqlConnectOptions database) { 
    delegate.connectingTo(database);
    return this;
  }

  /**
   * Configure the <code>database</code> the client should connect to. The target <code>database</code> is specified as
   * a {@link io.vertx.sqlclient.SqlConnectOptions} coordinates.
   * @param database the database URI
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.ClientBuilder<C> connectingTo(java.lang.String database) { 
    delegate.connectingTo(database);
    return this;
  }

  /**
   * Configure the <code>database</code> the client should connect to. When the client needs to connect to the database,
   * it gets a database configuration from the list of  <code>databases</code> using a round-robin policy.
   * @param databases the list of database coordinates
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.ClientBuilder<C> connectingTo(java.util.List<io.vertx.sqlclient.SqlConnectOptions> databases) { 
    delegate.connectingTo(databases);
    return this;
  }

  /**
   * Sets the vertx instance to use.
   * @param vertx the vertx instance
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.ClientBuilder<C> using(io.vertx.reactivex.core.Vertx vertx) { 
    delegate.using(vertx.getDelegate());
    return this;
  }

  /**
   * Set a handler called when the pool has established a connection to the database.
   *
   * <p> This handler allows interactions with the database before the connection is added to the pool.
   *
   * <p> When the handler has finished, it must call {@link io.vertx.reactivex.sqlclient.SqlClient#close} to release the connection
   * to the pool.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.ClientBuilder<C> withConnectHandler(io.vertx.core.Handler<io.vertx.reactivex.sqlclient.SqlConnection> handler) { 
    delegate.withConnectHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  /**
   * Build and return the client.
   * @return the client
   */
  public C build() { 
    C ret = (C)__typeArg_0.wrap(delegate.build());
    return ret;
  }

  /**
   * Configure the <code>database</code> the client should connect to. When the client needs to connect to the database,
   * it gets fresh database configuration from the database <code>supplier</code>.
   * @param supplier the supplier of database coordinates
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.ClientBuilder<C> connectingTo(java.util.function.Supplier<io.vertx.core.Future<io.vertx.sqlclient.SqlConnectOptions>> supplier) { 
    delegate.connectingTo(supplier);
    return this;
  }

  public static <C> ClientBuilder<C> newInstance(io.vertx.sqlclient.ClientBuilder arg) {
    return arg != null ? new ClientBuilder<C>(arg) : null;
  }

  public static <C> ClientBuilder<C> newInstance(io.vertx.sqlclient.ClientBuilder arg, TypeArg<C> __typeArg_C) {
    return arg != null ? new ClientBuilder<C>(arg, __typeArg_C) : null;
  }

}
