/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mssqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A  of {@link io.vertx.reactivex.mssqlclient.MSSQLConnection SQL Server connections}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mssqlclient.MSSQLPool original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mssqlclient.MSSQLPool.class)
@Deprecated()
public class MSSQLPool extends io.vertx.reactivex.sqlclient.Pool implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MSSQLPool that = (MSSQLPool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MSSQLPool> __TYPE_ARG = new TypeArg<>(    obj -> new MSSQLPool((io.vertx.mssqlclient.MSSQLPool) obj),
    MSSQLPool::getDelegate
  );

  private final io.vertx.mssqlclient.MSSQLPool delegate;
  
  public MSSQLPool(io.vertx.mssqlclient.MSSQLPool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MSSQLPool(Object delegate) {
    super((io.vertx.mssqlclient.MSSQLPool)delegate);
    this.delegate = (io.vertx.mssqlclient.MSSQLPool)delegate;
  }

  @Override 
  public io.vertx.mssqlclient.MSSQLPool getDelegate() {
    return delegate;
  }

  /**
   * Like {@link io.vertx.reactivex.mssqlclient.MSSQLPool#pool} with default options.
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.reactivex.mssqlclient.MSSQLPool pool(java.lang.String connectionUri) { 
    io.vertx.reactivex.mssqlclient.MSSQLPool ret = io.vertx.reactivex.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mssqlclient.MSSQLPool#pool} with <code>database</code> built from <code>connectionUri</code>.
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.reactivex.mssqlclient.MSSQLPool pool(java.lang.String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.reactivex.mssqlclient.MSSQLPool ret = io.vertx.reactivex.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(connectionUri, options));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mssqlclient.MSSQLPool#pool} with default options.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.reactivex.mssqlclient.MSSQLPool pool(io.vertx.reactivex.core.Vertx vertx, java.lang.String connectionUri) { 
    io.vertx.reactivex.mssqlclient.MSSQLPool ret = io.vertx.reactivex.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mssqlclient.MSSQLPool#pool} with <code>database</code> built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.reactivex.mssqlclient.MSSQLPool pool(io.vertx.reactivex.core.Vertx vertx, java.lang.String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.reactivex.mssqlclient.MSSQLPool ret = io.vertx.reactivex.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(vertx.getDelegate(), connectionUri, options));
    return ret;
  }

  /**
   * Create a connection pool to the SQL server <code>database</code> configured with the given <code>options</code>.
   * @param database the options for the connection
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.reactivex.mssqlclient.MSSQLPool pool(io.vertx.mssqlclient.MSSQLConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.reactivex.mssqlclient.MSSQLPool ret = io.vertx.reactivex.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(database, options));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mssqlclient.MSSQLPool#pool} with a specific  instance.
   * @param vertx 
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.reactivex.mssqlclient.MSSQLPool pool(io.vertx.reactivex.core.Vertx vertx, io.vertx.mssqlclient.MSSQLConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.reactivex.mssqlclient.MSSQLPool ret = io.vertx.reactivex.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * Create a connection pool to the SQL Server <code>databases</code> with round-robin selection.
   * Round-robin is applied when a new connection is created by the pool.
   * @param databases the list of databases
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.reactivex.mssqlclient.MSSQLPool pool(java.util.List<io.vertx.mssqlclient.MSSQLConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.reactivex.mssqlclient.MSSQLPool ret = io.vertx.reactivex.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(databases, options));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mssqlclient.MSSQLPool#pool} with a specific  instance.
   * @param vertx 
   * @param databases 
   * @param options 
   * @return 
   */
  public static io.vertx.reactivex.mssqlclient.MSSQLPool pool(io.vertx.reactivex.core.Vertx vertx, java.util.List<io.vertx.mssqlclient.MSSQLConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.reactivex.mssqlclient.MSSQLPool ret = io.vertx.reactivex.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(vertx.getDelegate(), databases, options));
    return ret;
  }

  public io.vertx.reactivex.mssqlclient.MSSQLPool connectHandler(io.vertx.core.Handler<io.vertx.reactivex.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  public io.vertx.reactivex.mssqlclient.MSSQLPool connectionProvider(java.util.function.Function<io.vertx.reactivex.core.Context,io.vertx.core.Future<io.vertx.reactivex.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
        io.vertx.core.Future<io.vertx.reactivex.sqlclient.SqlConnection> ret = provider.apply(io.vertx.reactivex.core.Context.newInstance((io.vertx.core.Context)arg));
        return ret.map(val -> val.getDelegate());
      }
    });
    return this;
  }

  public io.vertx.reactivex.mssqlclient.MSSQLPool connectionProvider(io.reactivex.functions.Function<io.vertx.reactivex.core.Context,io.reactivex.Single<io.vertx.reactivex.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
        io.reactivex.Single<io.vertx.reactivex.sqlclient.SqlConnection> ret;
        try {
          ret = provider.apply(io.vertx.reactivex.core.Context.newInstance((io.vertx.core.Context)arg));
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj.getDelegate());
      }
    });
    return this;
  }

  /**
   * Create a connection pool to the SQL Server <code>databases</code>. The supplier is called
   * to provide the options when a new connection is created by the pool.
   * @param databases the databases supplier
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.reactivex.mssqlclient.MSSQLPool pool(java.util.function.Supplier<io.vertx.core.Future<io.vertx.mssqlclient.MSSQLConnectOptions>> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.reactivex.mssqlclient.MSSQLPool ret = io.vertx.reactivex.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(databases, options));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mssqlclient.MSSQLPool#pool} with a specific  instance.
   * @param vertx 
   * @param databases 
   * @param options 
   * @return 
   */
  public static io.vertx.reactivex.mssqlclient.MSSQLPool pool(io.vertx.reactivex.core.Vertx vertx, java.util.function.Supplier<io.vertx.core.Future<io.vertx.mssqlclient.MSSQLConnectOptions>> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.reactivex.mssqlclient.MSSQLPool ret = io.vertx.reactivex.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(vertx.getDelegate(), databases, options));
    return ret;
  }

  public static MSSQLPool newInstance(io.vertx.mssqlclient.MSSQLPool arg) {
    return arg != null ? new MSSQLPool(arg) : null;
  }

}
