/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.grpc.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A gRPC client for Vert.x
 *
 * Unlike traditional gRPC clients, this client does not rely on a generated RPC interface to interact with the service.
 *
 * Instead, you can interact with the service with a request/response interfaces and gRPC messages, very much like
 * a traditional client.
 *
 * The client exposes 2 levels of API
 *
 * <ul>
 *   <li>a Protobuf message {@link io.vertx.reactivex.grpc.client.GrpcClient #request(SocketAddress) API}: {@link io.vertx.reactivex.grpc.client.GrpcClientRequest}/{@link io.vertx.reactivex.grpc.client.GrpcClientResponse} with Protobuf messages to call any gRPC service in a generic way</li>
 *   <li>a gRPC message {@link io.vertx.reactivex.grpc.client.GrpcClient#request}: {@link io.vertx.reactivex.grpc.client.GrpcClientRequest}/{@link io.vertx.reactivex.grpc.client.GrpcClientRequest} with gRPC messages to call a given method of a gRPC service</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpc.client.GrpcClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpc.client.GrpcClient.class)
public class GrpcClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcClient that = (GrpcClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcClient> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcClient((io.vertx.grpc.client.GrpcClient) obj),
    GrpcClient::getDelegate
  );

  private final io.vertx.grpc.client.GrpcClient delegate;
  
  public GrpcClient(io.vertx.grpc.client.GrpcClient delegate) {
    this.delegate = delegate;
  }

  public GrpcClient(Object delegate) {
    this.delegate = (io.vertx.grpc.client.GrpcClient)delegate;
  }

  @Override 
  public io.vertx.grpc.client.GrpcClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.reactivex.core.buffer.Buffer,io.vertx.reactivex.core.buffer.Buffer>> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.reactivex.core.buffer.Buffer,io.vertx.reactivex.core.buffer.Buffer>>(o1 -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)o1, new TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o2 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o2), o2 -> o2.getDelegate()), new TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o2 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

  /**
   * Create a new client
   * @param vertx the vertx instance
   * @return the created client
   */
  public static io.vertx.reactivex.grpc.client.GrpcClient client(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.grpc.client.GrpcClient ret = io.vertx.reactivex.grpc.client.GrpcClient.newInstance((io.vertx.grpc.client.GrpcClient)io.vertx.grpc.client.GrpcClient.client(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new client
   * @param vertx the vertx instance
   * @param options 
   * @return the created client
   */
  public static io.vertx.reactivex.grpc.client.GrpcClient client(io.vertx.reactivex.core.Vertx vertx, io.vertx.grpc.client.GrpcClientOptions options) { 
    io.vertx.reactivex.grpc.client.GrpcClient ret = io.vertx.reactivex.grpc.client.GrpcClient.newInstance((io.vertx.grpc.client.GrpcClient)io.vertx.grpc.client.GrpcClient.client(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a new client
   * @param vertx the vertx instance
   * @param options the client options
   * @return the created client
   */
  public static io.vertx.reactivex.grpc.client.GrpcClient client(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.http.HttpClientOptions options) { 
    io.vertx.reactivex.grpc.client.GrpcClient ret = io.vertx.reactivex.grpc.client.GrpcClient.newInstance((io.vertx.grpc.client.GrpcClient)io.vertx.grpc.client.GrpcClient.client(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connect to the remote <code>server</code> and create a request for any hosted gRPC service.
   * @param server the server hosting the service
   * @return a future request
   */
  public io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.reactivex.core.buffer.Buffer,io.vertx.reactivex.core.buffer.Buffer>> request(io.vertx.reactivex.core.net.SocketAddress server) { 
    io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.reactivex.core.buffer.Buffer,io.vertx.reactivex.core.buffer.Buffer>> ret = delegate.request(server.getDelegate()).map(val -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)val, new TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o0 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o0), o0 -> o0.getDelegate()), new TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o0 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o0), o0 -> o0.getDelegate())));
    return ret;
  }

  /**
   * Connect to the remote <code>server</code> and create a request for any hosted gRPC service.
   * @param server the server hosting the service
   * @return a future request
   */
  public io.reactivex.Single<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.reactivex.core.buffer.Buffer,io.vertx.reactivex.core.buffer.Buffer>> rxRequest(io.vertx.reactivex.core.net.SocketAddress server) { 
    return AsyncResultSingle.toSingle($handler -> {
      request(server).onComplete($handler);
    });
  }

  /**
   * Connect to the remote <code>server</code> and create a request for any hosted gRPC service.
   * @param server the server hosting the service
   * @param method the grpc method
   * @return a future request
   */
  public <Req, Resp> io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> request(io.vertx.reactivex.core.net.SocketAddress server, io.vertx.reactivex.grpc.common.ServiceMethod<Resp,Req> method) { 
    io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> ret = delegate.request(server.getDelegate(), method.getDelegate()).map(val -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)val, method.__typeArg_1, method.__typeArg_0));
    return ret;
  }

  /**
   * Connect to the remote <code>server</code> and create a request for any hosted gRPC service.
   * @param server the server hosting the service
   * @param method the grpc method
   * @return a future request
   */
  public <Req, Resp> io.reactivex.Single<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> rxRequest(io.vertx.reactivex.core.net.SocketAddress server, io.vertx.reactivex.grpc.common.ServiceMethod<Resp,Req> method) { 
    return AsyncResultSingle.toSingle($handler -> {
      request(server, method).onComplete($handler);
    });
  }

  /**
   * Close this client.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close this client.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close().onComplete($handler);
    });
  }

  /**
   * @param server 
   * @param service 
   * @return 
   */
  @Deprecated()
  public <Req, Resp> io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> request(io.vertx.reactivex.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service) { 
    io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> ret = delegate.request(server.getDelegate(), service).map(val -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)val, TypeArg.unknown(), TypeArg.unknown()));
    return ret;
  }

  /**
   * @param server 
   * @param service 
   * @return 
   */
  @Deprecated()
  public <Req, Resp> io.reactivex.Single<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> rxRequest(io.vertx.reactivex.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service) { 
    return AsyncResultSingle.toSingle($handler -> {
      request(server, service).onComplete($handler);
    });
  }

  /**
   * @param server 
   * @param service 
   * @param requestHandler 
   * @param resultFn 
   * @return 
   */
  @Deprecated()
  public <Req, Resp, T> io.vertx.core.Future<T> call(io.vertx.reactivex.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service, io.vertx.core.Handler<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> requestHandler, java.util.function.Function<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>,io.vertx.core.Future<T>> resultFn) { 
    io.vertx.core.Future<T> ret = delegate.call(server.getDelegate(), service, io.vertx.lang.reactivex.Helper.convertHandler(requestHandler, event -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)event, TypeArg.unknown(), TypeArg.unknown())), new Function<io.vertx.grpc.client.GrpcClientResponse<Req,Resp>,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.grpc.client.GrpcClientResponse<Req,Resp> arg) {
        io.vertx.core.Future<T> ret = resultFn.apply(io.vertx.reactivex.grpc.client.GrpcClientResponse.newInstance((io.vertx.grpc.client.GrpcClientResponse)arg, TypeArg.unknown(), TypeArg.unknown()));
        return ret.map(val -> val);
      }
    }).map(val -> (T) val);
    return ret;
  }

  /**
   * @param server 
   * @param service 
   * @param requestHandler 
   * @param resultFn 
   * @return 
   */
  @Deprecated()
  public <Req, Resp, T> io.reactivex.Single<T> rxCall(io.vertx.reactivex.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service, io.vertx.core.Handler<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> requestHandler, java.util.function.Function<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>,io.vertx.core.Future<T>> resultFn) { 
    return AsyncResultSingle.toSingle($handler -> {
      call(server, service, requestHandler, resultFn).onComplete($handler);
    });
  }

  /**
   * @param server 
   * @param service 
   * @param requestHandler 
   * @param resultFn 
   * @return 
   */
  @Deprecated()
  public <Req, Resp, T> io.vertx.core.Future<T> call(io.vertx.reactivex.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service, io.vertx.core.Handler<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> requestHandler, io.reactivex.functions.Function<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>,io.reactivex.Single<T>> resultFn) { 
    io.vertx.core.Future<T> ret = delegate.call(server.getDelegate(), service, io.vertx.lang.reactivex.Helper.convertHandler(requestHandler, event -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)event, TypeArg.unknown(), TypeArg.unknown())), new Function<io.vertx.grpc.client.GrpcClientResponse<Req,Resp>,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.grpc.client.GrpcClientResponse<Req,Resp> arg) {
        io.reactivex.Single<T> ret;
        try {
          ret = resultFn.apply(io.vertx.reactivex.grpc.client.GrpcClientResponse.newInstance((io.vertx.grpc.client.GrpcClientResponse)arg, TypeArg.unknown(), TypeArg.unknown()));
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj);
      }
    }).map(val -> (T) val);
    return ret;
  }

  /**
   * @param server 
   * @param service 
   * @param requestHandler 
   * @param resultFn 
   * @return 
   */
  @Deprecated()
  public <Req, Resp, T> io.reactivex.Single<T> rxCall(io.vertx.reactivex.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service, io.vertx.core.Handler<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> requestHandler, io.reactivex.functions.Function<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>,io.reactivex.Single<T>> resultFn) { 
    return AsyncResultSingle.toSingle($handler -> {
      call(server, service, requestHandler, resultFn).onComplete($handler);
    });
  }

  public static GrpcClient newInstance(io.vertx.grpc.client.GrpcClient arg) {
    return arg != null ? new GrpcClient(arg) : null;
  }

}
