/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.templ.mvel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A template engine that uses the Handlebars library.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.templ.mvel.MVELTemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.templ.mvel.MVELTemplateEngine.class)
public class MVELTemplateEngine extends io.vertx.reactivex.ext.web.common.template.TemplateEngine implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MVELTemplateEngine that = (MVELTemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MVELTemplateEngine> __TYPE_ARG = new TypeArg<>(    obj -> new MVELTemplateEngine((io.vertx.ext.web.templ.mvel.MVELTemplateEngine) obj),
    MVELTemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.templ.mvel.MVELTemplateEngine delegate;
  
  public MVELTemplateEngine(io.vertx.ext.web.templ.mvel.MVELTemplateEngine delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MVELTemplateEngine(Object delegate) {
    super((io.vertx.ext.web.templ.mvel.MVELTemplateEngine)delegate);
    this.delegate = (io.vertx.ext.web.templ.mvel.MVELTemplateEngine)delegate;
  }

  @Override 
  public io.vertx.ext.web.templ.mvel.MVELTemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @return the engine
   */
  public static io.vertx.reactivex.ext.web.templ.mvel.MVELTemplateEngine create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.templ.mvel.MVELTemplateEngine ret = io.vertx.reactivex.ext.web.templ.mvel.MVELTemplateEngine.newInstance((io.vertx.ext.web.templ.mvel.MVELTemplateEngine)io.vertx.ext.web.templ.mvel.MVELTemplateEngine.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @param extension 
   * @return the engine
   */
  public static io.vertx.reactivex.ext.web.templ.mvel.MVELTemplateEngine create(io.vertx.reactivex.core.Vertx vertx, java.lang.String extension) { 
    io.vertx.reactivex.ext.web.templ.mvel.MVELTemplateEngine ret = io.vertx.reactivex.ext.web.templ.mvel.MVELTemplateEngine.newInstance((io.vertx.ext.web.templ.mvel.MVELTemplateEngine)io.vertx.ext.web.templ.mvel.MVELTemplateEngine.create(vertx.getDelegate(), extension));
    return ret;
  }

  /**
   * Default template extension
   */
  public static final java.lang.String DEFAULT_TEMPLATE_EXTENSION = io.vertx.ext.web.templ.mvel.MVELTemplateEngine.DEFAULT_TEMPLATE_EXTENSION;
  public static MVELTemplateEngine newInstance(io.vertx.ext.web.templ.mvel.MVELTemplateEngine arg) {
    return arg != null ? new MVELTemplateEngine(arg) : null;
  }

}
