/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.openapi.router;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.ext.web.openapi.router.OpenAPIRoute.class)
public class OpenAPIRoute implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpenAPIRoute that = (OpenAPIRoute) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OpenAPIRoute> __TYPE_ARG = new TypeArg<>(    obj -> new OpenAPIRoute((io.vertx.ext.web.openapi.router.OpenAPIRoute) obj),
    OpenAPIRoute::getDelegate
  );

  private final io.vertx.ext.web.openapi.router.OpenAPIRoute delegate;
  
  public OpenAPIRoute(io.vertx.ext.web.openapi.router.OpenAPIRoute delegate) {
    this.delegate = delegate;
  }

  public OpenAPIRoute(Object delegate) {
    this.delegate = (io.vertx.ext.web.openapi.router.OpenAPIRoute)delegate;
  }

  @Override 
  public io.vertx.ext.web.openapi.router.OpenAPIRoute getDelegate() {
    return delegate;
  }

  /**
   * Adds a handler for this route which is executed after the security and validation handlers defined in the contract
   * @param handler The handler to add
   * @return the route
   */
  public io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute addHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    delegate.addHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event)));
    return this;
  }

  /**
   * Adds a failure handler for this route
   * @param handler The failure handler to add
   * @return the route
   */
  public io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute addFailureHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    delegate.addFailureHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event)));
    return this;
  }

  /**
   * @return the related operation of this route
   */
  public io.vertx.reactivex.openapi.contract.Operation getOperation() { 
    io.vertx.reactivex.openapi.contract.Operation ret = io.vertx.reactivex.openapi.contract.Operation.newInstance((io.vertx.openapi.contract.Operation)delegate.getOperation());
    return ret;
  }

  /**
   * @return true if validation based on the OpenAPI contract is active for this route. By default, it is active.
   */
  public boolean doValidation() { 
    boolean ret = delegate.doValidation();
    return ret;
  }

  /**
   * Sets the validation flag for incoming requests.
   * @param doValidation The validation flag.
   * @return the route
   */
  public io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute setDoValidation(boolean doValidation) { 
    io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute ret = io.vertx.reactivex.ext.web.openapi.router.OpenAPIRoute.newInstance((io.vertx.ext.web.openapi.router.OpenAPIRoute)delegate.setDoValidation(doValidation));
    return ret;
  }

  public static OpenAPIRoute newInstance(io.vertx.ext.web.openapi.router.OpenAPIRoute arg) {
    return arg != null ? new OpenAPIRoute(arg) : null;
  }

}
