/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.unit.report;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Report the execution of a test case.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.unit.report.TestCaseReport original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.unit.report.TestCaseReport.class)
public class TestCaseReport implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TestCaseReport that = (TestCaseReport) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TestCaseReport> __TYPE_ARG = new TypeArg<>(    obj -> new TestCaseReport((io.vertx.ext.unit.report.TestCaseReport) obj),
    TestCaseReport::getDelegate
  );

  private final io.vertx.ext.unit.report.TestCaseReport delegate;
  
  public TestCaseReport(io.vertx.ext.unit.report.TestCaseReport delegate) {
    this.delegate = delegate;
  }

  public TestCaseReport(Object delegate) {
    this.delegate = (io.vertx.ext.unit.report.TestCaseReport)delegate;
  }

  @Override 
  public io.vertx.ext.unit.report.TestCaseReport getDelegate() {
    return delegate;
  }

  /**
   * @return the test case name
   */
  public java.lang.String name() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.name();
    cached_0 = ret;
    return ret;
  }

  /**
   * Set a callback for completion, the specified <code>handler</code> is invoked when the test exec has completed.
   * @param handler the completion handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.unit.report.TestCaseReport endHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.unit.report.TestResult> handler) { 
    delegate.endHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.ext.unit.report.TestResult.newInstance((io.vertx.ext.unit.report.TestResult)event)));
    return this;
  }

  private java.lang.String cached_0;
  public static TestCaseReport newInstance(io.vertx.ext.unit.report.TestCaseReport arg) {
    return arg != null ? new TestCaseReport(arg) : null;
  }

}
