/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.json.pointer;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The JsonPointerIterator is used by the read/write algorithms of the {@link io.vertx.reactivex.core.json.pointer.JsonPointer} to read/write the querying data structure <br/>
 *
 * Every method takes the currentValue as parameter, representing the actual value held by the query algorithm.<br/>
 *
 * Implementations of this interface should be stateless, so they can be reused<br/>
 *
 * You can implement this interface to query the structure you want using json pointers
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.json.pointer.JsonPointerIterator original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.json.pointer.JsonPointerIterator.class)
public class JsonPointerIterator implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonPointerIterator that = (JsonPointerIterator) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JsonPointerIterator> __TYPE_ARG = new TypeArg<>(    obj -> new JsonPointerIterator((io.vertx.core.json.pointer.JsonPointerIterator) obj),
    JsonPointerIterator::getDelegate
  );

  private final io.vertx.core.json.pointer.JsonPointerIterator delegate;
  
  public JsonPointerIterator(io.vertx.core.json.pointer.JsonPointerIterator delegate) {
    this.delegate = delegate;
  }

  public JsonPointerIterator(Object delegate) {
    this.delegate = (io.vertx.core.json.pointer.JsonPointerIterator)delegate;
  }

  @Override 
  public io.vertx.core.json.pointer.JsonPointerIterator getDelegate() {
    return delegate;
  }

  /**
   * @param currentValue 
   * @return <code>true</code> if the current value is a queryable object
   */
  public boolean isObject(java.lang.Object currentValue) { 
    boolean ret = delegate.isObject(currentValue);
    return ret;
  }

  /**
   * @param currentValue 
   * @return <code>true</code> if the current value is a queryable array
   */
  public boolean isArray(java.lang.Object currentValue) { 
    boolean ret = delegate.isArray(currentValue);
    return ret;
  }

  /**
   * @param currentValue 
   * @return <code>true</code> if the current value is null/empty
   */
  public boolean isNull(java.lang.Object currentValue) { 
    boolean ret = delegate.isNull(currentValue);
    return ret;
  }

  /**
   * @param currentValue 
   * @param key object key
   * @return <code>true</code> if current value is a queryable object that contains the specified key
   */
  public boolean objectContainsKey(java.lang.Object currentValue, java.lang.String key) { 
    boolean ret = delegate.objectContainsKey(currentValue, key);
    return ret;
  }

  /**
   * Returns the object parameter with specified key.
   * @param currentValue 
   * @param key object key
   * @param createOnMissing If the current value is an object that doesn't contain the key, put an empty object at provided key
   * @return the requested object parameter, or null if the method was not able to find it
   */
  public java.lang.Object getObjectParameter(java.lang.Object currentValue, java.lang.String key, boolean createOnMissing) { 
    java.lang.Object ret = (Object) delegate.getObjectParameter(currentValue, key, createOnMissing);
    return ret;
  }

  /**
   * Move the iterator the array element at specified index
   * @param currentValue 
   * @param i array index
   * @return the request array element, or null if the method was not able to find it
   */
  public java.lang.Object getArrayElement(java.lang.Object currentValue, int i) { 
    java.lang.Object ret = (Object) delegate.getArrayElement(currentValue, i);
    return ret;
  }

  /**
   * Write object parameter at specified key
   * @param currentValue 
   * @param key 
   * @param value 
   * @return true if the operation is successful
   */
  public boolean writeObjectParameter(java.lang.Object currentValue, java.lang.String key, java.lang.Object value) { 
    boolean ret = delegate.writeObjectParameter(currentValue, key, value);
    return ret;
  }

  /**
   * Write array element at specified index
   * @param currentValue 
   * @param i 
   * @param value 
   * @return true if the operation is successful
   */
  public boolean writeArrayElement(java.lang.Object currentValue, int i, java.lang.Object value) { 
    boolean ret = delegate.writeArrayElement(currentValue, i, value);
    return ret;
  }

  /**
   * Append array element
   * @param currentValue 
   * @param value 
   * @return true if the operation is successful
   */
  public boolean appendArrayElement(java.lang.Object currentValue, java.lang.Object value) { 
    boolean ret = delegate.appendArrayElement(currentValue, value);
    return ret;
  }

  /**
   * Instance of a JsonPointerIterator to query Vert.x Json structures
   */
  public static final io.vertx.reactivex.core.json.pointer.JsonPointerIterator JSON_ITERATOR = io.vertx.reactivex.core.json.pointer.JsonPointerIterator.newInstance((io.vertx.core.json.pointer.JsonPointerIterator)io.vertx.core.json.pointer.JsonPointerIterator.JSON_ITERATOR);
  public static JsonPointerIterator newInstance(io.vertx.core.json.pointer.JsonPointerIterator arg) {
    return arg != null ? new JsonPointerIterator(arg) : null;
  }

}
