/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.openapi;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.openapi.OpenAPILoaderOptions;
import io.vertx.ext.web.openapi.RouterBuilderOptions;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.reactivex.ext.web.handler.AuthenticationHandler;
import io.vertx.reactivex.ext.web.handler.BodyHandler;
import io.vertx.reactivex.ext.web.openapi.OpenAPIHolder;
import io.vertx.reactivex.ext.web.openapi.Operation;
import io.vertx.reactivex.ext.web.openapi.SecurityScheme;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.json.schema.SchemaParser;
import io.vertx.reactivex.json.schema.SchemaRouter;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.ext.web.openapi.RouterBuilder.class)
public class RouterBuilder
implements RxDelegate {
    public static final TypeArg<RouterBuilder> __TYPE_ARG = new TypeArg(obj -> new RouterBuilder((io.vertx.ext.web.openapi.RouterBuilder)obj), RouterBuilder::getDelegate);
    private final io.vertx.ext.web.openapi.RouterBuilder delegate;
    private static final TypeArg<Operation> TYPE_ARG_0 = new TypeArg(o1 -> Operation.newInstance((io.vertx.ext.web.openapi.Operation)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouterBuilder that = (RouterBuilder)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RouterBuilder(io.vertx.ext.web.openapi.RouterBuilder delegate) {
        this.delegate = delegate;
    }

    public RouterBuilder(Object delegate) {
        this.delegate = (io.vertx.ext.web.openapi.RouterBuilder)delegate;
    }

    public io.vertx.ext.web.openapi.RouterBuilder getDelegate() {
        return this.delegate;
    }

    public Operation operation(String operationId) {
        Operation ret = Operation.newInstance(this.delegate.operation(operationId));
        return ret;
    }

    public List<Operation> operations() {
        List<Operation> ret = this.delegate.operations().stream().map(elt -> Operation.newInstance(elt)).collect(Collectors.toList());
        return ret;
    }

    @Deprecated
    public RouterBuilder bodyHandler(BodyHandler bodyHandler) {
        this.delegate.bodyHandler(bodyHandler.getDelegate());
        return this;
    }

    public RouterBuilder rootHandler(Handler<RoutingContext> rootHandler) {
        this.delegate.rootHandler(Helper.convertHandler(rootHandler, event -> RoutingContext.newInstance(event)));
        return this;
    }

    public RouterBuilder mountServicesFromExtensions() {
        this.delegate.mountServicesFromExtensions();
        return this;
    }

    public RouterBuilder setOptions(RouterBuilderOptions options) {
        this.delegate.setOptions(options);
        return this;
    }

    public RouterBuilderOptions getOptions() {
        RouterBuilderOptions ret = this.delegate.getOptions();
        return ret;
    }

    public OpenAPIHolder getOpenAPI() {
        OpenAPIHolder ret = OpenAPIHolder.newInstance(this.delegate.getOpenAPI());
        return ret;
    }

    @Deprecated
    public SchemaRouter getSchemaRouter() {
        SchemaRouter ret = SchemaRouter.newInstance(this.delegate.getSchemaRouter());
        return ret;
    }

    @Deprecated
    public SchemaParser getSchemaParser() {
        SchemaParser ret = SchemaParser.newInstance(this.delegate.getSchemaParser());
        return ret;
    }

    public RouterBuilder serviceExtraPayloadMapper(final Function<RoutingContext, JsonObject> serviceExtraPayloadMapper) {
        this.delegate.serviceExtraPayloadMapper((Function)new Function<io.vertx.ext.web.RoutingContext, JsonObject>(){

            @Override
            public JsonObject apply(io.vertx.ext.web.RoutingContext arg) {
                JsonObject ret = (JsonObject)serviceExtraPayloadMapper.apply(RoutingContext.newInstance(arg));
                return ret;
            }
        });
        return this;
    }

    public SecurityScheme securityHandler(String securitySchemeName) {
        SecurityScheme ret = SecurityScheme.newInstance(this.delegate.securityHandler(securitySchemeName));
        return ret;
    }

    public Router createRouter() {
        Router ret = Router.newInstance(this.delegate.createRouter());
        return ret;
    }

    public static void create(io.vertx.reactivex.core.Vertx vertx, String url, Handler<AsyncResult<RouterBuilder>> handler) {
        io.vertx.ext.web.openapi.RouterBuilder.create((Vertx)vertx.getDelegate(), (String)url, (Handler)Helper.convertHandler(handler, ar -> ar.map(event -> RouterBuilder.newInstance(event))));
    }

    public static void create(io.vertx.reactivex.core.Vertx vertx, String url) {
        RouterBuilder.create(vertx, url, (Handler<AsyncResult<RouterBuilder>>)((Handler)ar -> {}));
    }

    public static Single<RouterBuilder> rxCreate(io.vertx.reactivex.core.Vertx vertx, String url) {
        return AsyncResultSingle.toSingle($handler -> RouterBuilder.create(vertx, url, (Handler<AsyncResult<RouterBuilder>>)$handler));
    }

    public static void create(io.vertx.reactivex.core.Vertx vertx, String url, OpenAPILoaderOptions options, Handler<AsyncResult<RouterBuilder>> handler) {
        io.vertx.ext.web.openapi.RouterBuilder.create((Vertx)vertx.getDelegate(), (String)url, (OpenAPILoaderOptions)options, (Handler)Helper.convertHandler(handler, ar -> ar.map(event -> RouterBuilder.newInstance(event))));
    }

    public static void create(io.vertx.reactivex.core.Vertx vertx, String url, OpenAPILoaderOptions options) {
        RouterBuilder.create(vertx, url, options, (Handler<AsyncResult<RouterBuilder>>)((Handler)ar -> {}));
    }

    public static Single<RouterBuilder> rxCreate(io.vertx.reactivex.core.Vertx vertx, String url, OpenAPILoaderOptions options) {
        return AsyncResultSingle.toSingle($handler -> RouterBuilder.create(vertx, url, options, (Handler<AsyncResult<RouterBuilder>>)$handler));
    }

    public RouterBuilder securityHandler(String securitySchemeName, AuthenticationHandler handler) {
        this.delegate.securityHandler(securitySchemeName, handler.getDelegate());
        return this;
    }

    public static RouterBuilder newInstance(io.vertx.ext.web.openapi.RouterBuilder arg) {
        return arg != null ? new RouterBuilder(arg) : null;
    }
}

