/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.net;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.net.SSLOptions;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.net.NetSocket;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.core.net.NetClient.class)
public class NetClient
implements Measured {
    public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg(obj -> new NetClient((io.vertx.core.net.NetClient)obj), NetClient::getDelegate);
    private final io.vertx.core.net.NetClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetClient that = (NetClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetClient(io.vertx.core.net.NetClient delegate) {
        this.delegate = delegate;
    }

    public NetClient(Object delegate) {
        this.delegate = (io.vertx.core.net.NetClient)delegate;
    }

    public io.vertx.core.net.NetClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public NetClient connect(int port, String host, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(port, host, (Handler)new DelegatingHandler(connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event))));
        return this;
    }

    public NetClient connect(int port, String host) {
        return this.connect(port, host, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(int port, String host) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host, (Handler<AsyncResult<NetSocket>>)$handler));
    }

    public NetClient connect(int port, String host, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(port, host, serverName, (Handler)new DelegatingHandler(connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event))));
        return this;
    }

    public NetClient connect(int port, String host, String serverName) {
        return this.connect(port, host, serverName, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(int port, String host, String serverName) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host, serverName, (Handler<AsyncResult<NetSocket>>)$handler));
    }

    public NetClient connect(SocketAddress remoteAddress, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(remoteAddress.getDelegate(), (Handler)new DelegatingHandler(connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event))));
        return this;
    }

    public NetClient connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress) {
        return AsyncResultSingle.toSingle($handler -> this.connect(remoteAddress, (Handler<AsyncResult<NetSocket>>)$handler));
    }

    public NetClient connect(SocketAddress remoteAddress, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(remoteAddress.getDelegate(), serverName, (Handler)new DelegatingHandler(connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event))));
        return this;
    }

    public NetClient connect(SocketAddress remoteAddress, String serverName) {
        return this.connect(remoteAddress, serverName, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress, String serverName) {
        return AsyncResultSingle.toSingle($handler -> this.connect(remoteAddress, serverName, (Handler<AsyncResult<NetSocket>>)$handler));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public void updateSSLOptions(SSLOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.updateSSLOptions(options, handler);
    }

    public void updateSSLOptions(SSLOptions options) {
        this.updateSSLOptions(options, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxUpdateSSLOptions(SSLOptions options) {
        return AsyncResultCompletable.toCompletable($handler -> this.updateSSLOptions(options, (Handler<AsyncResult<Void>>)$handler));
    }

    public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
        return arg != null ? new NetClient(arg) : null;
    }
}

