/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.handler;

import io.reactivex.Completable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.CookieSameSite;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.ext.auth.AuthProvider;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.reactivex.ext.web.Session;
import io.vertx.reactivex.ext.web.sstore.SessionStore;
import io.vertx.reactivex.impl.AsyncResultCompletable;

@RxGen(value=io.vertx.ext.web.handler.SessionHandler.class)
public class SessionHandler
implements Handler<RoutingContext> {
    public static final TypeArg<SessionHandler> __TYPE_ARG = new TypeArg(obj -> new SessionHandler((io.vertx.ext.web.handler.SessionHandler)obj), SessionHandler::getDelegate);
    private final io.vertx.ext.web.handler.SessionHandler delegate;
    public static final String DEFAULT_SESSION_COOKIE_NAME = "vertx-web.session";
    public static final String DEFAULT_SESSION_COOKIE_PATH = "/";
    public static final long DEFAULT_SESSION_TIMEOUT = 1800000L;
    public static final boolean DEFAULT_NAG_HTTPS = true;
    public static final boolean DEFAULT_COOKIE_HTTP_ONLY_FLAG = false;
    public static final boolean DEFAULT_COOKIE_SECURE_FLAG = false;
    public static final int DEFAULT_SESSIONID_MIN_LENGTH = 16;
    public static final boolean DEFAULT_LAZY_SESSION = false;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionHandler that = (SessionHandler)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SessionHandler(io.vertx.ext.web.handler.SessionHandler delegate) {
        this.delegate = delegate;
    }

    public SessionHandler(Object delegate) {
        this.delegate = (io.vertx.ext.web.handler.SessionHandler)delegate;
    }

    public io.vertx.ext.web.handler.SessionHandler getDelegate() {
        return this.delegate;
    }

    public void handle(RoutingContext event) {
        this.delegate.handle((Object)event.getDelegate());
    }

    public static SessionHandler create(SessionStore sessionStore) {
        SessionHandler ret = SessionHandler.newInstance(io.vertx.ext.web.handler.SessionHandler.create((io.vertx.ext.web.sstore.SessionStore)sessionStore.getDelegate()));
        return ret;
    }

    public SessionHandler setSessionTimeout(long timeout) {
        this.delegate.setSessionTimeout(timeout);
        return this;
    }

    public SessionHandler setNagHttps(boolean nag) {
        this.delegate.setNagHttps(nag);
        return this;
    }

    public SessionHandler setCookieSecureFlag(boolean secure) {
        this.delegate.setCookieSecureFlag(secure);
        return this;
    }

    public SessionHandler setCookieHttpOnlyFlag(boolean httpOnly) {
        this.delegate.setCookieHttpOnlyFlag(httpOnly);
        return this;
    }

    public SessionHandler setSessionCookieName(String sessionCookieName) {
        this.delegate.setSessionCookieName(sessionCookieName);
        return this;
    }

    public SessionHandler setSessionCookiePath(String sessionCookiePath) {
        this.delegate.setSessionCookiePath(sessionCookiePath);
        return this;
    }

    public SessionHandler setMinLength(int minLength) {
        this.delegate.setMinLength(minLength);
        return this;
    }

    public SessionHandler setCookieSameSite(CookieSameSite policy) {
        this.delegate.setCookieSameSite(policy);
        return this;
    }

    public SessionHandler setLazySession(boolean lazySession) {
        this.delegate.setLazySession(lazySession);
        return this;
    }

    public SessionHandler setCookieMaxAge(long cookieMaxAge) {
        this.delegate.setCookieMaxAge(cookieMaxAge);
        return this;
    }

    @Deprecated
    public SessionHandler setAuthProvider(AuthProvider authProvider) {
        this.delegate.setAuthProvider(authProvider.getDelegate());
        return this;
    }

    public SessionHandler flush(RoutingContext ctx, Handler<AsyncResult<Void>> handler) {
        this.delegate.flush(ctx.getDelegate(), handler);
        return this;
    }

    public SessionHandler flush(RoutingContext ctx) {
        return this.flush(ctx, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxFlush(RoutingContext ctx) {
        return AsyncResultCompletable.toCompletable($handler -> this.flush(ctx, (Handler<AsyncResult<Void>>)$handler));
    }

    public SessionHandler flush(RoutingContext ctx, boolean ignoreStatus, Handler<AsyncResult<Void>> handler) {
        this.delegate.flush(ctx.getDelegate(), ignoreStatus, handler);
        return this;
    }

    public SessionHandler flush(RoutingContext ctx, boolean ignoreStatus) {
        return this.flush(ctx, ignoreStatus, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxFlush(RoutingContext ctx, boolean ignoreStatus) {
        return AsyncResultCompletable.toCompletable($handler -> this.flush(ctx, ignoreStatus, (Handler<AsyncResult<Void>>)$handler));
    }

    public SessionHandler setCookieless(boolean cookieless) {
        this.delegate.setCookieless(cookieless);
        return this;
    }

    public Session newSession(RoutingContext context) {
        Session ret = Session.newInstance(this.delegate.newSession(context.getDelegate()));
        return ret;
    }

    public SessionHandler setUser(RoutingContext context, User user, Handler<AsyncResult<Void>> handler) {
        this.delegate.setUser(context.getDelegate(), user.getDelegate(), handler);
        return this;
    }

    public SessionHandler setUser(RoutingContext context, User user) {
        return this.setUser(context, user, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxSetUser(RoutingContext context, User user) {
        return AsyncResultCompletable.toCompletable($handler -> this.setUser(context, user, (Handler<AsyncResult<Void>>)$handler));
    }

    public static SessionHandler newInstance(io.vertx.ext.web.handler.SessionHandler arg) {
        return arg != null ? new SessionHandler(arg) : null;
    }
}

