/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.mqtt.messages.MqttConnAckMessage;
import io.vertx.reactivex.mqtt.messages.MqttPublishMessage;
import io.vertx.reactivex.mqtt.messages.MqttSubAckMessage;
import java.util.Map;

@RxGen(value=io.vertx.mqtt.MqttClient.class)
public class MqttClient {
    public static final TypeArg<MqttClient> __TYPE_ARG = new TypeArg(obj -> new MqttClient((io.vertx.mqtt.MqttClient)obj), MqttClient::getDelegate);
    private final io.vertx.mqtt.MqttClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttClient that = (MqttClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MqttClient(io.vertx.mqtt.MqttClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.mqtt.MqttClient getDelegate() {
        return this.delegate;
    }

    public static MqttClient create(io.vertx.reactivex.core.Vertx vertx, MqttClientOptions options) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create((Vertx)vertx.getDelegate(), (MqttClientOptions)options));
        return ret;
    }

    public static MqttClient create(io.vertx.reactivex.core.Vertx vertx) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public MqttClient connect(int port, String host, final Handler<AsyncResult<MqttConnAckMessage>> connectHandler) {
        this.delegate.connect(port, host, (Handler)new Handler<AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage>>(){

            public void handle(AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public MqttClient connect(int port, String host) {
        return this.connect(port, host, (Handler<AsyncResult<MqttConnAckMessage>>)((Handler)ar -> {}));
    }

    public Single<MqttConnAckMessage> rxConnect(int port, String host) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host, (Handler<AsyncResult<MqttConnAckMessage>>)$handler));
    }

    public MqttClient connect(int port, String host, String serverName, final Handler<AsyncResult<MqttConnAckMessage>> connectHandler) {
        this.delegate.connect(port, host, serverName, (Handler)new Handler<AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage>>(){

            public void handle(AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public MqttClient connect(int port, String host, String serverName) {
        return this.connect(port, host, serverName, (Handler<AsyncResult<MqttConnAckMessage>>)((Handler)ar -> {}));
    }

    public Single<MqttConnAckMessage> rxConnect(int port, String host, String serverName) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host, serverName, (Handler<AsyncResult<MqttConnAckMessage>>)$handler));
    }

    public MqttClient disconnect(Handler<AsyncResult<Void>> disconnectHandler) {
        this.delegate.disconnect(disconnectHandler);
        return this;
    }

    public MqttClient disconnect() {
        return this.disconnect((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxDisconnect() {
        return AsyncResultCompletable.toCompletable($handler -> this.disconnect((Handler<AsyncResult<Void>>)$handler));
    }

    public MqttClient publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, Handler<AsyncResult<Integer>> publishSentHandler) {
        this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler);
        return this;
    }

    public MqttClient publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return this.publish(topic, payload, qosLevel, isDup, isRetain, (Handler<AsyncResult<Integer>>)((Handler)ar -> {}));
    }

    public Single<Integer> rxPublish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return AsyncResultSingle.toSingle($handler -> this.publish(topic, payload, qosLevel, isDup, isRetain, (Handler<AsyncResult<Integer>>)$handler));
    }

    public MqttClient publishCompletionHandler(Handler<Integer> publishCompletionHandler) {
        this.delegate.publishCompletionHandler(publishCompletionHandler);
        return this;
    }

    public MqttClient publishHandler(final Handler<MqttPublishMessage> publishHandler) {
        this.delegate.publishHandler((Handler)new Handler<io.vertx.mqtt.messages.MqttPublishMessage>(){

            public void handle(io.vertx.mqtt.messages.MqttPublishMessage event) {
                publishHandler.handle((Object)MqttPublishMessage.newInstance(event));
            }
        });
        return this;
    }

    public MqttClient subscribeCompletionHandler(final Handler<MqttSubAckMessage> subscribeCompletionHandler) {
        this.delegate.subscribeCompletionHandler((Handler)new Handler<io.vertx.mqtt.messages.MqttSubAckMessage>(){

            public void handle(io.vertx.mqtt.messages.MqttSubAckMessage event) {
                subscribeCompletionHandler.handle((Object)MqttSubAckMessage.newInstance(event));
            }
        });
        return this;
    }

    public MqttClient subscribe(String topic, int qos, Handler<AsyncResult<Integer>> subscribeSentHandler) {
        this.delegate.subscribe(topic, qos, subscribeSentHandler);
        return this;
    }

    public MqttClient subscribe(String topic, int qos) {
        return this.subscribe(topic, qos, (Handler<AsyncResult<Integer>>)((Handler)ar -> {}));
    }

    public Single<Integer> rxSubscribe(String topic, int qos) {
        return AsyncResultSingle.toSingle($handler -> this.subscribe(topic, qos, (Handler<AsyncResult<Integer>>)$handler));
    }

    public MqttClient subscribe(Map<String, Integer> topics, Handler<AsyncResult<Integer>> subscribeSentHandler) {
        this.delegate.subscribe(topics, subscribeSentHandler);
        return this;
    }

    public MqttClient subscribe(Map<String, Integer> topics) {
        return this.subscribe(topics, (Handler<AsyncResult<Integer>>)((Handler)ar -> {}));
    }

    public Single<Integer> rxSubscribe(Map<String, Integer> topics) {
        return AsyncResultSingle.toSingle($handler -> this.subscribe(topics, (Handler<AsyncResult<Integer>>)$handler));
    }

    public MqttClient unsubscribeCompletionHandler(Handler<Integer> unsubscribeCompletionHandler) {
        this.delegate.unsubscribeCompletionHandler(unsubscribeCompletionHandler);
        return this;
    }

    public MqttClient unsubscribe(String topic, Handler<AsyncResult<Integer>> unsubscribeSentHandler) {
        this.delegate.unsubscribe(topic, unsubscribeSentHandler);
        return this;
    }

    public MqttClient unsubscribe(String topic) {
        return this.unsubscribe(topic, (Handler<AsyncResult<Integer>>)((Handler)ar -> {}));
    }

    public Single<Integer> rxUnsubscribe(String topic) {
        return AsyncResultSingle.toSingle($handler -> this.unsubscribe(topic, (Handler<AsyncResult<Integer>>)$handler));
    }

    public MqttClient pingResponseHandler(Handler<Void> pingResponseHandler) {
        this.delegate.pingResponseHandler(pingResponseHandler);
        return this;
    }

    public MqttClient exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public MqttClient closeHandler(Handler<Void> closeHandler) {
        this.delegate.closeHandler(closeHandler);
        return this;
    }

    public MqttClient ping() {
        this.delegate.ping();
        return this;
    }

    public String clientId() {
        String ret = this.delegate.clientId();
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public static MqttClient newInstance(io.vertx.mqtt.MqttClient arg) {
        return arg != null ? new MqttClient(arg) : null;
    }
}

