/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.http.WebSocketBase;
import io.vertx.reactivex.core.http.WebSocketFrame;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import java.util.function.Function;
import javax.net.ssl.SSLSession;

class WebSocketBaseImpl
implements WebSocketBase {
    private final io.vertx.core.http.WebSocketBase delegate;
    private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
    private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;
    private WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public WebSocketBaseImpl(io.vertx.core.http.WebSocketBase delegate) {
        this.delegate = delegate;
    }

    @Override
    public io.vertx.core.http.WebSocketBase getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    public synchronized WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver(this.getDelegate(), conv);
        }
        return this.observer;
    }

    public synchronized WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void write(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write((Object)data.getDelegate(), handler);
    }

    @Override
    public void write(io.vertx.reactivex.core.buffer.Buffer data) {
        this.write(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end((Object)data.getDelegate(), handler);
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer data) {
        this.end(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.end(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxPipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public WebSocketBase exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase handler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public WebSocketBase resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public WebSocketBase fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public WebSocketBase endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public WebSocketBase setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public WebSocketBase drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public WebSocketBase writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFrame(frame.getDelegate(), handler);
        return this;
    }

    @Override
    public WebSocketBase writeFrame(WebSocketFrame frame) {
        return this.writeFrame(frame, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxWriteFrame(WebSocketFrame frame) {
        return AsyncResultCompletable.toCompletable(handler -> this.writeFrame(frame, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public WebSocketBase writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalTextFrame(text, handler);
        return this;
    }

    @Override
    public WebSocketBase writeFinalTextFrame(String text) {
        return this.writeFinalTextFrame(text, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxWriteFinalTextFrame(String text) {
        return AsyncResultCompletable.toCompletable(handler -> this.writeFinalTextFrame(text, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public WebSocketBase writeFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
        return this;
    }

    @Override
    public WebSocketBase writeFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data) {
        return this.writeFinalBinaryFrame(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxWriteFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.writeFinalBinaryFrame(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public WebSocketBase writeBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeBinaryMessage(data.getDelegate(), handler);
        return this;
    }

    @Override
    public WebSocketBase writeBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data) {
        return this.writeBinaryMessage(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxWriteBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.writeBinaryMessage(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public WebSocketBase writeTextMessage(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeTextMessage(text, handler);
        return this;
    }

    @Override
    public WebSocketBase writeTextMessage(String text) {
        return this.writeTextMessage(text, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxWriteTextMessage(String text) {
        return AsyncResultCompletable.toCompletable(handler -> this.writeTextMessage(text, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public WebSocketBase writePing(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.writePing(data.getDelegate());
        return this;
    }

    @Override
    public WebSocketBase writePong(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.writePong(data.getDelegate());
        return this;
    }

    @Override
    public WebSocketBase closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase frameHandler(final Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler((Handler)new Handler<io.vertx.core.http.WebSocketFrame>(){

            public void handle(io.vertx.core.http.WebSocketFrame event) {
                handler.handle((Object)WebSocketFrame.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase binaryMessageHandler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.binaryMessageHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase pongHandler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.pongHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.end((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Override
    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void close(short statusCode, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, handler);
    }

    @Override
    public void close(short statusCode) {
        this.close(statusCode, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxClose(short statusCode) {
        return AsyncResultCompletable.toCompletable(handler -> this.close(statusCode, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, reason, handler);
    }

    @Override
    public void close(short statusCode, String reason) {
        this.close(statusCode, reason, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxClose(short statusCode, String reason) {
        return AsyncResultCompletable.toCompletable(handler -> this.close(statusCode, reason, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }
}

