/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.amqp;

import io.reactivex.Completable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.amqp.AmqpConnection;
import io.vertx.reactivex.amqp.AmqpMessage;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import java.util.function.Function;

@RxGen(value=io.vertx.amqp.AmqpSender.class)
public class AmqpSender
implements WriteStream<AmqpMessage> {
    public static final TypeArg<AmqpSender> __TYPE_ARG = new TypeArg(obj -> new AmqpSender((io.vertx.amqp.AmqpSender)obj), AmqpSender::getDelegate);
    private final io.vertx.amqp.AmqpSender delegate;
    private WriteStreamObserver<AmqpMessage> observer;
    private WriteStreamSubscriber<AmqpMessage> subscriber;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpSender that = (AmqpSender)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpSender(io.vertx.amqp.AmqpSender delegate) {
        this.delegate = delegate;
    }

    public io.vertx.amqp.AmqpSender getDelegate() {
        return this.delegate;
    }

    public synchronized WriteStreamObserver<AmqpMessage> toObserver() {
        if (this.observer == null) {
            Function<AmqpMessage, io.vertx.amqp.AmqpMessage> conv = AmqpMessage::getDelegate;
            this.observer = RxHelper.toObserver(this.getDelegate(), conv);
        }
        return this.observer;
    }

    public synchronized WriteStreamSubscriber<AmqpMessage> toSubscriber() {
        if (this.subscriber == null) {
            Function<AmqpMessage, io.vertx.amqp.AmqpMessage> conv = AmqpMessage::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.end((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void end(AmqpMessage data) {
        this.delegate.end((Object)data.getDelegate());
    }

    @Override
    public void end(AmqpMessage data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end((Object)data.getDelegate(), handler);
    }

    public Completable rxEnd(AmqpMessage data) {
        return AsyncResultCompletable.toCompletable(handler -> this.end(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public WriteStream<AmqpMessage> drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public AmqpSender write(AmqpMessage data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    public AmqpSender write(AmqpMessage data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data.getDelegate(), handler);
        return this;
    }

    public Completable rxWrite(AmqpMessage data) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public AmqpSender exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AmqpSender setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public AmqpSender send(AmqpMessage message) {
        this.delegate.send(message.getDelegate());
        return this;
    }

    public AmqpSender sendWithAck(AmqpMessage message, Handler<AsyncResult<Void>> acknowledgementHandler) {
        this.delegate.sendWithAck(message.getDelegate(), acknowledgementHandler);
        return this;
    }

    public Completable rxSendWithAck(AmqpMessage message) {
        return AsyncResultCompletable.toCompletable(handler -> this.sendWithAck(message, (Handler<AsyncResult<Void>>)handler));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    public String address() {
        String ret = this.delegate.address();
        return ret;
    }

    public AmqpConnection connection() {
        AmqpConnection ret = AmqpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public static AmqpSender newInstance(io.vertx.amqp.AmqpSender arg) {
        return arg != null ? new AmqpSender(arg) : null;
    }
}

