/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.client;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.ext.web.client.HttpResponse;
import io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate;
import io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult;
import io.vertx.reactivex.ext.web.codec.BodyCodec;
import io.vertx.reactivex.ext.web.multipart.MultipartForm;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.ReadStreamSubscriber;
import java.util.function.Function;

@RxGen(value=io.vertx.ext.web.client.HttpRequest.class)
public class HttpRequest<T> {
    public static final TypeArg<HttpRequest> __TYPE_ARG = new TypeArg(obj -> new HttpRequest((io.vertx.ext.web.client.HttpRequest)obj), HttpRequest::getDelegate);
    private final io.vertx.ext.web.client.HttpRequest<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private MultiMap cached_0;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate, TypeArg<T> typeArg_0) {
        this.delegate = delegate;
        this.__typeArg_0 = typeArg_0;
    }

    public io.vertx.ext.web.client.HttpRequest getDelegate() {
        return this.delegate;
    }

    public HttpRequest<T> method(HttpMethod value) {
        this.delegate.method(value);
        return this;
    }

    public HttpRequest<T> port(int value) {
        this.delegate.port(value);
        return this;
    }

    public <U> HttpRequest<U> as(BodyCodec<U> responseCodec) {
        HttpRequest ret = HttpRequest.newInstance(this.delegate.as(responseCodec.getDelegate()), responseCodec.__typeArg_0);
        return ret;
    }

    public HttpRequest<T> host(String value) {
        this.delegate.host(value);
        return this;
    }

    public HttpRequest<T> virtualHost(String value) {
        this.delegate.virtualHost(value);
        return this;
    }

    public HttpRequest<T> uri(String value) {
        this.delegate.uri(value);
        return this;
    }

    public HttpRequest<T> putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpRequest<T> basicAuthentication(String id, String password) {
        this.delegate.basicAuthentication(id, password);
        return this;
    }

    public HttpRequest<T> basicAuthentication(Buffer id, Buffer password) {
        this.delegate.basicAuthentication(id.getDelegate(), password.getDelegate());
        return this;
    }

    public HttpRequest<T> bearerTokenAuthentication(String bearerToken) {
        this.delegate.bearerTokenAuthentication(bearerToken);
        return this;
    }

    public HttpRequest<T> ssl(boolean value) {
        this.delegate.ssl(value);
        return this;
    }

    public HttpRequest<T> timeout(long value) {
        this.delegate.timeout(value);
        return this;
    }

    public HttpRequest<T> addQueryParam(String paramName, String paramValue) {
        this.delegate.addQueryParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> setQueryParam(String paramName, String paramValue) {
        this.delegate.setQueryParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> followRedirects(boolean value) {
        this.delegate.followRedirects(value);
        return this;
    }

    public HttpRequest<T> expect(final Function<HttpResponse<Void>, ResponsePredicateResult> predicate) {
        this.delegate.expect((Function)new Function<io.vertx.ext.web.client.HttpResponse<Void>, io.vertx.ext.web.client.predicate.ResponsePredicateResult>(){

            @Override
            public io.vertx.ext.web.client.predicate.ResponsePredicateResult apply(io.vertx.ext.web.client.HttpResponse<Void> arg) {
                ResponsePredicateResult ret = (ResponsePredicateResult)predicate.apply(HttpResponse.newInstance(arg, TypeArg.unknown()));
                return ret.getDelegate();
            }
        });
        return this;
    }

    public HttpRequest<T> expect(ResponsePredicate predicate) {
        this.delegate.expect(predicate.getDelegate());
        return this;
    }

    public MultiMap queryParams() {
        MultiMap ret = MultiMap.newInstance(this.delegate.queryParams());
        return ret;
    }

    public HttpRequest<T> copy() {
        HttpRequest<T> ret = HttpRequest.newInstance(this.delegate.copy(), this.__typeArg_0);
        return ret;
    }

    public void sendStream(ReadStream<Buffer> body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendStream(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendStream(ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle(handler -> this.sendStream(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendStream(Flowable<Buffer> body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendStream(ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendStream(Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle(handler -> this.sendStream(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendStream(Observable<Buffer> body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendStream(ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendStream(Observable<Buffer> body) {
        return AsyncResultSingle.toSingle(handler -> this.sendStream(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendBuffer(Buffer body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendBuffer(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendBuffer(Buffer body) {
        return AsyncResultSingle.toSingle(handler -> this.sendBuffer(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendJsonObject(JsonObject body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendJsonObject(body, new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendJsonObject(JsonObject body) {
        return AsyncResultSingle.toSingle(handler -> this.sendJsonObject(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendJson(Object body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendJson(body, new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendJson(Object body) {
        return AsyncResultSingle.toSingle(handler -> this.sendJson(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendForm(MultiMap body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendForm(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendForm(MultiMap body) {
        return AsyncResultSingle.toSingle(handler -> this.sendForm(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendMultipartForm(MultipartForm body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendMultipartForm(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendMultipartForm(MultipartForm body) {
        return AsyncResultSingle.toSingle(handler -> this.sendMultipartForm(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void send(final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.send(new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSend() {
        return AsyncResultSingle.toSingle(handler -> this.send((Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg) {
        return arg != null ? new HttpRequest<T>(arg) : null;
    }

    public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new HttpRequest<T>(arg, __typeArg_T) : null;
    }
}

