/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.Future;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.core.Context.class)
public class Context {
    public static final TypeArg<Context> __TYPE_ARG = new TypeArg<Context>(obj -> new Context((io.vertx.core.Context)obj), Context::getDelegate);
    private final io.vertx.core.Context delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context that = (Context)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Context(io.vertx.core.Context delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.Context getDelegate() {
        return this.delegate;
    }

    public static boolean isOnWorkerThread() {
        boolean ret = io.vertx.core.Context.isOnWorkerThread();
        return ret;
    }

    public static boolean isOnEventLoopThread() {
        boolean ret = io.vertx.core.Context.isOnEventLoopThread();
        return ret;
    }

    public static boolean isOnVertxThread() {
        boolean ret = io.vertx.core.Context.isOnVertxThread();
        return ret;
    }

    public void runOnContext(Handler<Void> action) {
        this.delegate.runOnContext(action);
    }

    public <T> void executeBlocking(final Handler<Future<T>> blockingCodeHandler, boolean ordered, final Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>(){

            public void handle(io.vertx.core.Future<T> event) {
                blockingCodeHandler.handle(Future.newInstance(event, TypeArg.unknown()));
            }
        }, ordered, new Handler<AsyncResult<T>>(){

            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public <T> Single<T> rxExecuteBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered) {
        return new AsyncResultSingle(handler -> this.executeBlocking(blockingCodeHandler, ordered, (Handler)handler));
    }

    public <T> void executeBlocking(final Handler<Future<T>> blockingCodeHandler, final Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>(){

            public void handle(io.vertx.core.Future<T> event) {
                blockingCodeHandler.handle(Future.newInstance(event, TypeArg.unknown()));
            }
        }, new Handler<AsyncResult<T>>(){

            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public <T> Single<T> rxExecuteBlocking(Handler<Future<T>> blockingCodeHandler) {
        return new AsyncResultSingle(handler -> this.executeBlocking(blockingCodeHandler, (Handler)handler));
    }

    public String deploymentID() {
        String ret = this.delegate.deploymentID();
        return ret;
    }

    public JsonObject config() {
        JsonObject ret = this.delegate.config();
        return ret;
    }

    public List<String> processArgs() {
        List ret = this.delegate.processArgs();
        return ret;
    }

    public boolean isEventLoopContext() {
        boolean ret = this.delegate.isEventLoopContext();
        return ret;
    }

    public boolean isWorkerContext() {
        boolean ret = this.delegate.isWorkerContext();
        return ret;
    }

    public boolean isMultiThreadedWorkerContext() {
        boolean ret = this.delegate.isMultiThreadedWorkerContext();
        return ret;
    }

    public <T> T get(String key) {
        Object ret = this.delegate.get(key);
        return (T)ret;
    }

    public void put(String key, Object value) {
        this.delegate.put(key, value);
    }

    public boolean remove(String key) {
        boolean ret = this.delegate.remove(key);
        return ret;
    }

    public Vertx owner() {
        Vertx ret = Vertx.newInstance(this.delegate.owner());
        return ret;
    }

    public int getInstanceCount() {
        int ret = this.delegate.getInstanceCount();
        return ret;
    }

    public Context exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public static Context newInstance(io.vertx.core.Context arg) {
        return arg != null ? new Context(arg) : null;
    }
}

