/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.net;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import java.util.function.Function;

@RxGen(value=io.vertx.core.net.NetSocket.class)
public class NetSocket
implements ReadStream<io.vertx.reactivex.core.buffer.Buffer>,
WriteStream<io.vertx.reactivex.core.buffer.Buffer> {
    public static final TypeArg<NetSocket> __TYPE_ARG = new TypeArg<NetSocket>(obj -> new NetSocket((io.vertx.core.net.NetSocket)obj), NetSocket::getDelegate);
    private final io.vertx.core.net.NetSocket delegate;
    private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
    private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetSocket that = (NetSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetSocket(io.vertx.core.net.NetSocket delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.net.NetSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer t) {
        this.delegate.end((Object)t.getDelegate());
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public NetSocket handler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    public NetSocket pause() {
        this.delegate.pause();
        return this;
    }

    public NetSocket resume() {
        this.delegate.resume();
        return this;
    }

    public NetSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public NetSocket write(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public NetSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public String writeHandlerID() {
        String ret = this.delegate.writeHandlerID();
        return ret;
    }

    public NetSocket write(String str) {
        this.delegate.write(str);
        return this;
    }

    public NetSocket write(String str, String enc) {
        this.delegate.write(str, enc);
        return this;
    }

    public NetSocket sendFile(String filename) {
        this.delegate.sendFile(filename);
        return this;
    }

    public NetSocket sendFile(String filename, long offset) {
        this.delegate.sendFile(filename, offset);
        return this;
    }

    public NetSocket sendFile(String filename, long offset, long length) {
        this.delegate.sendFile(filename, offset, length);
        return this;
    }

    public NetSocket sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, resultHandler);
        return this;
    }

    public Completable rxSendFile(String filename) {
        return new AsyncResultCompletable((Handler<Handler<AsyncResult<Void>>>)((Handler)handler -> this.sendFile(filename, (Handler<AsyncResult<Void>>)handler)));
    }

    public NetSocket sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, resultHandler);
        return this;
    }

    public Completable rxSendFile(String filename, long offset) {
        return new AsyncResultCompletable((Handler<Handler<AsyncResult<Void>>>)((Handler)handler -> this.sendFile(filename, offset, (Handler<AsyncResult<Void>>)handler)));
    }

    public NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, length, resultHandler);
        return this;
    }

    public Completable rxSendFile(String filename, long offset, long length) {
        return new AsyncResultCompletable((Handler<Handler<AsyncResult<Void>>>)((Handler)handler -> this.sendFile(filename, offset, length, (Handler<AsyncResult<Void>>)handler)));
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    public void close() {
        this.delegate.close();
    }

    public NetSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public NetSocket upgradeToSsl(Handler<Void> handler) {
        this.delegate.upgradeToSsl(handler);
        return this;
    }

    public NetSocket upgradeToSsl(String serverName, Handler<Void> handler) {
        this.delegate.upgradeToSsl(serverName, handler);
        return this;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
        return arg != null ? new NetSocket(arg) : null;
    }
}

