/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.dns;

import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.dns.MxRecord;
import io.vertx.reactivex.core.dns.SrvRecord;
import io.vertx.reactivex.core.impl.AsyncResultMaybe;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import java.util.List;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.core.dns.DnsClient.class)
public class DnsClient {
    public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg<DnsClient>(obj -> new DnsClient((io.vertx.core.dns.DnsClient)obj), DnsClient::getDelegate);
    private final io.vertx.core.dns.DnsClient delegate;

    public DnsClient(io.vertx.core.dns.DnsClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.dns.DnsClient getDelegate() {
        return this.delegate;
    }

    public DnsClient lookup(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup(name, handler);
        return this;
    }

    public Maybe<String> rxLookup(String name) {
        return new AsyncResultMaybe<String>(handler -> this.lookup(name, (Handler<AsyncResult<String>>)handler));
    }

    public DnsClient lookup4(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup4(name, handler);
        return this;
    }

    public Maybe<String> rxLookup4(String name) {
        return new AsyncResultMaybe<String>(handler -> this.lookup4(name, (Handler<AsyncResult<String>>)handler));
    }

    public DnsClient lookup6(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup6(name, handler);
        return this;
    }

    public Maybe<String> rxLookup6(String name) {
        return new AsyncResultMaybe<String>(handler -> this.lookup6(name, (Handler<AsyncResult<String>>)handler));
    }

    public DnsClient resolveA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveA(name, handler);
        return this;
    }

    public Single<List<String>> rxResolveA(String name) {
        return new AsyncResultSingle<List<String>>(handler -> this.resolveA(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public DnsClient resolveAAAA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveAAAA(name, handler);
        return this;
    }

    public Single<List<String>> rxResolveAAAA(String name) {
        return new AsyncResultSingle<List<String>>(handler -> this.resolveAAAA(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public DnsClient resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveCNAME(name, handler);
        return this;
    }

    public Single<List<String>> rxResolveCNAME(String name) {
        return new AsyncResultSingle<List<String>>(handler -> this.resolveCNAME(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public DnsClient resolveMX(String name, final Handler<AsyncResult<List<MxRecord>>> handler) {
        this.delegate.resolveMX(name, (Handler)new Handler<AsyncResult<List<io.vertx.core.dns.MxRecord>>>(){

            public void handle(AsyncResult<List<io.vertx.core.dns.MxRecord>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> MxRecord.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<List<MxRecord>> rxResolveMX(String name) {
        return new AsyncResultSingle<List<MxRecord>>(handler -> this.resolveMX(name, (Handler<AsyncResult<List<MxRecord>>>)handler));
    }

    public DnsClient resolveTXT(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveTXT(name, handler);
        return this;
    }

    public Single<List<String>> rxResolveTXT(String name) {
        return new AsyncResultSingle<List<String>>(handler -> this.resolveTXT(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public DnsClient resolvePTR(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.resolvePTR(name, handler);
        return this;
    }

    public Maybe<String> rxResolvePTR(String name) {
        return new AsyncResultMaybe<String>(handler -> this.resolvePTR(name, (Handler<AsyncResult<String>>)handler));
    }

    public DnsClient resolveNS(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveNS(name, handler);
        return this;
    }

    public Single<List<String>> rxResolveNS(String name) {
        return new AsyncResultSingle<List<String>>(handler -> this.resolveNS(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public DnsClient resolveSRV(String name, final Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.delegate.resolveSRV(name, (Handler)new Handler<AsyncResult<List<io.vertx.core.dns.SrvRecord>>>(){

            public void handle(AsyncResult<List<io.vertx.core.dns.SrvRecord>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> SrvRecord.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<List<SrvRecord>> rxResolveSRV(String name) {
        return new AsyncResultSingle<List<SrvRecord>>(handler -> this.resolveSRV(name, (Handler<AsyncResult<List<SrvRecord>>>)handler));
    }

    public DnsClient reverseLookup(String ipaddress, Handler<AsyncResult<String>> handler) {
        this.delegate.reverseLookup(ipaddress, handler);
        return this;
    }

    public Maybe<String> rxReverseLookup(String ipaddress) {
        return new AsyncResultMaybe<String>(handler -> this.reverseLookup(ipaddress, (Handler<AsyncResult<String>>)handler));
    }

    public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
        return arg != null ? new DnsClient(arg) : null;
    }
}

