/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleTransformer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.SingleUnmarshaller;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

public class SingleHelper {
    public static <T> Single<T> toSingle(Consumer<Handler<AsyncResult<T>>> handler) {
        return AsyncResultSingle.toSingle(handler);
    }

    public static <T> SingleObserver<T> toObserver(final Handler<AsyncResult<T>> handler) {
        final AtomicBoolean completed = new AtomicBoolean();
        return new SingleObserver<T>(){

            public void onSubscribe(@NonNull Disposable d) {
            }

            public void onSuccess(@NonNull T item) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture(item));
                }
            }

            public void onError(Throwable error) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.failedFuture((Throwable)error));
                }
            }
        };
    }

    public static <T> SingleTransformer<Buffer, T> unmarshaller(Class<T> mappedType) {
        return new SingleUnmarshaller(Function.identity(), mappedType);
    }

    public static <T> SingleTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef) {
        return new SingleUnmarshaller(Function.identity(), mappedTypeRef);
    }

    public static <T> SingleTransformer<Buffer, T> unmarshaller(Class<T> mappedType, ObjectCodec mapper) {
        return new SingleUnmarshaller(Function.identity(), mappedType, mapper);
    }

    public static <T> SingleTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef, ObjectCodec mapper) {
        return new SingleUnmarshaller(Function.identity(), mappedTypeRef, mapper);
    }
}

