/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5.rxjava3;

import io.vertx.core.VertxException;
import io.vertx.junit5.ParameterClosingConsumer;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxExtensionParameterProvider;
import io.vertx.rxjava3.core.Vertx;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;

public class VertxParameterProvider
implements VertxExtensionParameterProvider<Vertx> {
    public Class<Vertx> type() {
        return Vertx.class;
    }

    public String key() {
        return "Vertx";
    }

    public Vertx newInstance(ExtensionContext extensionContext, ParameterContext parameterContext) {
        return Vertx.vertx();
    }

    public ParameterClosingConsumer<Vertx> parameterClosingConsumer() {
        return vertx -> {
            try {
                if (!vertx.rxClose().blockingAwait(30L, VertxExtension.DEFAULT_TIMEOUT_UNIT)) {
                    throw new TimeoutException("Closing the Vertx context timed out");
                }
            }
            catch (Throwable err) {
                if (err instanceof RuntimeException) {
                    throw new VertxException(err.getCause());
                }
                if (err instanceof Exception) {
                    throw err;
                }
                throw new VertxException(err);
            }
        };
    }
}

