/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.grpc.transcoding.impl.config.HttpVariableBinding;
import java.util.List;

public class MessageWeaver {
    public static Buffer weaveRequestMessage(Buffer message, List<HttpVariableBinding> bindings, String transcodingRequestBody) throws DecodeException {
        if (bindings.isEmpty() && transcodingRequestBody == null) {
            return message;
        }
        JsonObject result = MessageWeaver.weaveRequestMessage2(message, bindings, transcodingRequestBody);
        BufferInternal buffer = BufferInternal.buffer();
        buffer.appendString(result.encode());
        return buffer;
    }

    public static JsonObject weaveRequestMessage2(Buffer message, List<HttpVariableBinding> bindings, String transcodingRequestBody) throws DecodeException {
        JsonObject messageJson;
        JsonObject result = new JsonObject();
        for (HttpVariableBinding binding : bindings) {
            JsonObject current = result;
            List<String> fieldPath = binding.getFieldPath();
            for (int i = 0; i < fieldPath.size() - 1; ++i) {
                Object fieldValue;
                String fieldName = fieldPath.get(i);
                if (!current.containsKey(fieldName)) {
                    current.put(fieldName, (Object)new JsonObject());
                }
                if (!((fieldValue = current.getValue(fieldName)) instanceof JsonObject)) {
                    current.put(fieldName, (Object)new JsonObject());
                }
                current = current.getJsonObject(fieldName);
            }
            current.put(fieldPath.get(fieldPath.size() - 1), (Object)binding.getValue());
        }
        if (transcodingRequestBody != null && !transcodingRequestBody.isEmpty()) {
            JsonObject jsonObject = messageJson = message.toString().isBlank() ? new JsonObject() : new JsonObject(message.toString());
            if (!messageJson.isEmpty()) {
                if (transcodingRequestBody.equals("*")) {
                    result.mergeIn(messageJson);
                } else {
                    JsonObject current = result;
                    String[] path = transcodingRequestBody.split("\\.");
                    for (int i = 0; i < path.length - 1; ++i) {
                        String fieldName = path[i];
                        if (!current.containsKey(fieldName)) {
                            current.put(fieldName, (Object)new JsonObject());
                        }
                        current = current.getJsonObject(fieldName);
                    }
                    current.put(path[path.length - 1], (Object)messageJson);
                }
            }
        } else {
            JsonObject jsonObject = messageJson = message.toString().isBlank() ? new JsonObject() : message.toJsonObject();
            if (!messageJson.isEmpty()) {
                result.mergeIn(messageJson, true);
            }
        }
        return result;
    }

    public static Buffer weaveResponseMessage(Buffer message, String transcodingResponseBody) {
        if (transcodingResponseBody == null || transcodingResponseBody.isEmpty()) {
            return message;
        }
        JsonObject json = message.toJsonObject();
        if (transcodingResponseBody.equals("*")) {
            return message;
        }
        String[] path = transcodingResponseBody.split("\\.");
        JsonObject current = json;
        for (String field : path) {
            Object value;
            if (current.containsKey(field)) {
                value = current.getValue(field);
                if (!(value instanceof JsonObject)) {
                    throw new IllegalStateException("Invalid transcodingResponseBody path: " + transcodingResponseBody);
                }
            } else {
                throw new IllegalStateException("Invalid transcodingResponseBody path: " + transcodingResponseBody);
            }
            current = (JsonObject)value;
        }
        return Buffer.buffer((String)current.encode());
    }
}

