/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl;

import io.vertx.grpc.transcoding.impl.PathMatcherBuilder;
import io.vertx.grpc.transcoding.impl.PathMatcherLookupResult;
import io.vertx.grpc.transcoding.impl.PathMatcherMethodData;
import io.vertx.grpc.transcoding.impl.PathMatcherNode;
import io.vertx.grpc.transcoding.impl.PathMatcherUtility;
import io.vertx.grpc.transcoding.impl.PercentEncoding;
import io.vertx.grpc.transcoding.impl.config.HttpVariableBinding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PathMatcher {
    private final PathMatcherNode root;
    private final Set<String> customVerbs = new HashSet<String>();
    private final List<PathMatcherMethodData> methods = new ArrayList<PathMatcherMethodData>();
    private final PercentEncoding.UrlUnescapeSpec pathUnescapeSpec;
    private final boolean queryParamUnescapePlus;
    private final boolean matchUnregisteredCustomVerb;

    protected PathMatcher(PathMatcherBuilder builder) {
        this.root = builder.root().clone();
        this.customVerbs.addAll(builder.customVerbs());
        this.methods.addAll(builder.methodData());
        this.pathUnescapeSpec = builder.getUrlUnescapeSpec();
        this.queryParamUnescapePlus = builder.getQueryParamUnescapePlus();
        this.matchUnregisteredCustomVerb = builder.getMatchUnregisteredCustomVerb();
    }

    public String lookup(String httpMethod, String path) {
        PathMatcherLookupResult result = this.lookup(httpMethod, path, "");
        if (result == null) {
            return null;
        }
        return result.getMethod();
    }

    public PathMatcherLookupResult lookup(String httpMethod, String path, String queryParams) {
        String verb = PathMatcherUtility.extractVerb(path, this.customVerbs, this.matchUnregisteredCustomVerb);
        List<String> parts = PathMatcherUtility.extractRequestParts(path, this.customVerbs, this.matchUnregisteredCustomVerb);
        if (this.root == null) {
            return null;
        }
        PathMatcherNode.PathMatcherNodeLookupResult result = PathMatcherUtility.lookupInPathMatcherNode(this.root, parts, httpMethod + verb);
        if (result.getData() == null || result.isMultiple()) {
            return null;
        }
        PathMatcherMethodData data = (PathMatcherMethodData)result.getData();
        String method = data.getMethod();
        ArrayList<HttpVariableBinding> variableBindings = new ArrayList<HttpVariableBinding>();
        String bodyFieldPath = data.getBodyFieldPath();
        variableBindings.addAll(PathMatcherUtility.extractBindingsFromPath(data.getVariables(), parts, this.pathUnescapeSpec));
        variableBindings.addAll(PathMatcherUtility.extractBindingsFromQueryParameters(queryParams, data.getSystemQueryParameterNames(), this.queryParamUnescapePlus));
        return new PathMatcherLookupResult(method, variableBindings, bodyFieldPath);
    }
}

