/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl.config;

import io.vertx.grpc.transcoding.impl.config.HttpTemplateVariable;
import java.util.ArrayList;
import java.util.List;

public class HttpTemplateParser {
    public static final String SINGLE_PARAMETER_KEY = "/.";
    public static final String WILD_CARD_PATH_PART_KEY = "*";
    public static final String WILD_CARD_PATH_KEY = "**";
    private final String templateString;
    private final List<String> segments = new ArrayList<String>();
    private final List<HttpTemplateVariable> variables = new ArrayList<HttpTemplateVariable>();
    private String verb = "";
    private int tokenBegin;
    private int tokenEnd;
    private boolean parsingVariable;

    public HttpTemplateParser(String templateString) {
        this.templateString = templateString;
        this.tokenBegin = 0;
        this.tokenEnd = 0;
        this.parsingVariable = false;
    }

    public boolean parse() {
        if (!this.parseTemplate() || !this.allInputConsumed()) {
            return false;
        }
        this.finalizeVariables();
        return true;
    }

    public List<String> segments() {
        return this.segments;
    }

    public String verb() {
        return this.verb;
    }

    public List<HttpTemplateVariable> variables() {
        return this.variables;
    }

    public boolean validateParts() {
        boolean foundWildcardPath = false;
        for (String segment : this.segments) {
            if (!foundWildcardPath) {
                if (!segment.equals(WILD_CARD_PATH_KEY)) continue;
                foundWildcardPath = true;
                continue;
            }
            if (!segment.equals(SINGLE_PARAMETER_KEY) && !segment.equals(WILD_CARD_PATH_PART_KEY) && !segment.equals(WILD_CARD_PATH_KEY)) continue;
            return false;
        }
        return true;
    }

    private boolean parseTemplate() {
        if (!this.consumeCharacter('/')) {
            return false;
        }
        if (!this.parseSegments()) {
            return false;
        }
        if (this.hasMoreCharacters() && this.currentChar() == ':') {
            return this.parseVerb();
        }
        return true;
    }

    private boolean parseSegments() {
        do {
            if (this.parseSegment()) continue;
            return false;
        } while (this.consumeCharacter('/'));
        return true;
    }

    private boolean parseSegment() {
        if (!this.hasMoreCharacters()) {
            return false;
        }
        switch (this.currentChar()) {
            case '*': {
                this.consumeCharacter('*');
                if (this.consumeCharacter('*')) {
                    this.segments.add(WILD_CARD_PATH_KEY);
                    if (this.parsingVariable) {
                        return this.markVariableAsWildcard();
                    }
                } else {
                    this.segments.add(WILD_CARD_PATH_PART_KEY);
                }
                return true;
            }
            case '{': {
                return this.parseVariable();
            }
        }
        return this.parseLiteralSegment();
    }

    private boolean parseVariable() {
        if (!this.consumeCharacter('{')) {
            return false;
        }
        if (!this.beginVariableParsing()) {
            return false;
        }
        if (!this.parseFieldPath()) {
            return false;
        }
        if (this.consumeCharacter('=')) {
            if (!this.parseSegments()) {
                return false;
            }
        } else {
            this.segments.add(WILD_CARD_PATH_PART_KEY);
        }
        if (!this.endVariableParsing()) {
            return false;
        }
        return this.consumeCharacter('}');
    }

    private boolean parseLiteralSegment() {
        StringBuilder literalBuilder = new StringBuilder();
        if (!this.parseLiteral(literalBuilder)) {
            return false;
        }
        this.segments.add(literalBuilder.toString());
        return true;
    }

    private boolean parseFieldPath() {
        do {
            if (this.parseIdentifier()) continue;
            return false;
        } while (this.consumeCharacter('.'));
        return true;
    }

    private boolean parseVerb() {
        if (!this.consumeCharacter(':')) {
            return false;
        }
        StringBuilder verbBuilder = new StringBuilder();
        if (!this.parseLiteral(verbBuilder)) {
            return false;
        }
        this.verb = verbBuilder.toString();
        return true;
    }

    private boolean parseIdentifier() {
        StringBuilder identifierBuilder = new StringBuilder();
        boolean hasContent = false;
        while (this.advanceToken()) {
            char currentCharacter = this.currentChar();
            switch (currentCharacter) {
                case '.': 
                case '=': 
                case '}': {
                    return hasContent && this.addFieldPathIdentifier(identifierBuilder.toString());
                }
            }
            this.consumeCharacter(currentCharacter);
            identifierBuilder.append(currentCharacter);
            hasContent = true;
        }
        return hasContent && this.addFieldPathIdentifier(identifierBuilder.toString());
    }

    private boolean parseLiteral(StringBuilder literalBuilder) {
        if (!this.hasMoreCharacters()) {
            return false;
        }
        boolean hasContent = false;
        do {
            char currentCharacter = this.currentChar();
            switch (currentCharacter) {
                case '/': 
                case ':': 
                case '}': {
                    return hasContent;
                }
            }
            this.consumeCharacter(currentCharacter);
            literalBuilder.append(currentCharacter);
            hasContent = true;
        } while (this.advanceToken());
        return hasContent;
    }

    private boolean consumeCharacter(char expected) {
        if (this.tokenBegin >= this.tokenEnd && !this.advanceToken()) {
            return false;
        }
        if (this.currentChar() != expected) {
            return false;
        }
        ++this.tokenBegin;
        return true;
    }

    private boolean allInputConsumed() {
        return this.tokenBegin >= this.templateString.length();
    }

    private boolean hasMoreCharacters() {
        return this.tokenBegin < this.tokenEnd || this.advanceToken();
    }

    private boolean advanceToken() {
        if (this.tokenEnd < this.templateString.length()) {
            ++this.tokenEnd;
            return true;
        }
        return false;
    }

    private char currentChar() {
        return this.tokenBegin < this.tokenEnd && this.tokenEnd <= this.templateString.length() ? this.templateString.charAt(this.tokenEnd - 1) : (char)'\uffff';
    }

    private HttpTemplateVariable getCurrentVariable() {
        return this.variables.get(this.variables.size() - 1);
    }

    private boolean beginVariableParsing() {
        if (!this.parsingVariable) {
            this.variables.add(new HttpTemplateVariable());
            this.getCurrentVariable().setStartSegment(this.segments.size());
            this.getCurrentVariable().setWildcardPath(false);
            this.parsingVariable = true;
            return true;
        }
        return false;
    }

    private boolean endVariableParsing() {
        if (this.parsingVariable && !this.variables.isEmpty()) {
            HttpTemplateVariable variable = this.getCurrentVariable();
            variable.setEndSegment(this.segments.size());
            this.parsingVariable = false;
            return this.validateVariable(variable);
        }
        return false;
    }

    private boolean addFieldPathIdentifier(String identifier) {
        if (this.parsingVariable && !this.variables.isEmpty()) {
            this.getCurrentVariable().getFieldPath().add(identifier);
            return true;
        }
        return false;
    }

    private boolean markVariableAsWildcard() {
        if (this.parsingVariable && !this.variables.isEmpty()) {
            this.getCurrentVariable().setWildcardPath(true);
            return true;
        }
        return false;
    }

    private boolean validateVariable(HttpTemplateVariable variable) {
        return !variable.getFieldPath().isEmpty() && variable.getStartSegment() < variable.getEndSegment() && variable.getEndSegment() <= this.segments.size();
    }

    private void finalizeVariables() {
        for (HttpTemplateVariable variable : this.variables) {
            if (!variable.hasWildcardPath()) continue;
            variable.setEndSegment(variable.getEndSegment() - this.segments.size() - 1);
        }
    }
}

