/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl.config;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.grpc.transcoding.impl.config.HttpTemplateParser;
import io.vertx.grpc.transcoding.impl.config.HttpTemplateVariable;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class HttpTemplate {
    private final List<String> segments;
    private final String verb;
    private final List<HttpTemplateVariable> variables;

    public HttpTemplate(List<String> segments, String verb, List<HttpTemplateVariable> variables) {
        this.segments = segments;
        this.verb = verb;
        this.variables = variables;
    }

    public static HttpTemplate parse(String template) {
        if (template.equals("/")) {
            return new HttpTemplate(new ArrayList<String>(), "", new ArrayList<HttpTemplateVariable>());
        }
        HttpTemplateParser parser = new HttpTemplateParser(template);
        if (!parser.parse() || !parser.validateParts()) {
            return null;
        }
        return new HttpTemplate(parser.segments(), parser.verb(), parser.variables());
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public String getVerb() {
        return this.verb;
    }

    public List<HttpTemplateVariable> getVariables() {
        return this.variables;
    }
}

