/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.json.DecodeException;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.GrpcMessageDeframer;
import io.vertx.grpc.common.impl.GrpcMethodCall;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;
import io.vertx.grpc.transcoding.impl.MessageWeaver;
import io.vertx.grpc.transcoding.impl.TranscodingMessageDeframer;
import io.vertx.grpc.transcoding.impl.config.HttpVariableBinding;
import java.util.List;

public class TranscodingGrpcServerRequest<Req, Resp>
extends GrpcServerRequestImpl<Req, Resp> {
    final String transcodingRequestBody;
    final List<HttpVariableBinding> bindings;

    public TranscodingGrpcServerRequest(ContextInternal context, HttpServerRequest httpRequest, final String transcodingRequestBody, final List<HttpVariableBinding> bindings, final GrpcMessageDecoder<Req> messageDecoder, GrpcMethodCall methodCall) {
        super(context, GrpcProtocol.TRANSCODING, WireFormat.JSON, httpRequest, (GrpcMessageDeframer)new TranscodingMessageDeframer(), new GrpcMessageDecoder<Req>(){

            public Req decode(GrpcMessage msg) throws CodecException {
                Buffer transcoded;
                try {
                    transcoded = MessageWeaver.weaveRequestMessage(msg.payload(), bindings, transcodingRequestBody);
                }
                catch (DecodeException e) {
                    throw new CodecException((Throwable)e);
                }
                return messageDecoder.decode(GrpcMessage.message((String)"identity", (WireFormat)WireFormat.JSON, (Buffer)transcoded));
            }

            public WireFormat format() {
                return messageDecoder.format();
            }
        }, methodCall);
        this.transcodingRequestBody = transcodingRequestBody;
        this.bindings = bindings;
    }
}

