/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl;

import java.util.regex.Pattern;

public class PercentEncoding {
    private static final Pattern ESCAPE_STRING_PATTERN = Pattern.compile("[^a-zA-Z0-9-_.~]");

    private static boolean isReservedChar(char c) {
        switch (c) {
            case '!': 
            case '#': 
            case '$': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': 
            case '[': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    private static boolean asciiIsxdigit(char c) {
        return 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F' || '0' <= c && c <= '9';
    }

    private static int hexDigitToInt(char c) {
        int x = c;
        if (x > 57) {
            x += 9;
        }
        return x & 0xF;
    }

    private static int getEscapedChar(String src, int i, UrlUnescapeSpec unescapeSpec, boolean unescapePlus, char[] out) {
        if (unescapePlus && src.charAt(i) == '+') {
            out[0] = 32;
            return 1;
        }
        if (i + 2 < src.length() && src.charAt(i) == '%' && PercentEncoding.asciiIsxdigit(src.charAt(i + 1)) && PercentEncoding.asciiIsxdigit(src.charAt(i + 2))) {
            char c = (char)(PercentEncoding.hexDigitToInt(src.charAt(i + 1)) << 4 | PercentEncoding.hexDigitToInt(src.charAt(i + 2)));
            switch (unescapeSpec) {
                case ALL_CHARACTERS_EXCEPT_RESERVED: {
                    if (!PercentEncoding.isReservedChar(c)) break;
                    return 0;
                }
                case ALL_CHARACTERS_EXCEPT_SLASH: {
                    if (c != '/') break;
                    return 0;
                }
            }
            out[0] = c;
            return 3;
        }
        return 0;
    }

    public static boolean isUrlEscapedString(String part, UrlUnescapeSpec unescapeSpec, boolean unescapePlus) {
        char[] ch = new char[1];
        for (int i = 0; i < part.length(); ++i) {
            if (PercentEncoding.getEscapedChar(part, i, unescapeSpec, unescapePlus, ch) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isUrlEscapedString(String part) {
        return PercentEncoding.isUrlEscapedString(part, UrlUnescapeSpec.ALL_CHARACTERS, false);
    }

    public static String urlUnescapeString(String part, UrlUnescapeSpec unescapeSpec, boolean unescapePlus) {
        if (!PercentEncoding.isUrlEscapedString(part, unescapeSpec, unescapePlus)) {
            return part;
        }
        StringBuilder unescaped = new StringBuilder(part.length());
        char[] ch = new char[1];
        int i = 0;
        while (i < part.length()) {
            int skip = PercentEncoding.getEscapedChar(part, i, unescapeSpec, unescapePlus, ch);
            if (skip > 0) {
                unescaped.append(ch[0]);
                i += skip;
                continue;
            }
            unescaped.append(part.charAt(i));
            ++i;
        }
        return unescaped.toString();
    }

    private static String urlUnescapeString(String part) {
        return PercentEncoding.urlUnescapeString(part, UrlUnescapeSpec.ALL_CHARACTERS, false);
    }

    private static String urlEscapeString(String str) {
        return ESCAPE_STRING_PATTERN.matcher(str).replaceAll(m -> "%" + Integer.toHexString(m.group().charAt(0)).toUpperCase());
    }

    public static enum UrlUnescapeSpec {
        ALL_CHARACTERS_EXCEPT_RESERVED,
        ALL_CHARACTERS_EXCEPT_SLASH,
        ALL_CHARACTERS;

    }
}

