/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor;

import java.lang.reflect.TypeVariable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;

public abstract class TypeParamInfo {
    protected final int index;
    protected final String name;

    public static TypeParamInfo create(TypeVariable typeVariable) {
        Object decl = typeVariable.getGenericDeclaration();
        TypeVariable<?>[] typeParams = decl.getTypeParameters();
        for (int index = 0; index < typeParams.length; ++index) {
            if (!typeParams[index].equals(typeVariable)) continue;
            if (decl instanceof java.lang.Class) {
                java.lang.Class classDecl = (java.lang.Class)decl;
                return new Class(classDecl.getName(), index, typeVariable.getName());
            }
            if (decl instanceof java.lang.reflect.Method) {
                java.lang.reflect.Method methodDecl = (java.lang.reflect.Method)decl;
                return new Method(methodDecl.getDeclaringClass().getName(), methodDecl.getName(), index, typeVariable.getName());
            }
            throw new UnsupportedOperationException();
        }
        throw new AssertionError();
    }

    public static TypeParamInfo create(TypeParameterElement paramElt) {
        Parameterizable genericElt = (Parameterizable)paramElt.getGenericElement();
        int index = genericElt.getTypeParameters().indexOf(paramElt);
        switch (genericElt.getKind()) {
            case CLASS: 
            case INTERFACE: {
                TypeElement typeElt = (TypeElement)genericElt;
                return new Class(typeElt.getQualifiedName().toString(), index, paramElt.getSimpleName().toString());
            }
            case METHOD: {
                ExecutableElement methodElt = (ExecutableElement)genericElt;
                TypeElement typeElt = (TypeElement)methodElt.getEnclosingElement();
                return new Method(typeElt.getQualifiedName().toString(), methodElt.getSimpleName().toString(), index, paramElt.getSimpleName().toString());
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)genericElt.getKind()));
    }

    public TypeParamInfo(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public abstract boolean isMethod();

    public boolean isClass() {
        return !this.isMethod();
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public static class Method
    extends TypeParamInfo {
        private final String typeName;
        private final String methodName;

        public Method(String typeName, String methodName, int index, String name) {
            super(index, name);
            this.typeName = typeName;
            this.methodName = methodName;
        }

        @Override
        public boolean isMethod() {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Method) {
                Method that = (Method)obj;
                return this.typeName.equals(that.typeName) && this.methodName.equals(that.methodName) && this.index == that.getIndex();
            }
            return false;
        }

        public String toString() {
            return "TypeParamInfo.Method[name=" + this.name + ",typeName=" + this.typeName + ",methodName" + this.methodName + "]";
        }
    }

    public static class Class
    extends TypeParamInfo {
        private final String typeName;

        public Class(String typeName, int index, String name) {
            super(index, name);
            this.typeName = typeName;
        }

        @Override
        public boolean isMethod() {
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Class) {
                Class that = (Class)obj;
                return this.typeName.equals(that.typeName) && this.index == that.getIndex();
            }
            return false;
        }

        public String toString() {
            return "TypeParamInfo.Class[name=" + this.name + ",typeName=" + this.typeName + "]";
        }
    }
}

