/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.net.NetClientInternal;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.ConnectOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.Metrics;
import java.lang.ref.Cleaner;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class CleanableNetClient
implements NetClientInternal {
    private final NetClientInternal client;
    private final Cleaner.Cleanable cleanable;
    private final Action action;

    public CleanableNetClient(NetClientInternal client, Cleaner cleaner) {
        this.action = new Action(client);
        this.client = client;
        this.cleanable = cleaner.register(this, this.action);
    }

    public NetClientInternal unwrap() {
        return this.client;
    }

    @Override
    public Future<NetSocket> connect(int port, String host) {
        return this.client.connect(port, host);
    }

    @Override
    public Future<NetSocket> connect(int port, String host, String serverName) {
        return this.client.connect(port, host, serverName);
    }

    @Override
    public Future<NetSocket> connect(SocketAddress remoteAddress) {
        return this.client.connect(remoteAddress);
    }

    @Override
    public Future<NetSocket> connect(SocketAddress remoteAddress, String serverName) {
        return this.client.connect(remoteAddress, serverName);
    }

    @Override
    public Future<NetSocket> connect(ConnectOptions connectOptions) {
        return this.client.connect(connectOptions);
    }

    @Override
    public Future<Boolean> updateSSLOptions(ClientSSLOptions options, boolean force) {
        return this.client.updateSSLOptions(options, force);
    }

    @Override
    public void close(Completable<Void> completion) {
        this.client.close(completion);
    }

    @Override
    public void connectInternal(ConnectOptions connectOptions, Promise<NetSocket> connectHandler, ContextInternal context) {
        this.client.connectInternal(connectOptions, connectHandler, context);
    }

    @Override
    public Future<Void> closeFuture() {
        return this.client.closeFuture();
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout: " + timeout);
        }
        this.action.timeout = timeout;
        this.action.timeUnit = Objects.requireNonNull(unit);
        this.cleanable.clean();
        return this.client.closeFuture();
    }

    @Override
    public Metrics getMetrics() {
        return this.client.getMetrics();
    }

    static class Action
    implements Runnable {
        private final NetClientInternal client;
        private long timeout = 30L;
        private TimeUnit timeUnit = TimeUnit.SECONDS;

        private Action(NetClientInternal client) {
            this.client = client;
        }

        @Override
        public void run() {
            this.client.shutdown(this.timeout, this.timeUnit);
        }
    }
}

