/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.Completable;
import io.vertx.core.impl.future.Operation;
import io.vertx.core.internal.ContextInternal;
import java.util.function.Function;

class Mapping<T, U>
extends Operation<U>
implements Completable<T> {
    private final Function<? super T, U> successMapper;

    Mapping(ContextInternal context, Function<? super T, U> successMapper) {
        super(context);
        this.successMapper = successMapper;
    }

    @Override
    public void complete(T value, Throwable failure) {
        Object result;
        if (failure == null) {
            try {
                result = this.successMapper.apply(value);
            }
            catch (Throwable e) {
                result = null;
                failure = e;
            }
        } else {
            result = null;
        }
        this.completeInternal(result, failure);
    }
}

