/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.vertx.core.dns.impl.netty.DnsMessage;
import io.vertx.core.dns.impl.netty.DnsResponseDecoder;
import io.vertx.core.dns.impl.netty.DnsResponseHeader;

public class DnsResponse
extends DnsMessage<DnsResponseHeader>
implements ByteBufHolder {
    private final ByteBuf rawPacket;
    private final int originalIndex;

    public DnsResponse(ByteBuf rawPacket) {
        this.rawPacket = rawPacket;
        this.originalIndex = rawPacket.readerIndex();
    }

    public ByteBuf content() {
        return this.rawPacket;
    }

    public int refCnt() {
        return this.rawPacket.refCnt();
    }

    public boolean release() {
        return this.rawPacket.release();
    }

    public DnsResponse copy() {
        return this.replace(this.rawPacket.copy());
    }

    public DnsResponse duplicate() {
        return this.replace(this.rawPacket.duplicate());
    }

    public DnsResponse retain() {
        this.rawPacket.retain();
        return this;
    }

    public DnsResponse retain(int increment) {
        this.rawPacket.retain();
        return this;
    }

    public DnsResponse retainedDuplicate() {
        return this.replace(this.rawPacket.retainedDuplicate());
    }

    public DnsResponse replace(ByteBuf content) {
        return DnsResponseDecoder.decodeResponse(content, content.alloc());
    }

    public boolean release(int decrement) {
        return this.rawPacket.release();
    }

    public int originalIndex() {
        return this.originalIndex;
    }

    public ByteBufHolder touch() {
        this.rawPacket.touch();
        return this;
    }

    public ByteBufHolder touch(Object hint) {
        this.rawPacket.touch(hint);
        return this;
    }
}

