/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.impl;

import io.vertx.core.cli.Argument;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.InvalidValueException;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.TypedArgument;
import io.vertx.core.cli.TypedOption;
import io.vertx.core.cli.converters.Converters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultCommandLine
implements CommandLine {
    protected final CLI cli;
    protected List<String> allArgs = new ArrayList<String>();
    protected Map<Option, List<String>> optionValues = new HashMap<Option, List<String>>();
    protected List<Option> optionsSeenInCommandLine = new ArrayList<Option>();
    protected Map<Argument, List<String>> argumentValues = new HashMap<Argument, List<String>>();
    protected boolean valid;

    public DefaultCommandLine(CLI cli) {
        this.cli = cli;
    }

    @Override
    public CLI cli() {
        return this.cli;
    }

    @Override
    public List<String> allArguments() {
        return this.allArgs;
    }

    public CommandLine addArgumentValue(String argument) {
        this.allArgs.add(argument);
        return this;
    }

    @Override
    public <T> T getOptionValue(String name) {
        Option option = this.cli.getOption(name);
        if (option == null) {
            return null;
        }
        if (option instanceof TypedOption) {
            return this.getValue((TypedOption)option);
        }
        return (T)this.getRawValueForOption(option);
    }

    @Override
    public boolean isFlagEnabled(String name) {
        Option option = this.cli.getOption(name);
        if (option == null) {
            throw new IllegalArgumentException("Cannot find the option '" + name + "'");
        }
        if (option.isFlag()) {
            return this.optionsSeenInCommandLine.contains(option);
        }
        throw new IllegalStateException("Cannot retrieve the flag value on a non-flag option (" + name + ")");
    }

    @Override
    public <T> List<T> getOptionValues(String name) {
        Option option = this.cli.getOption(name);
        if (option == null) {
            return null;
        }
        if (option instanceof TypedOption) {
            TypedOption typed = (TypedOption)option;
            if (typed.isParsedAsList()) {
                return DefaultCommandLine.createFromList(this.getRawValueForOption(option), typed);
            }
            return this.getRawValuesForOption(option).stream().map(s -> DefaultCommandLine.create(s, typed)).collect(Collectors.toList());
        }
        return this.getRawValuesForOption(option);
    }

    @Override
    public <T> List<T> getArgumentValues(int index) {
        Argument argument = this.cli.getArgument(index);
        if (argument == null) {
            return null;
        }
        if (argument instanceof TypedArgument) {
            TypedArgument typed = (TypedArgument)argument;
            return this.getRawValuesForArgument(typed).stream().map(s -> DefaultCommandLine.create(s, typed)).collect(Collectors.toList());
        }
        return this.getRawValuesForArgument(argument);
    }

    @Override
    public <T> T getArgumentValue(String name) {
        Argument arg = this.cli.getArgument(name);
        if (arg == null) {
            return null;
        }
        return this.getArgumentValue(arg.getIndex());
    }

    @Override
    public <T> T getArgumentValue(int index) {
        Argument arg = this.cli.getArgument(index);
        if (arg == null) {
            return null;
        }
        if (arg instanceof TypedArgument) {
            return DefaultCommandLine.create(this.getRawValueForArgument(arg), (TypedArgument)arg);
        }
        return (T)this.getRawValueForArgument(arg);
    }

    @Override
    public boolean isOptionAssigned(Option option) {
        return !this.getRawValuesForOption(option).isEmpty();
    }

    @Override
    public List<String> getRawValuesForOption(Option option) {
        List<String> list = this.optionValues.get(option);
        if (list != null) {
            return list.stream().map(Object::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getRawValuesForArgument(Argument argument) {
        List<String> list = this.argumentValues.get(argument);
        if (list != null) {
            return list.stream().map(Object::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public DefaultCommandLine addRawValue(Option option, String value) {
        if (!this.acceptMoreValues(option) && !option.isFlag()) {
            throw new CLIException("The option " + option.getName() + " does not accept value or has " + "already been set");
        }
        if (!option.getChoices().isEmpty() && !option.getChoices().contains(value)) {
            throw new InvalidValueException(option, value);
        }
        List<String> list = this.optionValues.get(option);
        if (list == null) {
            list = new ArrayList<String>();
            this.optionValues.put(option, list);
        }
        list.add(value);
        return this;
    }

    @Override
    public String getRawValueForOption(Option option) {
        if (this.isOptionAssigned(option)) {
            return this.getRawValuesForOption(option).get(0);
        }
        return option.getDefaultValue();
    }

    @Override
    public boolean acceptMoreValues(Option option) {
        return option.isMultiValued() || option.isSingleValued() && !this.isOptionAssigned(option);
    }

    @Override
    public String getRawValueForArgument(Argument arg) {
        List<String> values = this.argumentValues.get(arg);
        if (values == null || values.isEmpty()) {
            return arg.getDefaultValue();
        }
        return values.get(0).toString();
    }

    public DefaultCommandLine setRawValue(Argument arg, String rawValue) {
        List<String> list = this.argumentValues.get(arg);
        if (list == null) {
            list = new ArrayList<String>();
            this.argumentValues.put(arg, list);
        }
        list.add(rawValue);
        return this;
    }

    @Override
    public boolean isArgumentAssigned(Argument arg) {
        return this.argumentValues.get(arg) != null;
    }

    public DefaultCommandLine setSeenInCommandLine(Option option) {
        this.optionsSeenInCommandLine.add(option);
        return this;
    }

    @Override
    public boolean isSeenInCommandLine(Option option) {
        return this.optionsSeenInCommandLine.contains(option);
    }

    private <T> T getValue(TypedOption<T> option) {
        if (this.isOptionAssigned(option)) {
            return DefaultCommandLine.create(this.getRawValueForOption(option), option);
        }
        if (option.getDefaultValue() != null) {
            return DefaultCommandLine.create(this.getRawValueForOption(option), option);
        }
        if (option.isFlag() || this.isBoolean(option)) {
            try {
                if (this.isSeenInCommandLine(option)) {
                    return (T)Boolean.TRUE;
                }
                return (T)Boolean.FALSE;
            }
            catch (InvalidValueException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    private boolean isBoolean(TypedOption option) {
        Class type = option.getType();
        return type == Boolean.TYPE || type == Boolean.class;
    }

    public static <T> T create(String value, TypedArgument<T> argument) {
        Objects.requireNonNull(argument);
        if (value == null) {
            value = argument.getDefaultValue();
        }
        if (value == null) {
            return null;
        }
        try {
            if (argument.getConverter() != null) {
                return Converters.create(value, argument.getConverter());
            }
            return Converters.create(argument.getType(), value);
        }
        catch (Exception e) {
            throw new InvalidValueException(argument, value, e);
        }
    }

    public static <T> T create(String value, TypedOption<T> option) {
        Objects.requireNonNull(option);
        if (value == null) {
            value = option.getDefaultValue();
        }
        if (value == null) {
            return null;
        }
        try {
            if (option.getConverter() != null) {
                return Converters.create(value, option.getConverter());
            }
            return Converters.create(option.getType(), value);
        }
        catch (Exception e) {
            throw new InvalidValueException(option, value, e);
        }
    }

    public static <T> List<T> createFromList(String raw, TypedOption<T> option) {
        if (raw == null) {
            return Collections.emptyList();
        }
        String[] segments = raw.split(option.getListSeparator());
        return Arrays.stream(segments).map(s -> DefaultCommandLine.create(s.trim(), option)).collect(Collectors.toList());
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    void setValidity(boolean validity) {
        this.valid = validity;
    }

    @Override
    public boolean isAskingForHelp() {
        for (Option option : this.cli.getOptions()) {
            if (!option.isHelp() || !this.isSeenInCommandLine(option)) continue;
            return true;
        }
        return false;
    }
}

