/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.ServiceHelper;
import io.vertx.core.spi.FutureFactory;

@VertxGen
public interface Future<T>
extends AsyncResult<T> {
    public static final FutureFactory factory = ServiceHelper.loadFactory(FutureFactory.class);

    public static <T> Future<T> future() {
        return factory.future();
    }

    public static <T> Future<T> succeededFuture() {
        return factory.completedFuture();
    }

    public static <T> Future<T> succeededFuture(T result) {
        return factory.completedFuture(result);
    }

    @GenIgnore
    public static <T> Future<T> failedFuture(Throwable t) {
        return factory.completedFuture(t);
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        return factory.completedFuture(failureMessage, true);
    }

    public boolean isComplete();

    @Fluent
    public Future<T> setHandler(Handler<AsyncResult<T>> var1);

    public void complete(T var1);

    public void complete();

    public void fail(Throwable var1);

    public void fail(String var1);

    @Override
    public T result();

    @Override
    public Throwable cause();

    @Override
    public boolean succeeded();

    @Override
    public boolean failed();

    default public <U> void compose(Handler<T> handler, Future<U> next) {
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                try {
                    handler.handle(ar.result());
                }
                catch (Throwable err) {
                    if (next.isComplete()) {
                        throw err;
                    }
                    next.fail(err);
                }
            } else {
                next.fail(ar.cause());
            }
        });
    }

    @CacheReturn
    default public Handler<AsyncResult<T>> completer() {
        return ar -> {
            if (ar.succeeded()) {
                this.complete(ar.result());
            } else {
                ar.failed();
            }
        };
    }
}

