/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.vertx.java.core.VertxException;
import org.vertx.java.core.json.EncodeException;
import org.vertx.java.core.json.JsonElement;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.json.impl.Base64;
import org.vertx.java.core.json.impl.Json;

public class JsonArray
extends JsonElement
implements Iterable<Object> {
    protected List list;

    public JsonArray(List list) {
        this(list, true);
    }

    public JsonArray(Object[] array) {
        this(new ArrayList<Object>(Arrays.asList(array)), true);
    }

    protected JsonArray(List list, boolean copy) {
        this.list = copy ? this.convertList(list) : list;
    }

    public JsonArray() {
        this.list = new ArrayList();
    }

    public JsonArray(String jsonString) {
        this.list = (List)Json.decodeValue(jsonString, List.class);
    }

    public JsonArray addString(String str) {
        this.list.add(str);
        return this;
    }

    public JsonArray addObject(JsonObject value) {
        this.list.add(value == null ? null : value.map);
        return this;
    }

    public JsonArray addArray(JsonArray value) {
        this.list.add(value == null ? null : value.list);
        return this;
    }

    public JsonArray addElement(JsonElement value) {
        if (value == null) {
            this.list.add(null);
            return this;
        }
        if (value.isArray()) {
            return this.addArray(value.asArray());
        }
        return this.addObject(value.asObject());
    }

    public JsonArray addNumber(Number value) {
        this.list.add(value);
        return this;
    }

    public JsonArray addBoolean(Boolean value) {
        this.list.add(value);
        return this;
    }

    public JsonArray addBinary(byte[] value) {
        String encoded = value == null ? null : Base64.encodeBytes(value);
        this.list.add(encoded);
        return this;
    }

    public JsonArray add(Object value) {
        if (value == null) {
            this.list.add(null);
        } else if (value instanceof JsonObject) {
            this.addObject((JsonObject)value);
        } else if (value instanceof JsonArray) {
            this.addArray((JsonArray)value);
        } else if (value instanceof String) {
            this.addString((String)value);
        } else if (value instanceof Number) {
            this.addNumber((Number)value);
        } else if (value instanceof Boolean) {
            this.addBoolean((Boolean)value);
        } else if (value instanceof byte[]) {
            this.addBinary((byte[])value);
        } else {
            throw new VertxException("Cannot add objects of class " + value.getClass() + " to JsonArray");
        }
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public <T> T get(int index) {
        return this.convertObject(this.list.get(index));
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            Iterator<Object> iter;
            {
                this.iter = JsonArray.this.list.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Object next() {
                return JsonArray.this.convertObject(this.iter.next());
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    public boolean contains(Object value) {
        return this.list.contains(value);
    }

    public String encode() throws EncodeException {
        return Json.encode(this.list);
    }

    public String encodePrettily() throws EncodeException {
        return Json.encodePrettily(this.list);
    }

    public JsonArray copy() {
        return new JsonArray(this.list, true);
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArray that = (JsonArray)o;
        if (this.list.size() != that.list.size()) {
            return false;
        }
        Iterator iter = that.list.iterator();
        for (Object entry : this.list) {
            Object other = iter.next();
            if (!(entry == null ? other != null : !entry.equals(other))) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray() {
        return this.convertList(this.list).toArray();
    }

    public List toList() {
        return this.convertList(this.list);
    }

    private <T> T convertObject(Object obj) {
        Object retVal = obj;
        if (obj != null) {
            if (obj instanceof List) {
                retVal = new JsonArray((List)obj, false);
            } else if (obj instanceof Map) {
                retVal = new JsonObject((Map)obj, false);
            }
        }
        return (T)retVal;
    }
}

