/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.file.impl;

import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import org.vertx.java.core.file.FileProps;

public class DefaultFileProps
implements FileProps {
    private final Date creationTime;
    private final Date lastAccessTime;
    private final Date lastModifiedTime;
    private final boolean isDirectory;
    private final boolean isOther;
    private final boolean isRegularFile;
    private final boolean isSymbolicLink;
    private final long size;

    public DefaultFileProps(BasicFileAttributes attrs) {
        this.creationTime = new Date(attrs.creationTime().toMillis());
        this.lastModifiedTime = new Date(attrs.lastModifiedTime().toMillis());
        this.lastAccessTime = new Date(attrs.lastAccessTime().toMillis());
        this.isDirectory = attrs.isDirectory();
        this.isOther = attrs.isOther();
        this.isRegularFile = attrs.isRegularFile();
        this.isSymbolicLink = attrs.isSymbolicLink();
        this.size = attrs.size();
    }

    @Override
    public Date creationTime() {
        return this.creationTime;
    }

    @Override
    public Date lastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public Date lastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isOther() {
        return this.isOther;
    }

    @Override
    public boolean isRegularFile() {
        return this.isRegularFile;
    }

    @Override
    public boolean isSymbolicLink() {
        return this.isSymbolicLink;
    }

    @Override
    public long size() {
        return this.size;
    }
}

