/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import io.netty.util.CharsetUtil;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BooleanMessage;
import org.vertx.java.core.eventbus.impl.BufferMessage;
import org.vertx.java.core.eventbus.impl.ByteArrayMessage;
import org.vertx.java.core.eventbus.impl.CharacterMessage;
import org.vertx.java.core.eventbus.impl.DefaultEventBus;
import org.vertx.java.core.eventbus.impl.DoubleMessage;
import org.vertx.java.core.eventbus.impl.FloatMessage;
import org.vertx.java.core.eventbus.impl.IntMessage;
import org.vertx.java.core.eventbus.impl.JsonArrayMessage;
import org.vertx.java.core.eventbus.impl.JsonObjectMessage;
import org.vertx.java.core.eventbus.impl.LongMessage;
import org.vertx.java.core.eventbus.impl.ShortMessage;
import org.vertx.java.core.eventbus.impl.StringMessage;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.ServerID;

public abstract class BaseMessage<U>
implements Message<U> {
    private static final Logger log = LoggerFactory.getLogger(BaseMessage.class);
    protected U body;
    protected ServerID sender;
    protected DefaultEventBus bus;
    protected String address;
    protected String replyAddress;
    protected boolean send;

    protected BaseMessage(boolean send, String address, U body) {
        this.send = send;
        this.body = body;
        this.address = address;
    }

    @Override
    public U body() {
        return this.body;
    }

    @Override
    public String replyAddress() {
        return this.replyAddress;
    }

    @Override
    public void reply() {
        this.sendReply(DefaultEventBus.createMessage(true, this.replyAddress, null), null);
    }

    @Override
    public void reply(Object message) {
        this.reply(message, null);
    }

    @Override
    public void reply(JsonObject message) {
        this.reply(message, null);
    }

    @Override
    public void reply(JsonArray message) {
        this.reply(message, null);
    }

    @Override
    public void reply(String message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Buffer message) {
        this.reply(message, null);
    }

    @Override
    public void reply(byte[] message) {
        this.reply(message, (Handler)null);
    }

    @Override
    public void reply(Integer message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Long message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Short message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Character message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Boolean message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Float message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Double message) {
        this.reply(message, null);
    }

    @Override
    public <T> void reply(Handler<Message<T>> replyHandler) {
        this.sendReply(DefaultEventBus.createMessage(true, this.replyAddress, null), replyHandler);
    }

    @Override
    public <T> void reply(Object message, Handler<Message<T>> replyHandler) {
        this.sendReply(DefaultEventBus.createMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(JsonObject message, Handler<Message<T>> replyHandler) {
        this.sendReply(new JsonObjectMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(JsonArray message, Handler<Message<T>> replyHandler) {
        this.sendReply(new JsonArrayMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(String message, Handler<Message<T>> replyHandler) {
        this.sendReply(new StringMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(Buffer message, Handler<Message<T>> replyHandler) {
        this.sendReply(new BufferMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(byte[] message, Handler<Message<T>> replyHandler) {
        this.sendReply(new ByteArrayMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(Integer message, Handler<Message<T>> replyHandler) {
        this.sendReply(new IntMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(Long message, Handler<Message<T>> replyHandler) {
        this.sendReply(new LongMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(Short message, Handler<Message<T>> replyHandler) {
        this.sendReply(new ShortMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(Character message, Handler<Message<T>> replyHandler) {
        this.sendReply(new CharacterMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(Boolean message, Handler<Message<T>> replyHandler) {
        this.sendReply(new BooleanMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(Float message, Handler<Message<T>> replyHandler) {
        this.sendReply(new FloatMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void reply(Double message, Handler<Message<T>> replyHandler) {
        this.sendReply(new DoubleMessage(true, this.replyAddress, message), replyHandler);
    }

    protected BaseMessage(Buffer readBuff) {
        int pos = 1;
        byte bsend = readBuff.getByte(pos);
        this.send = bsend == 0;
        int addressLength = readBuff.getInt(++pos);
        byte[] addressBytes = readBuff.getBytes(pos += 4, pos + addressLength);
        this.address = new String(addressBytes, CharsetUtil.UTF_8);
        int port = readBuff.getInt(pos += addressLength);
        int hostLength = readBuff.getInt(pos += 4);
        byte[] hostBytes = readBuff.getBytes(pos += 4, pos + hostLength);
        String host = new String(hostBytes, CharsetUtil.UTF_8);
        this.sender = new ServerID(port, host);
        int replyAddressLength = readBuff.getInt(pos += hostLength);
        pos += 4;
        if (replyAddressLength > 0) {
            byte[] replyAddressBytes = readBuff.getBytes(pos, pos + replyAddressLength);
            pos += replyAddressLength;
            this.replyAddress = new String(replyAddressBytes, CharsetUtil.UTF_8);
        } else {
            this.replyAddress = null;
        }
        this.readBody(pos, readBuff);
    }

    protected void write(NetSocket socket) {
        int length = 6 + this.address.length() + 1 + 4 * this.sender.host.length() + 4 + (this.replyAddress == null ? 0 : this.replyAddress.length()) + this.getBodyLength();
        Buffer totBuff = new Buffer(length);
        totBuff.appendInt(0);
        totBuff.appendByte(this.type());
        totBuff.appendByte(this.send ? (byte)0 : 1);
        this.writeString(totBuff, this.address);
        totBuff.appendInt(this.sender.port);
        this.writeString(totBuff, this.sender.host);
        if (this.replyAddress != null) {
            this.writeString(totBuff, this.replyAddress);
        } else {
            totBuff.appendInt(0);
        }
        this.writeBody(totBuff);
        totBuff.setInt(0, totBuff.length() - 4);
        socket.write(totBuff);
    }

    protected void writeString(Buffer buff, String str) {
        byte[] strBytes = str.getBytes(CharsetUtil.UTF_8);
        buff.appendInt(strBytes.length);
        buff.appendBytes(strBytes);
    }

    protected abstract byte type();

    protected abstract Message<U> copy();

    protected abstract void readBody(int var1, Buffer var2);

    protected abstract void writeBody(Buffer var1);

    protected abstract int getBodyLength();

    private <T> void sendReply(BaseMessage msg, Handler<Message<T>> replyHandler) {
        if (this.bus != null && this.replyAddress != null) {
            this.bus.sendReply(this.sender, msg, replyHandler);
        }
    }
}

