/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.type;

import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MapperKind;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ArrayTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.DataObjectInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.MapperInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.PrimitiveTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeUse;
import io.vertx.codegen.type.TypeVariableInfo;
import io.vertx.codegen.type.VoidTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class TypeMirrorFactory {
    private static final ModuleInfo VERTX_CORE_MOD = new ModuleInfo("io.vertx.core", "vertx", "io.vertx");
    private static final ClassTypeInfo JSON_OBJECT = new ClassTypeInfo(ClassKind.JSON_OBJECT, "io.vertx.core.json.JsonObject", VERTX_CORE_MOD, false, Collections.emptyList(), null);
    private static final ClassTypeInfo JSON_ARRAY = new ClassTypeInfo(ClassKind.JSON_ARRAY, "io.vertx.core.json.JsonArray", VERTX_CORE_MOD, false, Collections.emptyList(), null);
    private static final ClassTypeInfo STRING = new ClassTypeInfo(ClassKind.STRING, "java.lang.String", null, false, Collections.emptyList(), null);
    final Elements elementUtils;
    final Types typeUtils;
    final Map<String, MapperInfo> serializers = new HashMap<String, MapperInfo>();
    final Map<String, MapperInfo> deserializers = new HashMap<String, MapperInfo>();

    public TypeMirrorFactory(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
    }

    public void addDataObjectDeserializer(Element elt, TypeMirror dataObjectType, MapperInfo mapper) {
        String key = dataObjectType.toString();
        if (this.serializers.containsKey(key) && !this.serializers.get(key).getJsonType().equals(mapper.getJsonType())) {
            throw new GenException(elt, "Mapper cannot declare mixed JSON types");
        }
        this.deserializers.putIfAbsent(key, mapper);
    }

    public void addDataObjectSerializer(Element elt, TypeMirror dataObjectType, MapperInfo mapper) {
        String key = dataObjectType.toString();
        if (this.deserializers.containsKey(key) && !this.deserializers.get(key).getJsonType().equals(mapper.getJsonType())) {
            throw new GenException(elt, "Mapper cannot declare mixed JSON types " + this.deserializers.get(key).getJsonType() + " " + mapper.getJsonType());
        }
        this.serializers.putIfAbsent(key, mapper);
    }

    public TypeInfo create(TypeMirror type) {
        return this.create(null, type);
    }

    public TypeInfo create(TypeUse use, TypeMirror type) {
        switch (type.getKind()) {
            case VOID: {
                return VoidTypeInfo.INSTANCE;
            }
            case ERROR: 
            case DECLARED: {
                return this.create(use, (DeclaredType)type);
            }
            case DOUBLE: 
            case LONG: 
            case FLOAT: 
            case CHAR: 
            case BYTE: 
            case SHORT: 
            case BOOLEAN: 
            case INT: {
                if (use != null && use.isNullable()) {
                    throw new IllegalArgumentException("Primitive types cannot be annotated with @Nullable");
                }
                return PrimitiveTypeInfo.PRIMITIVES.get(type.getKind().name().toLowerCase());
            }
            case TYPEVAR: {
                return this.create(use, (TypeVariable)type);
            }
            case ARRAY: {
                return this.create(use, (ArrayType)type);
            }
        }
        throw new IllegalArgumentException("Illegal type " + type + " of kind " + (Object)((Object)type.getKind()));
    }

    public TypeInfo create(DeclaredType type) {
        return this.create(null, type);
    }

    public TypeInfo create(TypeUse use, DeclaredType type) {
        return this.create(use, type, true);
    }

    /*
     * WARNING - void declaration
     */
    public TypeInfo create(TypeUse use, DeclaredType type, boolean checkTypeArgs) {
        void var13_22;
        boolean proxyGen;
        boolean nullable = use != null && use.isNullable();
        TypeElement elt = (TypeElement)type.asElement();
        PackageElement pkgElt = this.elementUtils.getPackageOf(elt);
        ModuleInfo module = ModuleInfo.resolve(this.elementUtils, pkgElt);
        String fqcn = elt.getQualifiedName().toString();
        String simpleName = elt.getSimpleName().toString();
        boolean bl = proxyGen = elt.getAnnotation(ProxyGen.class) != null;
        if (elt.getKind() == ElementKind.ENUM) {
            ArrayList<String> values = new ArrayList<String>();
            for (Element element : elt.getEnclosedElements()) {
                if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
                values.add(element.getSimpleName().toString());
            }
            boolean gen = elt.getAnnotation(VertxGen.class) != null;
            return new EnumTypeInfo(fqcn, gen, values, module, nullable);
        }
        ClassKind kind = ClassKind.getKind(fqcn, elt.getAnnotation(VertxGen.class) != null);
        List<? extends TypeMirror> typeArgs = type.getTypeArguments();
        if (checkTypeArgs && typeArgs.size() > 0) {
            ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>(typeArgs.size());
            for (int i = 0; i < typeArgs.size(); ++i) {
                TypeUse argUse = use != null ? use.getArg(fqcn, i) : null;
                TypeInfo typeArgDesc = this.create(argUse, typeArgs.get(i));
                arrayList.add(typeArgDesc);
            }
            ClassTypeInfo raw2 = (ClassTypeInfo)this.create(null, (DeclaredType)type.asElement().asType(), false);
            return new ParameterizedTypeInfo(raw2, nullable, arrayList);
        }
        if (kind == ClassKind.BOXED_PRIMITIVE) {
            ClassTypeInfo classTypeInfo = ClassTypeInfo.PRIMITIVES.get(fqcn);
            if (nullable) {
                ClassTypeInfo classTypeInfo2 = new ClassTypeInfo(classTypeInfo.kind, classTypeInfo.name, classTypeInfo.module, true, classTypeInfo.params, null);
            }
        } else {
            MapperInfo serializer = this.serializers.get(type.toString());
            MapperInfo deserializer = this.deserializers.get(type.toString());
            DataObjectInfo dataObject = null;
            if (elt.getAnnotation(DataObject.class) != null) {
                ClassKind serializable = Helper.getAnnotatedDataObjectAnnotatedSerializationType(this.elementUtils, elt);
                ClassKind deserializable = Helper.getAnnotatedDataObjectDeserialisationType(this.elementUtils, this.typeUtils, elt);
                if (serializer == null && serializable != null) {
                    serializer = new MapperInfo();
                    serializer.setQualifiedName(fqcn);
                    serializer.setKind(MapperKind.SELF);
                    if (serializable == ClassKind.JSON_OBJECT) {
                        serializer.setTargetType(JSON_OBJECT);
                        serializer.setSelectors(Collections.singletonList("toJson"));
                    } else {
                        serializer.setTargetType(STRING);
                        serializer.setSelectors(Collections.singletonList("toJson"));
                    }
                }
                if (deserializer == null && deserializable != null) {
                    deserializer = new MapperInfo();
                    deserializer.setQualifiedName(fqcn);
                    deserializer.setKind(MapperKind.SELF);
                    if (deserializable == ClassKind.JSON_OBJECT) {
                        deserializer.setTargetType(JSON_OBJECT);
                    } else {
                        deserializer.setTargetType(STRING);
                    }
                }
                dataObject = new DataObjectInfo(true, serializer, deserializer);
            } else if (serializer != null || deserializer != null) {
                dataObject = new DataObjectInfo(false, serializer, deserializer);
            }
            List<TypeParamInfo.Class> typeParams = this.createTypeParams(type);
            if (kind == ClassKind.API) {
                VertxGen genAnn = elt.getAnnotation(VertxGen.class);
                TypeInfo handlerArg = null;
                TypeElement parameterizedElt = this.elementUtils.getTypeElement("io.vertx.core.Handler");
                TypeMirror parameterizedType = parameterizedElt.asType();
                TypeMirror rawType = this.typeUtils.erasure(parameterizedType);
                if (this.typeUtils.isSubtype(type, rawType)) {
                    TypeMirror resolved = Helper.resolveTypeParameter(this.typeUtils, type, parameterizedElt.getTypeParameters().get(0));
                    if (resolved.getKind() == TypeKind.DECLARED) {
                        DeclaredType dt = (DeclaredType)resolved;
                        TypeElement a = (TypeElement)dt.asElement();
                        if (!a.getQualifiedName().toString().equals("io.vertx.core.AsyncResult")) {
                            handlerArg = this.create(resolved);
                        }
                    } else {
                        handlerArg = this.create(resolved);
                    }
                }
                ApiTypeInfo apiTypeInfo = new ApiTypeInfo(fqcn, genAnn.concrete(), typeParams, handlerArg, module, nullable, proxyGen, dataObject);
            } else {
                ClassTypeInfo classTypeInfo = new ClassTypeInfo(kind, fqcn, module, nullable, typeParams, dataObject);
            }
        }
        return var13_22;
    }

    public TypeVariableInfo create(TypeUse use, TypeVariable type) {
        TypeParameterElement elt = (TypeParameterElement)type.asElement();
        TypeParamInfo param = TypeParamInfo.create(elt);
        return new TypeVariableInfo(param, use != null && use.isNullable(), elt.getSimpleName().toString());
    }

    public ArrayTypeInfo create(TypeUse use, ArrayType type) {
        TypeMirror componentType = type.getComponentType();
        return new ArrayTypeInfo(this.create(componentType), use != null && use.isNullable());
    }

    private List<TypeParamInfo.Class> createTypeParams(DeclaredType type) {
        ArrayList<TypeParamInfo.Class> typeParams = new ArrayList<TypeParamInfo.Class>();
        TypeElement elt = (TypeElement)type.asElement();
        List<? extends TypeParameterElement> typeParamElts = elt.getTypeParameters();
        for (int index = 0; index < typeParamElts.size(); ++index) {
            TypeParameterElement typeParamElt = typeParamElts.get(index);
            typeParams.add(new TypeParamInfo.Class(elt.getQualifiedName().toString(), index, typeParamElt.getSimpleName().toString()));
        }
        return typeParams;
    }
}

