/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.codegen.Case;
import io.vertx.codegen.CodeGen;
import io.vertx.codegen.CodeGenerator;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.Model;
import io.vertx.codegen.Template;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.TypeNameTranslator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.mvel2.MVEL;

@SupportedOptions(value={"codegen.output", "codegen.generators"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class CodeGenProcessor
extends AbstractProcessor {
    private static final int JAVA = 0;
    private static final int RESOURCE = 1;
    private static final int OTHER = 2;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = Logger.getLogger(CodeGenProcessor.class.getName());
    private File outputDirectory;
    private List<CodeGenerator> codeGenerators;
    private Map<String, GeneratedFile> generatedFiles = new HashMap<String, GeneratedFile>();
    private Map<String, GeneratedFile> generatedResources = new HashMap<String, GeneratedFile>();
    private Map<String, String> relocations = new HashMap<String, String>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Arrays.asList(VertxGen.class, ProxyGen.class, DataObject.class, DataObject.class, ModuleGen.class).stream().map(Class::getName).collect(Collectors.toSet());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.generatedFiles.clear();
        this.generatedResources.clear();
    }

    protected Predicate<CodeGenerator> filterGenerators() {
        String generatorsOption = this.processingEnv.getOptions().get("codegen.generators");
        if (generatorsOption == null && (generatorsOption = this.processingEnv.getOptions().get("codeGenerators")) != null) {
            log.warning("Please use 'codegen.generators' option instead of 'codeGenerators' option");
        }
        if (generatorsOption != null) {
            List wanted = Stream.of(generatorsOption.split(",")).map(String::trim).map(Pattern::compile).collect(Collectors.toList());
            return cg -> wanted.stream().anyMatch(p -> p.matcher(cg.name).matches());
        }
        return null;
    }

    protected List<CodeGenerator> loadGenerators() {
        ArrayList<CodeGenerator> generators = new ArrayList<CodeGenerator>();
        Enumeration<Object> descriptors = Collections.emptyEnumeration();
        try {
            descriptors = CodeGenProcessor.class.getClassLoader().getResources("codegen.json");
        }
        catch (IOException ignore) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not load code generator descriptors");
        }
        HashSet<String> templates = new HashSet<String>();
        while (descriptors.hasMoreElements()) {
            URL descriptor = (URL)descriptors.nextElement();
            try {
                Scanner scanner = new Scanner(descriptor.openStream(), "UTF-8").useDelimiter("\\A");
                Throwable throwable = null;
                try {
                    String s = scanner.next();
                    ObjectNode obj = (ObjectNode)mapper.readTree(s);
                    String name = obj.get("name").asText();
                    ArrayNode generatorsCfg = (ArrayNode)obj.get("generators");
                    for (JsonNode generator : generatorsCfg) {
                        boolean incremental;
                        HashSet<String> kinds = new HashSet<String>();
                        if (generator.get("kind").isArray()) {
                            generator.get("kind").forEach(v -> kinds.add(v.asText()));
                        } else {
                            kinds.add(generator.get("kind").asText());
                        }
                        JsonNode templateFilenameNode = generator.get("templateFilename");
                        if (templateFilenameNode == null) {
                            templateFilenameNode = generator.get("templateFileName");
                        }
                        String templateFilename = templateFilenameNode.asText();
                        JsonNode filenameNode = generator.get("filename");
                        if (filenameNode == null) {
                            filenameNode = generator.get("fileName");
                        }
                        String filename = filenameNode.asText();
                        boolean bl = incremental = generator.has("incremental") && generator.get("incremental").asBoolean();
                        if (templates.contains(templateFilename)) continue;
                        templates.add(templateFilename);
                        generators.add(new CodeGenerator(name, kinds, incremental, filename, templateFilename));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (scanner == null) continue;
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    scanner.close();
                }
            }
            catch (Exception e) {
                String msg = "Could not load code generator " + descriptor;
                log.log(Level.SEVERE, msg, e);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            }
        }
        return generators;
    }

    private Collection<CodeGenerator> getCodeGenerators() {
        if (this.codeGenerators == null) {
            String outputDirectoryOption = this.processingEnv.getOptions().get("codegen.output");
            if (outputDirectoryOption == null && (outputDirectoryOption = this.processingEnv.getOptions().get("outputDirectory")) != null) {
                log.warning("Please use 'codegen.output' option instead of 'outputDirectory' option");
            }
            if (outputDirectoryOption != null) {
                this.outputDirectory = new File(outputDirectoryOption);
                if (!this.outputDirectory.exists()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Output directory " + outputDirectoryOption + " does not exist");
                }
                if (!this.outputDirectory.isDirectory()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Output directory " + outputDirectoryOption + " is not a directory");
                }
            }
            List<CodeGenerator> generators = this.loadGenerators();
            Predicate<CodeGenerator> filter = this.filterGenerators();
            if (filter != null) {
                generators = generators.stream().filter(filter).collect(Collectors.toList());
            }
            generators.forEach(gen -> {
                Template template = new Template(gen.templateFilename);
                template.setOptions(this.processingEnv.getOptions());
                gen.template = template;
                gen.filenameExpr = MVEL.compileExpression((String)gen.filename);
                log.info("Loaded " + gen.name + " code generator");
            });
            this.relocations = this.processingEnv.getOptions().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("codegen.output.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("codegen.output.".length()), Map.Entry::getValue));
            this.codeGenerators = generators;
        }
        return this.codeGenerators;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            Collection<CodeGenerator> codeGenerators = this.getCodeGenerators();
            if (!roundEnv.errorRaised()) {
                CodeGen codegen = new CodeGen(this.processingEnv, roundEnv, this.getClass().getClassLoader());
                HashMap generatedClasses = new HashMap();
                codegen.getModels().forEach(entry -> {
                    try {
                        Model model = (Model)entry.getValue();
                        HashMap<String, Object> vars = new HashMap<String, Object>();
                        vars.put("helper", new Helper());
                        vars.put("options", this.processingEnv.getOptions());
                        vars.put("fileSeparator", File.separator);
                        vars.put("fqn", model.getFqn());
                        vars.put("module", model.getModule());
                        vars.put("model", model);
                        vars.putAll(model.getVars());
                        vars.putAll(ClassKind.vars());
                        vars.putAll(MethodKind.vars());
                        vars.putAll(Case.vars());
                        for (CodeGenerator codeGenerator : codeGenerators) {
                            List processings;
                            int kind;
                            String relativeName;
                            vars.putAll(TypeNameTranslator.vars(codeGenerator.name));
                            if (!codeGenerator.kind.contains(model.getKind()) || (relativeName = (String)MVEL.executeExpression((Object)codeGenerator.filenameExpr, vars)) == null) continue;
                            if (relativeName.endsWith(".java") && !relativeName.contains("/")) {
                                String relocation = this.relocations.get(codeGenerator.name);
                                if (relocation != null) {
                                    kind = 2;
                                    relativeName = relocation + '/' + relativeName.substring(0, relativeName.length() - ".java".length()).replace('.', '/') + ".java";
                                } else {
                                    kind = 0;
                                }
                            } else {
                                kind = relativeName.startsWith("resources/") ? 1 : 2;
                            }
                            if (kind == 0) {
                                String fqn = relativeName.substring(0, relativeName.length() - ".java".length());
                                if (this.processingEnv.getElementUtils().getTypeElement(fqn) != null) continue;
                                List processings2 = generatedClasses.computeIfAbsent(fqn, GeneratedFile::new);
                                processings2.add(new ModelProcessing(model, codeGenerator));
                                continue;
                            }
                            if (kind == 1) {
                                relativeName = relativeName.substring("resources/".length());
                                processings = this.generatedResources.computeIfAbsent(relativeName, GeneratedFile::new);
                                processings.add(new ModelProcessing(model, codeGenerator));
                                continue;
                            }
                            processings = this.generatedFiles.computeIfAbsent(relativeName, GeneratedFile::new);
                            processings.add(new ModelProcessing(model, codeGenerator));
                        }
                    }
                    catch (GenException e) {
                        this.reportGenException(e);
                    }
                    catch (Exception e) {
                        this.reportException(e, (Element)entry.getKey());
                    }
                });
                generatedClasses.values().forEach(generated -> {
                    block15: {
                        try {
                            String content = generated.generate();
                            if (content.length() <= 0) break block15;
                            JavaFileObject target = this.processingEnv.getFiler().createSourceFile(generated.uri, new Element[0]);
                            try (Writer writer = target.openWriter();){
                                writer.write(content);
                            }
                            log.info("Generated model " + ((ModelProcessing)generated.get((int)0)).model.getFqn() + ": " + generated.uri);
                        }
                        catch (GenException e) {
                            this.reportGenException(e);
                        }
                        catch (Exception e) {
                            this.reportException(e, ((ModelProcessing)generated.get((int)0)).model.getElement());
                        }
                    }
                });
            }
        } else {
            for (GeneratedFile generated2 : this.generatedResources.values()) {
                try {
                    boolean createSource;
                    String content = generated2.generate();
                    if (content.length() <= 0) continue;
                    try (Writer w = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", generated2.uri, new Element[0]).openWriter();){
                        w.write(content);
                    }
                    try {
                        this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", generated2.uri);
                        createSource = true;
                    }
                    catch (FilerException e) {
                        createSource = false;
                    }
                    if (createSource) {
                        try (Writer w = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", generated2.uri, new Element[0]).openWriter();){
                            w.write(content);
                        }
                    }
                    log.info("Generated model " + ((ModelProcessing)generated2.get((int)0)).model.getFqn() + ": " + generated2.uri);
                }
                catch (GenException e) {
                    this.reportGenException(e);
                }
                catch (Exception e) {
                    this.reportException(e, ((ModelProcessing)generated2.get((int)0)).model.getElement());
                }
            }
            if (this.outputDirectory != null) {
                this.generatedFiles.values().forEach(generated -> {
                    File file = new File(this.outputDirectory, generated.uri);
                    Helper.ensureParentDir(file);
                    String content = generated.generate();
                    if (content.length() > 0) {
                        try (FileWriter fileWriter = new FileWriter(file);){
                            fileWriter.write(content);
                        }
                        catch (GenException e) {
                            this.reportGenException(e);
                        }
                        catch (Exception e) {
                            this.reportException(e, ((ModelProcessing)generated.get((int)0)).model.getElement());
                        }
                        log.info("Generated model " + ((ModelProcessing)generated.get((int)0)).model.getFqn() + ": " + generated.uri);
                    }
                });
            }
        }
        return true;
    }

    private void reportGenException(GenException e) {
        String name = e.element.toString();
        if (e.element.getKind() == ElementKind.METHOD) {
            name = e.element.getEnclosingElement() + "#" + name;
        }
        String msg = "Could not generate model for " + name + ": " + e.msg;
        log.log(Level.SEVERE, msg, e);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e.element);
    }

    private void reportException(Exception e, Element elt) {
        String msg = "Could not generate element for " + elt + ": " + e.getMessage();
        log.log(Level.SEVERE, msg, e);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, elt);
    }

    private static class GeneratedFile
    extends ArrayList<ModelProcessing> {
        final String uri;
        final Map<String, Object> session = new HashMap<String, Object>();

        public GeneratedFile(String uri) {
            this.uri = uri;
        }

        @Override
        public boolean add(ModelProcessing modelProcessing) {
            if (!modelProcessing.generator.incremental) {
                this.clear();
            }
            return super.add(modelProcessing);
        }

        String generate() {
            Collections.sort(this, (o1, o2) -> o1.model.getElement().getSimpleName().toString().compareTo(o2.model.getElement().getSimpleName().toString()));
            int index = 0;
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                ModelProcessing processing = (ModelProcessing)this.get(i);
                HashMap<String, Object> vars = new HashMap<String, Object>();
                vars.putAll(TypeNameTranslator.vars(processing.generator.name));
                if (processing.generator.incremental) {
                    vars.put("incrementalIndex", index++);
                    vars.put("incrementalSize", this.size());
                    vars.put("session", this.session);
                }
                try {
                    String part = processing.generator.template.render(processing.model, vars);
                    if (part == null) continue;
                    buffer.append(part);
                    continue;
                }
                catch (GenException e) {
                    throw e;
                }
                catch (Exception e) {
                    GenException genException = new GenException(processing.model.getElement(), e.getMessage());
                    genException.initCause(e);
                    throw genException;
                }
            }
            return buffer.toString();
        }
    }

    private static class ModelProcessing {
        final Model model;
        final CodeGenerator generator;

        public ModelProcessing(Model model, CodeGenerator generator) {
            this.model = model;
            this.generator = generator;
        }
    }
}

